/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.parser;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jet.core.parser.ITemplateInput;
import org.eclipse.jet.core.parser.ITemplateResolver;
import org.eclipse.jet.core.parser.RecursiveIncludeException;

public abstract class AbstractTemplateResolver
implements ITemplateResolver {
    private static final String SLASH = "/";
    private final URI[] baseLocations;

    protected AbstractTemplateResolver(URI[] baseLocations) {
        if (baseLocations == null) {
            throw new NullPointerException();
        }
        this.baseLocations = new URI[baseLocations.length];
        int i = 0;
        while (i < baseLocations.length) {
            if (baseLocations[i] == null) {
                throw new NullPointerException();
            }
            this.baseLocations[i] = baseLocations[i].toString().endsWith(SLASH) ? baseLocations[i] : baseLocations[i].resolve(String.valueOf(baseLocations[i].getPath()) + SLASH);
            ++i;
        }
    }

    protected AbstractTemplateResolver(URI baseLocation) {
        this(new URI[]{baseLocation});
    }

    public final URI[] getBaseLocations() {
        URI[] tempArray = new URI[this.baseLocations.length];
        System.arraycopy(this.baseLocations, 0, tempArray, 0, this.baseLocations.length);
        return tempArray;
    }

    public final ITemplateInput getIncludedInput(String includePath, ITemplateInput[] activeInputs) throws RecursiveIncludeException {
        if (includePath == null || activeInputs == null) {
            throw new NullPointerException();
        }
        if (activeInputs.length == 0) {
            throw new IllegalArgumentException();
        }
        String templatePath = this.resolveToTemplatePath(includePath, activeInputs[activeInputs.length - 1].getTemplatePath());
        int baseLocationsStartIndex = 0;
        boolean recursiveInclude = templatePath.equals(activeInputs[activeInputs.length - 1].getTemplatePath());
        if (recursiveInclude) {
            URI currentBaseURI = activeInputs[activeInputs.length - 1].getBaseLocation();
            baseLocationsStartIndex = 1 + this.findBaseLocationIndex(currentBaseURI);
        }
        int i = baseLocationsStartIndex;
        while (i < this.baseLocations.length) {
            int j = 0;
            while (j < activeInputs.length) {
                if (templatePath.equals(activeInputs[j].getTemplatePath()) && this.baseLocations[i].equals(activeInputs[j].getBaseLocation())) {
                    throw new RecursiveIncludeException(templatePath, this.baseLocations[i], activeInputs);
                }
                ++j;
            }
            if (this.inputExists(this.baseLocations[i], templatePath)) {
                return this.createTemplateInput(this.baseLocations[i], templatePath);
            }
            ++i;
        }
        return null;
    }

    private String resolveToTemplatePath(String includePath, String templatePath) {
        try {
            URI currentURI = new URI(null, templatePath, null);
            URI resolvedURI = currentURI.resolve(new URI(null, includePath, null));
            return resolvedURI.getSchemeSpecificPart();
        }
        catch (URISyntaxException e) {
            IllegalArgumentException wrapper = new IllegalArgumentException();
            wrapper.initCause(e);
            throw wrapper;
        }
    }

    private int findBaseLocationIndex(URI currentBaseURL) {
        int i = 0;
        while (i < this.baseLocations.length) {
            if (currentBaseURL.equals(this.baseLocations[i])) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    public final ITemplateInput getInput(String templatePath) {
        int i = 0;
        while (i < this.baseLocations.length) {
            if (this.inputExists(this.baseLocations[i], templatePath)) {
                return this.createTemplateInput(this.baseLocations[i], templatePath);
            }
            ++i;
        }
        return null;
    }

    protected abstract boolean inputExists(URI var1, String var2);

    protected abstract ITemplateInput createTemplateInput(URI var1, String var2);
}

