/**
 * <copyright>
 * </copyright>
 *
 * $Id: ProfilerAdapterFactory.java,v 1.2 2010/05/04 07:37:59 lgoubet Exp $
 */
package org.eclipse.acceleo.profiler.util;

import org.eclipse.acceleo.profiler.Internal;
import org.eclipse.acceleo.profiler.LoopProfileEntry;
import org.eclipse.acceleo.profiler.ProfileEntry;
import org.eclipse.acceleo.profiler.ProfileResource;
import org.eclipse.acceleo.profiler.ProfilerPackage;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides an adapter
 * <code>createXXX</code> method for each class of the model. <!-- end-user-doc -->
 * 
 * @see org.eclipse.acceleo.profiler.ProfilerPackage
 * @generated
 * @since 3.0
 */
public class ProfilerAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected static ProfilerPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ProfilerAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = ProfilerPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object. <!-- begin-user-doc --> This
	 * implementation returns <code>true</code> if the object is either the model's package or is an instance
	 * object of the model. <!-- end-user-doc -->
	 * 
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected ProfilerSwitch<Adapter> modelSwitch = new ProfilerSwitch<Adapter>() {
		@Override
		public Adapter caseProfileEntry(ProfileEntry object) {
			return createProfileEntryAdapter();
		}

		@Override
		public Adapter caseLoopProfileEntry(LoopProfileEntry object) {
			return createLoopProfileEntryAdapter();
		}

		@Override
		public Adapter caseProfileResource(ProfileResource object) {
			return createProfileResourceAdapter();
		}

		@Override
		public Adapter caseInternal(Internal object) {
			return createInternalAdapter();
		}

		@Override
		public Adapter defaultCase(EObject object) {
			return createEObjectAdapter();
		}
	};

	/**
	 * Creates an adapter for the <code>target</code>. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param target
	 *            the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.acceleo.profiler.ProfileEntry
	 * <em>Profile Entry</em>}'. <!-- begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see org.eclipse.acceleo.profiler.ProfileEntry
	 * @generated
	 */
	public Adapter createProfileEntryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.acceleo.profiler.LoopProfileEntry
	 * <em>Loop Profile Entry</em>}'. <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see org.eclipse.acceleo.profiler.LoopProfileEntry
	 * @generated
	 */
	public Adapter createLoopProfileEntryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.acceleo.profiler.ProfileResource
	 * <em>Profile Resource</em>}'. <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see org.eclipse.acceleo.profiler.ProfileResource
	 * @generated
	 */
	public Adapter createProfileResourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.acceleo.profiler.Internal
	 * <em>Internal</em>}'. <!-- begin-user-doc --> This default implementation returns null so that we can
	 * easily ignore cases; it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see org.eclipse.acceleo.profiler.Internal
	 * @generated
	 */
	public Adapter createInternalAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case. <!-- begin-user-doc --> This default implementation returns
	 * null. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} // ProfilerAdapterFactory
