/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.type;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandDefinitionImpl {
    private final XpandDefinition def;
    private final XpandExecutionContext ctx;

    public XpandDefinitionImpl(XpandDefinition def, XpandExecutionContext ctx) {
        this.def = def;
        this.ctx = ctx;
    }

    public String getName() {
        return this.def.getName();
    }

    public Type getTargetType() {
        return this.ctx.getTypeForName(this.def.getTargetType());
    }

    public List<Type> getParamTypes() {
        DeclaredParameter[] p = this.def.getParams();
        ArrayList<Type> result = new ArrayList<Type>();
        int i = 0;
        while (i < p.length) {
            result.add(this.ctx.getTypeForName(p[i].getType().getValue()));
            ++i;
        }
        return result;
    }

    public List<String> getParamNames() {
        DeclaredParameter[] p = this.def.getParams();
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < p.length) {
            result.add(p[i].getName().getValue());
            ++i;
        }
        return result;
    }

    public void proceed() {
        this.def.evaluate(this.ctx);
    }

    public void proceed(Object target, List<?> list) {
        XpandExecutionContext context = this.ctx;
        if (target != null) {
            context = (XpandExecutionContext)context.cloneWithVariable(new Variable("this", target));
        }
        if (list != null) {
            List<String> n = this.getParamNames();
            int i = 0;
            int x = list.size();
            while (i < x) {
                Object o = list.get(i);
                if (o == null || n.size() < i) continue;
                context = (XpandExecutionContext)context.cloneWithVariable(new Variable(n.get(i), o));
            }
        }
        this.def.evaluate(context);
    }

    public String toString() {
        return this.def.toString();
    }
}

