/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.functions;

import java.util.List;
import org.eclipse.jet.internal.xpath.functions.RoundFunction;
import org.eclipse.jet.internal.xpath.functions.StringFunction;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionMetaData;

public class SubstringFunction
implements XPathFunction {
    private static final String EMPTY_STRING = "";
    public static final XPathFunctionMetaData FUNCTION_META_DATA = new XPathFunctionMetaData("substring", null, new SubstringFunction(), 2, 3);

    public Object evaluate(List args) {
        int start;
        String s1 = StringFunction.evaluate(args.get(0));
        double d1 = RoundFunction.evaluate(args.get(1));
        if (Double.isNaN(d1) || d1 == Double.POSITIVE_INFINITY) {
            return EMPTY_STRING;
        }
        int n = start = d1 > 0.0 ? (int)d1 - 1 : 0;
        if (args.size() == 2) {
            if (start < s1.length()) {
                return s1.substring(start);
            }
            return EMPTY_STRING;
        }
        double d2 = RoundFunction.evaluate(args.get(2));
        if (Double.isNaN(d2) || d2 <= 0.0) {
            return EMPTY_STRING;
        }
        double endPos = d1 + d2;
        if (Double.isNaN(endPos)) {
            return EMPTY_STRING;
        }
        int end = endPos > (double)s1.length() ? s1.length() : (int)endPos - 1;
        return s1.substring(start, end);
    }
}

