/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.ui.newproject;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.ui.newproject.Messages;
import org.eclipse.jet.ui.newproject.NewJETProjectPage1;
import org.eclipse.jet.ui.newproject.NewJETProjectPage2Controls;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;

public class NewJETProjectPage2
extends NewJETProjectPage2Controls {
    private NewJETProjectPage1 page1;
    private boolean showExtensionsGroup;

    public NewJETProjectPage2(String pageName) {
        super(pageName);
        this.setTitle(Messages.NewJETProjectPage2_title);
        this.setDescription(Messages.NewJETProjectPage2_description);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setExtends(false);
        String[] allIDs = JET2Platform.getJETBundleManager().getAllTransformIds();
        int i = 0;
        while (i < allIDs.length) {
            this.ddlBaseTx.add(allIDs[i]);
            ++i;
        }
        if (!this.showExtensionsGroup) {
            this.grpExtensions.setVisible(false);
            this.ddlBaseTx.setVisible(false);
            this.cbxExtends.setVisible(false);
            this.lblBaseTx.setVisible(false);
        }
        this.setPageComplete(this.validatePage());
    }

    private boolean validatePage() {
        if (!this.validateTranformID()) {
            return false;
        }
        if (!this.validateTemplateLoader()) {
            return false;
        }
        if (this.cbxExtends.getSelection() && this.cbxExtends.isVisible() && this.ddlBaseTx.getText().trim().length() == 0) {
            return false;
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        return true;
    }

    private boolean validateTemplateLoader() {
        IStatus status = JavaConventions.validateJavaTypeName((String)this.getTemplateLoader());
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        return true;
    }

    private boolean validateTranformID() {
        String transformID = this.getTransformID();
        if (!transformID.matches("[a-zA-Z0-9\\._]*")) {
            this.setErrorMessage(Messages.NewJETProjectPage2_InvalidID);
            return false;
        }
        return true;
    }

    protected void txtID_modify(ModifyEvent e) {
        this.setPageComplete(this.validatePage());
    }

    protected void txtTemplateLoader_modify(ModifyEvent e) {
        this.setPageComplete(this.validatePage());
    }

    private void setExtends(boolean setExtends) {
        if (setExtends != this.cbxExtends.getSelection()) {
            this.cbxExtends.setSelection(setExtends);
        }
        this.lblBaseTx.setEnabled(setExtends);
        this.ddlBaseTx.setEnabled(setExtends);
    }

    public void setJETProjectPage1(NewJETProjectPage1 page1) {
        this.page1 = page1;
    }

    protected void cbxExtends_selection(SelectionEvent e) {
        boolean selected = this.cbxExtends.getSelection();
        this.setExtends(selected);
        if (selected) {
            this.ddlBaseTx.setFocus();
        }
        this.setPageComplete(this.validatePage());
        this.getContainer().updateButtons();
    }

    protected void ddlBaseTx_modify(ModifyEvent e) {
        this.setPageComplete(this.validatePage());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.page1 != null) {
            this.txtTemplateLoader.setText(String.valueOf(this.page1.getDefJavaPackage()) + "._jet_transformation");
            this.txtID.setText(this.page1.getBaseID());
            this.txtName.setText(this.page1.getBaseID());
            this.txtID.setFocus();
        }
    }

    public boolean isExtension() {
        return this.cbxExtends.getSelection();
    }

    public String getTransformID() {
        return this.txtID.getText().trim();
    }

    public String getTransformName() {
        return this.txtName.getText().trim();
    }

    public String getTransformDescription() {
        return this.txtDescription.getText().trim();
    }

    public String getTemplateLoader() {
        return this.txtTemplateLoader.getText().trim();
    }

    public String getBaseTransformID() {
        return this.ddlBaseTx.getText().trim();
    }

    void showExtensionsGroup(boolean show) {
        this.showExtensionsGroup = show;
    }
}

