/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchResult;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class ReferencesSearchQuery
implements ISearchQuery {
    private ReferencesSearchResult searchResult;
    private EObject declaration;
    private AcceleoEditor editor;
    private boolean searchOutsideOfCurrentFile;

    public ReferencesSearchQuery(AcceleoEditor editor, EObject declaration) {
        this.declaration = declaration;
        this.editor = editor;
        this.searchResult = new ReferencesSearchResult(this);
        this.searchOutsideOfCurrentFile = true;
    }

    public ReferencesSearchQuery(AcceleoEditor editor, EObject declaration, boolean searchOutsideCurrentFile) {
        this.declaration = declaration;
        this.editor = editor;
        this.searchResult = new ReferencesSearchResult(this);
        this.searchOutsideOfCurrentFile = searchOutsideCurrentFile;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return AcceleoUIMessages.getString("AcceleoReferencesSearch.Query.Label");
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        if (this.declaration != null) {
            this.findReferencesForFile(monitor);
        }
        return Status.OK_STATUS;
    }

    private void findReferencesForFile(IProgressMonitor monitor) {
        ArrayList<URI> allURIs = new ArrayList<URI>();
        IProject project = null;
        if (this.editor.getContent().getFile() != null && this.editor.getFile() != null) {
            AcceleoProject acceleoProject = new AcceleoProject(this.editor.getContent().getFile().getProject());
            IPath outputFilePath = acceleoProject.getOutputFilePath(this.editor.getContent().getFile());
            if (outputFilePath == null) {
                return;
            }
            String path = outputFilePath.toString();
            URI newResourceURI = URI.createPlatformResourceURI((String)path, (boolean)false);
            allURIs.add(newResourceURI);
            if (this.searchOutsideOfCurrentFile) {
                project = this.editor.getFile().getProject();
                for (URI uri : new AcceleoProject(project).getOutputFiles()) {
                    if (allURIs.contains(uri)) continue;
                    allURIs.add(uri);
                }
            }
        }
        if (this.searchOutsideOfCurrentFile) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                try {
                    if (!monitor.isCanceled() && projects[i] != project && projects[i].isAccessible() && projects[i].hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                        AcceleoProject acceleoProject = new AcceleoProject(projects[i]);
                        for (URI uri : acceleoProject.getOutputFiles()) {
                            if (allURIs.contains(uri)) continue;
                            allURIs.add(uri);
                        }
                    }
                }
                catch (CoreException e) {
                    AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                }
                ++i;
            }
        }
        ResourceSetImpl newResourceSet = new ResourceSetImpl();
        for (URI uri : allURIs) {
            try {
                if (monitor.isCanceled() || !this.resourceAtURIExist(uri)) continue;
                ModelUtils.load((URI)uri, (ResourceSet)newResourceSet);
            }
            catch (IOException iOException) {}
        }
        if (!monitor.isCanceled()) {
            EcoreUtil.resolveAll((ResourceSet)newResourceSet);
            for (Resource resource : newResourceSet.getResources()) {
                if (resource.getContents().size() <= 0 || !(resource.getContents().get(0) instanceof Module)) continue;
                this.scanModuleForDeclaration((Module)resource.getContents().get(0));
            }
        }
        for (Resource resource : newResourceSet.getResources()) {
            resource.unload();
        }
    }

    private boolean resourceAtURIExist(URI uri) {
        boolean result = true;
        try {
            result = AcceleoWorkspaceUtil.getWorkspaceFile((String)uri.toString()).exists();
        }
        catch (IOException iOException) {}
        return result;
    }

    private void scanModuleForDeclaration(Module module) {
        Path emtlPath = new Path(module.eResource().getURI().toPlatformString(true));
        if (emtlPath.segmentCount() > 1 && ResourcesPlugin.getWorkspace().getRoot().exists((IPath)emtlPath)) {
            IFile emtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)emtlPath);
            IPath mtlPath = new AcceleoProject(emtlFile.getProject()).getInputFilePath((IPath)emtlPath);
            IFile mtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(mtlPath);
            if (mtlFile.exists()) {
                StringBuffer acceleoText = FileContent.getFileContent((File)mtlFile.getLocation().toFile());
                this.scanModuleForDeclaration(mtlFile, acceleoText, module);
            }
        }
    }

    private void scanModuleForDeclaration(IFile mtlFile, StringBuffer acceleoText, Module module) {
        this.addASTNode(mtlFile, acceleoText, (EObject)module);
        TreeIterator it = module.eAllContents();
        while (it.hasNext()) {
            this.addASTNode(mtlFile, acceleoText, (EObject)it.next());
        }
    }

    private void addASTNode(IFile mtlFile, StringBuffer acceleoText, EObject astNode) {
        boolean isRef;
        if (astNode instanceof IteratorExp && ((IteratorExp)astNode).getBody().getStartPosition() == -1 && ((IteratorExp)astNode).getBody().getEndPosition() == -1) {
            ((IteratorExp)astNode).getBody().setStartPosition(((IteratorExp)astNode).getStartPosition());
            ((IteratorExp)astNode).getBody().setEndPosition(((IteratorExp)astNode).getEndPosition());
        }
        if (!(isRef = this.isMatching(astNode, this.declaration))) {
            for (EObject eObj : astNode.eCrossReferences()) {
                if (!this.isMatching(eObj, this.declaration)) continue;
                isRef = true;
                break;
            }
        }
        if (isRef) {
            String message;
            IRegion region = this.createRegion(astNode);
            if (region.getOffset() + region.getLength() <= acceleoText.length()) {
                message = acceleoText.substring(region.getOffset(), region.getOffset() + region.getLength());
                if (message.startsWith("[") && message.indexOf("]") > -1) {
                    message = message.substring(0, message.indexOf("]") + 1);
                }
            } else {
                message = "";
            }
            this.searchResult.addMatch(new Match((Object)new ReferenceEntry(mtlFile, astNode, this.editor, message), region.getOffset(), region.getLength()));
        }
    }

    private boolean isMatching(EObject o1, EObject o2) {
        boolean result;
        if (o1.eClass().getName().equals(o2.eClass().getName())) {
            if (o1 instanceof Template && o2 instanceof Template) {
                Template t1 = (Template)o1;
                Template t2 = (Template)o2;
                result = this.isMatchingTemplate(t1, t2);
            } else if (o1 instanceof Query && o2 instanceof Query) {
                Query q1 = (Query)o1;
                Query q2 = (Query)o2;
                result = this.isMatchingQuery(q1, q2);
            } else {
                result = o1 instanceof ModuleElement && o2 instanceof ModuleElement ? ((ModuleElement)o1).getName().equals(((ModuleElement)o2).getName()) : (o1 instanceof Variable && o2 instanceof Variable ? ((Variable)o1).getName().equals(((Variable)o2).getName()) : EcoreUtil.equals((EObject)o1, (EObject)o2));
            }
        } else {
            result = EcoreUtil.equals((EObject)o1, (EObject)o2);
        }
        return result;
    }

    private boolean isMatchingTemplate(Template template1, Template template2) {
        boolean result = false;
        if (template1.getName() != null) {
            result = template1.getName().equals(template2.getName());
        }
        EList t1Parameters = template1.getParameter();
        EList t2Parameters = template2.getParameter();
        if (t1Parameters.size() == t2Parameters.size()) {
            int i = 0;
            while (i < t1Parameters.size()) {
                Variable var1 = (Variable)t1Parameters.get(i);
                Variable var2 = (Variable)t2Parameters.get(i);
                if (var1.getName() != null && var2.getName() != null && !var1.getName().equals(var2.getName())) {
                    result = false;
                    break;
                }
                if (var1.getType() != null && var2.getType() != null && ((EClassifier)var1.getType()).getName() != null && !((EClassifier)var1.getType()).getName().equals(((EClassifier)var2.getType()).getName())) {
                    result = false;
                    break;
                }
                ++i;
            }
            URI uri1 = EcoreUtil.getURI((EObject)template1);
            URI uri2 = EcoreUtil.getURI((EObject)template2);
            if (result && uri1 != null && uri2 != null) {
                result = uri1.equals((Object)uri2);
                result = result && template1.getStartPosition() == template2.getStartPosition() && template1.getEndPosition() == template2.getEndPosition();
            }
        } else {
            result = false;
        }
        return result;
    }

    private boolean isMatchingQuery(Query query1, Query query2) {
        boolean result = false;
        if (query1.getName() != null) {
            result = query1.getName().equals(query2.getName());
        }
        EList q1Parameters = query1.getParameter();
        EList q2Parameters = query2.getParameter();
        if (q1Parameters.size() == q2Parameters.size()) {
            int i = 0;
            while (i < q1Parameters.size()) {
                Variable var1 = (Variable)q1Parameters.get(i);
                Variable var2 = (Variable)q2Parameters.get(i);
                if (var1.getName() != null && var2.getName() != null && !var1.getName().equals(var2.getName())) {
                    result = false;
                    break;
                }
                if (var1.getType() != null && var2.getType() != null && ((EClassifier)var1.getType()).getName() != null && !((EClassifier)var1.getType()).getName().equals(((EClassifier)var2.getType()).getName())) {
                    result = false;
                    break;
                }
                ++i;
            }
            URI uri1 = EcoreUtil.getURI((EObject)query1);
            URI uri2 = EcoreUtil.getURI((EObject)query2);
            if (result && uri1 != null && uri2 != null) {
                result = uri1.equals((Object)uri2);
                result = result && query1.getStartPosition() == query2.getStartPosition() && query1.getEndPosition() == query2.getEndPosition();
            }
        } else {
            result = false;
        }
        return result;
    }

    private IRegion createRegion(EObject astNode) {
        int e;
        int b;
        Region result = null;
        if (astNode instanceof ASTNode && (b = ((ASTNode)astNode).getStartPosition()) > -1 && (e = ((ASTNode)astNode).getEndPosition()) >= b) {
            result = new Region(b, e - b);
        }
        if (result != null) {
            return result;
        }
        return new Region(0, 0);
    }
}

