/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.scanner;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.internal.ide.ui.editors.template.ColorManager;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.FirstVariableRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.KeywordRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.SequenceBlockRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AbstractAcceleoScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoWhitespaceDetector;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.IAcceleoColorConstants;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoBehavioralFeatureScanner
extends AbstractAcceleoScanner {
    public AcceleoBehavioralFeatureScanner(ColorManager manager) {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)new KeywordRule("'"), (ISequenceRule)new KeywordRule("'"), new KeywordRule("\\'"), (IToken)new Token((Object)new TextAttribute(manager.getColor(IAcceleoColorConstants.LITERAL)))));
        this.computeFirstVariableRule(rules, "template", manager);
        this.computeFirstVariableRule(rules, "query", manager);
        this.computeFirstVariableRule(rules, "macro", manager);
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new AcceleoWhitespaceDetector()));
        rules.add(this.computeDelimiterRule("[", manager));
        rules.add(this.computeDelimiterRule("]", manager));
        rules.add(this.computeKeywordRule("template", manager));
        rules.add(this.computeKeywordRule("query", manager));
        rules.add(this.computeKeywordRule("macro", manager));
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(manager.getColor(IAcceleoColorConstants.BEHAVIORAL_FEATURE))));
    }

    private void computeFirstVariableRule(List<IRule> rules, String behaviorType, ColorManager manager) {
        Color foreGroundColor = manager.getColor(IAcceleoColorConstants.BEHAVIORAL_FEATURE);
        Color backGroundColor = manager.getColor(IAcceleoColorConstants.FIRST_VARIABLE);
        rules.add((IRule)new FirstVariableRule(new String[]{"[", behaviorType, "*", "*", "("}, (IToken)new Token((Object)new TextAttribute(foreGroundColor, backGroundColor, 0))));
        rules.add((IRule)new FirstVariableRule(new String[]{"[", behaviorType, "*", "("}, (IToken)new Token((Object)new TextAttribute(foreGroundColor, backGroundColor, 0))));
    }

    private IRule computeKeywordRule(String keyword, ColorManager manager) {
        return new KeywordRule(keyword, true, false, (IToken)new Token((Object)new TextAttribute(manager.getColor(IAcceleoColorConstants.BEHAVIORAL_FEATURE), null, 1)));
    }

    private IRule computeDelimiterRule(String delimiter, ColorManager manager) {
        return new KeywordRule(delimiter, false, false, (IToken)new Token((Object)new TextAttribute(manager.getColor(IAcceleoColorConstants.BEHAVIORAL_FEATURE), null, 1)));
    }

    @Override
    public String getConfiguredContentType() {
        return "__ACCELEO_behavioral_feature";
    }
}

