/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser;

import java.io.File;
import org.eclipse.acceleo.internal.parser.ast.CST2ASTConverterWithResolver;
import org.eclipse.acceleo.internal.parser.ast.IASTLogHandler;
import org.eclipse.acceleo.internal.parser.ast.IASTProvider;
import org.eclipse.acceleo.internal.parser.ast.ocl.OCLParser;
import org.eclipse.acceleo.internal.parser.cst.CSTParser;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.acceleo.parser.cst.CstFactory;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.emf.ecore.resource.Resource;

public class AcceleoSourceBuffer
implements IASTProvider,
IASTLogHandler {
    protected final File file;
    protected final StringBuffer buffer;
    protected final AcceleoParserProblems problems;
    protected org.eclipse.acceleo.model.mtl.Module ast;
    protected CST2ASTConverterWithResolver astCreator;
    private Module cst;

    public AcceleoSourceBuffer(File file) {
        this.file = file;
        this.buffer = FileContent.getFileContent(file);
        this.problems = new AcceleoParserProblems();
    }

    public AcceleoSourceBuffer(StringBuffer buffer) {
        this.file = null;
        this.buffer = buffer;
        this.problems = new AcceleoParserProblems();
    }

    public File getFile() {
        return this.file;
    }

    public AcceleoParserProblems getProblems() {
        return this.problems;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public org.eclipse.acceleo.model.mtl.Module getAST() {
        return this.ast;
    }

    public Module getCST() {
        return this.cst;
    }

    public OCLParser getOCL() {
        if (this.astCreator != null) {
            return this.astCreator.getOCL();
        }
        return null;
    }

    public void createAST(Resource resource) {
        if (this.cst == null) {
            this.createCST();
        }
        this.astCreator = new CST2ASTConverterWithResolver();
        this.astCreator.setLogHandler(this);
        this.astCreator.createAST(this.cst, resource);
        this.ast = resource.getContents().size() > 0 && resource.getContents().get(0) instanceof org.eclipse.acceleo.model.mtl.Module ? (org.eclipse.acceleo.model.mtl.Module)resource.getContents().get(0) : null;
    }

    public void refreshAST() {
        this.ast = null;
    }

    public void resolveAST() {
        this.astCreator.resolveAST(this.cst);
    }

    public void resolveAST(int posBegin, int posEnd) {
        this.astCreator.resolveAST(this.cst, posBegin, posEnd);
    }

    public void createCST() {
        this.ast = null;
        CSTParser parser = new CSTParser(this);
        this.cst = parser.parse();
        if (this.cst == null) {
            this.cst = CstFactory.eINSTANCE.createModule();
        }
    }

    public void log(String message, int posBegin, int posEnd) {
        int[] pos = this.trim(posBegin, posEnd);
        int line = FileContent.lineNumber(this.buffer, pos[0]);
        this.problems.addProblem(this.file, message, line, pos[0], pos[1]);
    }

    public int[] trim(int posBegin, int posEnd) {
        int b = posBegin < 0 ? 0 : posBegin;
        int e = posEnd < 0 || posEnd > this.buffer.length() ? this.buffer.length() : posEnd;
        while (b < e && Character.isWhitespace(this.buffer.charAt(b))) {
            ++b;
        }
        if (posEnd >= 0 && b != e || b + 1 >= this.buffer.length()) {
            while (e > b + 1 && Character.isWhitespace(this.buffer.charAt(e - 1))) {
                --e;
            }
        }
        return new int[]{b, e};
    }
}

