/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class MTFileContent {
    public static final String MT_FILE_EXTENSION = "mt";
    private static final String ENCODING_START = "encoding=";

    private MTFileContent() {
    }

    public static StringBuffer getFileContent(File file) {
        String encoding;
        StringBuffer buffer = MTFileContent.getEncodedFileContent(file, null);
        if (file.getName() != null && file.getName().endsWith("mtl") && (encoding = MTFileContent.getEncoding(buffer)) != null) {
            buffer = MTFileContent.getEncodedFileContent(file, encoding);
        }
        return buffer;
    }

    private static StringBuffer getEncodedFileContent(File file, String encodingCode) {
        StringBuffer buffer = new StringBuffer();
        try {
            FileInputStream input = new FileInputStream(file);
            InputStreamReader reader = encodingCode != null ? new InputStreamReader((InputStream)input, encodingCode) : new InputStreamReader(input);
            try {
                int size = 0;
                char[] buff = new char[512];
                while ((size = reader.read(buff)) >= 0) {
                    buffer.append(buff, 0, size);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return buffer;
    }

    private static String getEncoding(StringBuffer buffer) {
        String startMarker = "<%--";
        String endMarker = "--%>";
        String result = MTFileContent.doGetEncoding(buffer, startMarker, endMarker);
        if (result == null) {
            startMarker = "[%--";
            endMarker = "--%]";
            result = MTFileContent.doGetEncoding(buffer, startMarker, endMarker);
        }
        return result;
    }

    private static String doGetEncoding(StringBuffer buffer, String startMarker, String endMarker) {
        int end;
        int start = buffer.indexOf(String.valueOf(startMarker) + ENCODING_START);
        if (start != -1 && (end = buffer.indexOf(endMarker, start)) != -1) {
            String encoding = buffer.substring(start + (String.valueOf(startMarker) + ENCODING_START).length(), end);
            return encoding.trim().toUpperCase();
        }
        return null;
    }
}

