/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.utils;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.acceleo.common.utils.CompactHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompactLinkedHashSet<E>
extends CompactHashSet<E> {
    transient LinkedListHeader header;

    public CompactLinkedHashSet() {
    }

    public CompactLinkedHashSet(Collection<? extends E> collection) {
        super(collection);
    }

    public CompactLinkedHashSet(int elementCount) {
        super(elementCount);
    }

    public CompactLinkedHashSet(int elementCount, float loadFactor) {
        super(elementCount, loadFactor);
    }

    @Override
    public void clear() {
        super.clear();
        this.header.next = this.header;
        this.header.last = this.header;
    }

    @Override
    public Iterator<E> iterator() {
        return new LinkedSetIterator();
    }

    @Override
    protected void deleteIndex(int index) {
        super.deleteIndex(index);
        Entry previous = this.header;
        Entry entry = this.header.next;
        while (entry.index != index && entry != this.header) {
            previous = entry;
            entry = entry.next;
        }
        if (entry != this.header) {
            previous.next = entry.next;
            if (entry == this.header.last) {
                this.header.last = previous;
            }
        }
    }

    @Override
    protected void init() {
        this.header = new LinkedListHeader();
        this.header.next = this.header;
        this.header.last = this.header;
    }

    @Override
    protected void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        Object[] temp = new Object[newCapacity];
        Entry entry = this.header.next;
        while (entry != this.header) {
            Object value = this.data[entry.index];
            int hash = CompactLinkedHashSet.supplementalHash(value.hashCode());
            int insertionIndex = hash & mask;
            while (temp[insertionIndex] != null) {
                insertionIndex = insertionIndex + 1 & mask;
            }
            entry.index = insertionIndex;
            temp[insertionIndex] = value;
            entry = entry.next;
        }
        this.data = temp;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    @Override
    protected void setIndex(int index, E element) {
        Entry newEntry;
        super.setIndex(index, element);
        this.header.last.next = newEntry = new Entry(index);
        this.header.last = newEntry;
        newEntry.next = this.header;
    }

    private static class Entry {
        int index;
        Entry next;

        Entry(int index) {
            this.index = index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LinkedListHeader
    extends Entry {
        Entry last;

        LinkedListHeader() {
            super(-1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LinkedSetIterator
    implements Iterator<E> {
        private int expectedModCount;
        private Entry lastReturned;
        private Entry nextElem;

        LinkedSetIterator() {
            this.expectedModCount = CompactLinkedHashSet.this.modCount;
            this.nextElem = CompactLinkedHashSet.this.header.next;
        }

        @Override
        public boolean hasNext() {
            return this.nextElem != CompactLinkedHashSet.this.header;
        }

        @Override
        public E next() {
            this.checkComodification();
            if (this.nextElem == CompactLinkedHashSet.this.header) {
                throw new NoSuchElementException();
            }
            Object result = CompactLinkedHashSet.this.data[this.nextElem.index];
            this.lastReturned = this.nextElem;
            this.nextElem = this.nextElem.next;
            return CompactLinkedHashSet.unmaskNull(result);
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkComodification();
            CompactLinkedHashSet.this.deleteIndex(this.lastReturned.index);
            ++this.expectedModCount;
            this.lastReturned = null;
        }

        private void checkComodification() throws ConcurrentModificationException {
            if (this.expectedModCount != CompactLinkedHashSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

