/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.internal.parser.AcceleoParserMessages;
import org.eclipse.acceleo.internal.parser.ast.CST2ASTConverterWithResolver;
import org.eclipse.acceleo.internal.parser.cst.utils.ParserUtils;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.SequenceBlock;
import org.eclipse.acceleo.model.mtl.Comment;
import org.eclipse.acceleo.model.mtl.CommentBody;
import org.eclipse.acceleo.model.mtl.Documentation;
import org.eclipse.acceleo.model.mtl.DocumentedElement;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleDocumentation;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.ModuleElementDocumentation;
import org.eclipse.acceleo.model.mtl.MtlFactory;
import org.eclipse.acceleo.model.mtl.ParameterDocumentation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CST2ASTConverterWithDocumentationResolver
extends CST2ASTConverterWithResolver {
    private static final String BEGINNING_DOCUMENTATION_TAG = "@";

    public void resolveASTDocumentation(Module module, StringBuffer buffer) {
        int endHeaderPosition = buffer.indexOf("/]", module.getStartHeaderPosition());
        module.setEndHeaderPosition(endHeaderPosition);
        if (module.isDeprecated()) {
            this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.DeprecatedModule", module.getName()), module.getStartHeaderPosition(), module.getEndHeaderPosition());
        }
        this.transformStepResolveModuleDocumentation(module, buffer);
        EList eContents = module.eContents();
        int i = 0;
        while (i < eContents.size()) {
            EObject eObject = (EObject)eContents.get(i);
            if (eObject instanceof Comment) {
                this.transformStepResolveComments((Comment)eObject, buffer);
            }
            if (i + 1 < eContents.size() && eObject instanceof Documentation) {
                Documentation documentation = (Documentation)eObject;
                EObject next = (EObject)eContents.get(i + 1);
                if (next instanceof DocumentedElement) {
                    DocumentedElement documentedElement = (DocumentedElement)next;
                    documentation.setDocumentedElement(documentedElement);
                    ModuleElementDocumentation moduleElementDocumentation = MtlFactory.eINSTANCE.createModuleElementDocumentation();
                    moduleElementDocumentation.setBody(documentation.getBody());
                    moduleElementDocumentation.setStartPosition(documentation.getStartPosition());
                    moduleElementDocumentation.setEndPosition(documentation.getEndPosition());
                    moduleElementDocumentation.setName(documentation.getName());
                    EcoreUtil.replace((EObject)documentation, (EObject)moduleElementDocumentation);
                    this.transformStepResolveModuleElementDocumentation(moduleElementDocumentation);
                }
            }
            ++i;
        }
    }

    private void transformStepResolveModuleDocumentation(Module module, StringBuffer buffer) {
        Documentation documentation = module.getDocumentation();
        if (documentation != null) {
            this.transformStepResolveComments((Comment)documentation, buffer);
            ModuleDocumentation moduleDocumentation = MtlFactory.eINSTANCE.createModuleDocumentation();
            moduleDocumentation.setBody(documentation.getBody());
            moduleDocumentation.setStartPosition(documentation.getStartPosition());
            moduleDocumentation.setEndPosition(documentation.getEndPosition());
            moduleDocumentation.setName(documentation.getName());
            EcoreUtil.replace((EObject)documentation, (EObject)moduleDocumentation);
            this.transformStepResolveModuleDocumentation(moduleDocumentation);
        }
    }

    private ModuleElementDocumentation transformStepResolveModuleElementDocumentation(ModuleElementDocumentation moduleElementDocumentation) {
        List<DocumentationPositionedKeyword> keywordOrder = this.computeModuleElementKeywordOrder(moduleElementDocumentation.getBody());
        int i = 0;
        while (i < keywordOrder.size()) {
            DocumentationPositionedKeyword k = keywordOrder.get(i);
            String value = null;
            value = i + 1 < keywordOrder.size() ? this.computeDocumentationValue(moduleElementDocumentation.getBody().getValue(), k.getKeyword(), k.getOffset(), keywordOrder.get(i + 1).getOffset()) : this.computeDocumentationValue(moduleElementDocumentation.getBody().getValue(), k.getKeyword(), k.getOffset(), moduleElementDocumentation.getBody().getValue().length());
            this.addValueToDocumentation(value.trim(), k.getKeyword(), (Documentation)moduleElementDocumentation);
            ++i;
        }
        return moduleElementDocumentation;
    }

    private ModuleDocumentation transformStepResolveModuleDocumentation(ModuleDocumentation moduleDocumentation) {
        List<DocumentationPositionedKeyword> keywordOrder = this.computeModuleKeywordOrder(moduleDocumentation.getBody());
        int i = 0;
        while (i < keywordOrder.size()) {
            DocumentationPositionedKeyword positionedTag = keywordOrder.get(i);
            String value = "";
            value = i + 1 < keywordOrder.size() ? this.computeDocumentationValue(moduleDocumentation.getBody().getValue(), positionedTag.getKeyword(), positionedTag.getOffset(), keywordOrder.get(i + 1).getOffset()) : this.computeDocumentationValue(moduleDocumentation.getBody().getValue(), positionedTag.getKeyword(), positionedTag.getOffset(), moduleDocumentation.getBody().getValue().length());
            this.addValueToDocumentation(value.trim(), positionedTag.getKeyword(), (Documentation)moduleDocumentation);
            ++i;
        }
        return moduleDocumentation;
    }

    private void transformStepResolveComments(Comment comment, StringBuffer buffer) {
        if (comment instanceof Documentation) {
            SequenceBlock pDocumentation = ParserUtils.createAcceleoSequenceBlock(true, "**", null, null);
            Region beginHeader = pDocumentation.searchBeginHeader(buffer, comment.getStartPosition(), comment.getEndPosition());
            Region endHeaderAtBeginHeader = pDocumentation.searchEndHeaderAtBeginHeader(buffer, beginHeader, comment.getEndPosition());
            comment.getBody().setStartPosition(beginHeader.e());
            comment.getBody().setEndPosition(endHeaderAtBeginHeader.b());
        } else {
            Region beginHeader;
            SequenceBlock pComment = ParserUtils.createAcceleoSequenceBlock(false, "comment", null, null);
            Region endHeaderAtBeginHeader = pComment.searchEndHeaderAtBeginHeader(buffer, beginHeader = pComment.searchBeginHeader(buffer, comment.getStartPosition(), comment.getEndPosition()), comment.getEndPosition());
            if (endHeaderAtBeginHeader.getSequence() == pComment.getEndHeaderBody()) {
                comment.getBody().setStartPosition(beginHeader.e());
                comment.getBody().setEndPosition(endHeaderAtBeginHeader.b());
            } else {
                Region eB = pComment.searchEndBodyAtEndHeader(buffer, endHeaderAtBeginHeader, comment.getEndPosition());
                comment.getBody().setStartPosition(endHeaderAtBeginHeader.e());
                comment.getBody().setEndPosition(eB.b());
            }
        }
    }

    private String computeDocumentationValue(String body, String keyword, int posBegin, int posEnd) {
        String newString = body.substring(posBegin, posEnd);
        newString = newString.trim();
        newString = newString.substring(keyword.length());
        return newString;
    }

    private List<DocumentationPositionedKeyword> computeModuleKeywordOrder(CommentBody commentBody) {
        ArrayList<DocumentationPositionedKeyword> list = new ArrayList<DocumentationPositionedKeyword>();
        String body = commentBody.getValue();
        int currentPos = 0;
        while (currentPos < body.length() && currentPos != -1) {
            int indexOf = body.indexOf(BEGINNING_DOCUMENTATION_TAG, currentPos);
            if (indexOf != -1) {
                if (body.startsWith("@author", indexOf)) {
                    list.add(new DocumentationPositionedKeyword("@author", indexOf));
                } else if (body.startsWith("@deprecated", indexOf)) {
                    list.add(new DocumentationPositionedKeyword("@deprecated", indexOf));
                } else if (body.startsWith("@since", indexOf)) {
                    list.add(new DocumentationPositionedKeyword("@since", indexOf));
                } else if (body.startsWith("@version", indexOf)) {
                    list.add(new DocumentationPositionedKeyword("@version", indexOf));
                }
                currentPos = indexOf + 1;
                continue;
            }
            currentPos = indexOf;
        }
        return list;
    }

    private List<DocumentationPositionedKeyword> computeModuleElementKeywordOrder(CommentBody commentBody) {
        ArrayList<DocumentationPositionedKeyword> list = new ArrayList<DocumentationPositionedKeyword>();
        String body = commentBody.getValue();
        int currentPos = 0;
        while (currentPos < body.length() && currentPos != -1) {
            int indexOf = body.indexOf(BEGINNING_DOCUMENTATION_TAG, currentPos);
            if (indexOf != -1) {
                if (body.startsWith("@deprecated", indexOf)) {
                    list.add(new DocumentationPositionedKeyword("@deprecated", indexOf));
                } else if (body.startsWith("@param", indexOf)) {
                    list.add(new DocumentationPositionedKeyword("@param", indexOf));
                }
                currentPos = indexOf + 1;
                continue;
            }
            currentPos = indexOf;
        }
        return list;
    }

    private void addValueToDocumentation(String value, String keyword, Documentation doc) {
        if (doc instanceof ModuleDocumentation) {
            ModuleDocumentation moduleDoc = (ModuleDocumentation)doc;
            if ("@author".equals(keyword)) {
                moduleDoc.setAuthor(value);
            } else if ("@deprecated".equals(keyword) && doc.getDocumentedElement() instanceof Module) {
                Module module = (Module)moduleDoc.getDocumentedElement();
                module.setDeprecated(true);
                EList moduleElements = module.getOwnedModuleElement();
                for (ModuleElement moduleElement : moduleElements) {
                    if (!(moduleElement instanceof DocumentedElement)) continue;
                    DocumentedElement documentedElement = (DocumentedElement)moduleElement;
                    documentedElement.setDeprecated(true);
                }
            } else if ("@since".equals(keyword)) {
                moduleDoc.setSince(value);
            } else if ("@version".equals(keyword)) {
                moduleDoc.setVersion(value);
            }
        } else if (doc instanceof ModuleElementDocumentation) {
            ModuleElementDocumentation nodeDoc = (ModuleElementDocumentation)doc;
            if ("@deprecated".equals(keyword) && nodeDoc.getDocumentedElement() != null) {
                DocumentedElement documentedElement = nodeDoc.getDocumentedElement();
                documentedElement.setDeprecated(true);
            } else if ("@param".equals(keyword)) {
                EList parametersDocumentation = nodeDoc.getParametersDocumentation();
                String parameterName = "";
                String space = " ";
                CommentBody commentBody = MtlFactory.eINSTANCE.createCommentBody();
                if (value.contains(" ")) {
                    parameterName = value.substring(0, value.indexOf(" "));
                    commentBody.setValue(value.substring(value.indexOf(" ")));
                } else {
                    parameterName = value;
                    commentBody.setValue("");
                }
                ParameterDocumentation parameterDocumentation = MtlFactory.eINSTANCE.createParameterDocumentation();
                parameterDocumentation.setBody(commentBody);
                parameterDocumentation.setName(parameterName);
                parametersDocumentation.add(parameterDocumentation);
            }
        }
    }

    private class DocumentationPositionedKeyword {
        private String keyword;
        private int offset;

        public DocumentationPositionedKeyword(String k, int b) {
            this.keyword = k;
            this.offset = b;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

