/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.internal.traceability.engine.AbstractTrace;
import org.eclipse.acceleo.internal.traceability.engine.AcceleoTraceabilityVisitor;
import org.eclipse.acceleo.internal.traceability.engine.ExpressionTrace;
import org.eclipse.acceleo.internal.traceability.engine.TraceabilityTokenizer;
import org.eclipse.acceleo.internal.traceability.engine.TraceabilityVisitorUtil;
import org.eclipse.acceleo.traceability.GeneratedFile;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.acceleo.traceability.ModuleElement;
import org.eclipse.acceleo.traceability.TraceabilityFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoTraceabilityOperationVisitor<C, PM> {
    private static final Map<String, TraceabilityTokenizer> TOKENIZERS = new HashMap<String, TraceabilityTokenizer>();
    private AcceleoTraceabilityVisitor<EPackage, C, EOperation, EStructuralFeature, EEnumLiteral, PM, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> visitor;

    public AcceleoTraceabilityOperationVisitor(AcceleoTraceabilityVisitor<EPackage, C, EOperation, EStructuralFeature, EEnumLiteral, PM, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> visitor) {
        this.visitor = visitor;
    }

    public <T> T visitFirstOperation(Collection<T> source) {
        if (source.isEmpty()) {
            return null;
        }
        T result = source.iterator().next();
        if (TraceabilityVisitorUtil.isPrimitive(result)) {
            AbstractTrace trace = this.visitor.getLastExpressionTrace();
            List regions = new ArrayList();
            for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
                regions.addAll(entry.getValue());
            }
            if (regions.size() > 1) {
                Collections.sort(regions);
                if (regions.size() == source.size()) {
                    regions = regions.subList(0, 1);
                } else {
                    int valueLength = result.toString().length();
                    int regionsStartIndex = 0;
                    GeneratedText region = (GeneratedText)regions.get(regionsStartIndex);
                    int regionLength = region.getEndOffset() - region.getStartOffset();
                    int regionsEndIndex = regionsStartIndex;
                    int gap = valueLength - regionLength;
                    while (gap > 0) {
                        GeneratedText next = (GeneratedText)regions.get(++regionsEndIndex);
                        int nextLength = next.getEndOffset() - next.getStartOffset();
                        gap -= nextLength;
                    }
                    regions = regions.subList(regionsStartIndex, regionsEndIndex + 1);
                }
                Iterator<Map.Entry<InputElement, Set<GeneratedText>>> entryIterator = trace.getTraces().entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry<InputElement, Set<GeneratedText>> entry = entryIterator.next();
                    entry.getValue().retainAll(regions);
                    if (!entry.getValue().isEmpty()) continue;
                    entryIterator.remove();
                }
            }
        }
        return result;
    }

    public String visitFirstOperation(String source, int endIndex) {
        String result = endIndex < 0 || endIndex > source.length() ? source : this.visitSubstringOperation(source, 0, endIndex);
        return result;
    }

    public <T> T visitLastOperation(Collection<T> source) {
        T result;
        if (source.isEmpty()) {
            return null;
        }
        Iterator<T> valueIterator = source.iterator();
        do {
            result = valueIterator.next();
        } while (valueIterator.hasNext());
        if (TraceabilityVisitorUtil.isPrimitive(result)) {
            AbstractTrace trace = this.visitor.getLastExpressionTrace();
            List regions = new ArrayList();
            for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
                regions.addAll(entry.getValue());
            }
            if (regions.size() > 1) {
                Collections.sort(regions);
                int regionsStartOffset = ((GeneratedText)regions.get(0)).getStartOffset();
                if (regions.size() == source.size()) {
                    regions = regions.subList(regions.size() - 1, regions.size());
                } else {
                    int valueLength = result.toString().length();
                    int regionsEndIndex = regions.size() - 1;
                    GeneratedText region = (GeneratedText)regions.get(regionsEndIndex);
                    int regionLength = region.getEndOffset() - region.getStartOffset();
                    int regionsStartIndex = regionsEndIndex;
                    int gap = valueLength - regionLength;
                    while (gap > 0) {
                        GeneratedText previous = (GeneratedText)regions.get(--regionsStartIndex);
                        int previousLength = previous.getEndOffset() - previous.getStartOffset();
                        gap -= previousLength;
                    }
                    regions = regions.subList(regionsStartIndex, regionsEndIndex + 1);
                }
                for (GeneratedText region : regions) {
                    int regionLength = region.getEndOffset() - region.getStartOffset();
                    region.setStartOffset(regionsStartOffset);
                    region.setEndOffset(regionsStartOffset + regionLength);
                    regionsStartOffset += regionLength;
                }
                Iterator<Map.Entry<InputElement, Set<GeneratedText>>> entryIterator = trace.getTraces().entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry<InputElement, Set<GeneratedText>> entry = entryIterator.next();
                    entry.getValue().retainAll(regions);
                    if (!entry.getValue().isEmpty()) continue;
                    entryIterator.remove();
                }
            }
        }
        return result;
    }

    public String visitLastOperation(String source, int charCount) {
        String result = charCount < 0 || charCount > source.length() ? source : this.visitSubstringOperation(source, source.length() - charCount, source.length());
        return result;
    }

    public String visitReplaceOperation(String source, String substring, String replacement, ExpressionTrace<C> substitutionTrace, boolean substituteAll, boolean useInvocationTrace) {
        if (substring == null || replacement == null) {
            throw new NullPointerException();
        }
        Matcher sourceMatcher = Pattern.compile(substring).matcher(source);
        StringBuffer result = new StringBuffer();
        boolean hasMatch = sourceMatcher.find();
        int addedLength = 0;
        boolean startsWithZeroGroupRef = replacement.startsWith("$0");
        while (hasMatch) {
            int startIndex = sourceMatcher.start() + addedLength;
            int endIndex = sourceMatcher.end() + addedLength;
            if (startsWithZeroGroupRef) {
                startIndex = endIndex;
            }
            sourceMatcher.appendReplacement(result, replacement);
            int replacementLength = result.length() - startIndex;
            addedLength += (replacementLength -= endIndex - startIndex);
            if (useInvocationTrace && this.visitor.getCurrentFiles().size() > 0) {
                int offsetGap = -1;
                for (ExpressionTrace trace : this.visitor.getInvocationTraces()) {
                    for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
                        for (GeneratedText text : entry.getValue()) {
                            if (offsetGap != -1 && text.getStartOffset() >= offsetGap) continue;
                            offsetGap = text.getStartOffset();
                        }
                    }
                }
                startIndex += offsetGap;
                endIndex += offsetGap;
                for (ExpressionTrace trace : this.visitor.getInvocationTraces()) {
                    this.changeTraceabilityIndicesOfReplaceOperation(trace, startIndex, endIndex, replacementLength);
                }
                GeneratedFile generatedFile = (GeneratedFile)this.visitor.getCurrentFiles().getLast();
                int fileLength = generatedFile.getLength();
                for (Map.Entry<InputElement, Set<GeneratedText>> entry : substitutionTrace.getTraces().entrySet()) {
                    for (GeneratedText text : entry.getValue()) {
                        GeneratedText copy = (GeneratedText)EcoreUtil.copy((EObject)text);
                        copy.setStartOffset(copy.getStartOffset() + startIndex);
                        copy.setEndOffset(copy.getEndOffset() + startIndex);
                        generatedFile.getGeneratedRegions().add((Object)copy);
                        Iterator traceIterator = this.visitor.getInvocationTraces().iterator();
                        boolean inserted = false;
                        while (traceIterator.hasNext() && !inserted) {
                            inserted = this.insertTextInTrace((ExpressionTrace)traceIterator.next(), copy);
                        }
                    }
                }
                generatedFile.setLength(fileLength + replacementLength);
            } else {
                AbstractTrace trace = this.visitor.getLastExpressionTrace();
                this.changeTraceabilityIndicesOfReplaceOperation(trace, startIndex, endIndex, replacementLength);
                for (Map.Entry<InputElement, Set<GeneratedText>> entry : substitutionTrace.getTraces().entrySet()) {
                    CompactLinkedHashSet existingTraces = trace.getTraces().get(entry.getKey());
                    if (existingTraces == null) {
                        existingTraces = new CompactLinkedHashSet();
                        trace.getTraces().put(entry.getKey(), (Set<GeneratedText>)existingTraces);
                    }
                    for (GeneratedText text : entry.getValue()) {
                        GeneratedText copy = (GeneratedText)EcoreUtil.copy((EObject)text);
                        copy.setStartOffset(copy.getStartOffset() + startIndex);
                        copy.setEndOffset(copy.getEndOffset() + startIndex);
                        existingTraces.add(copy);
                    }
                }
            }
            if (!substituteAll) break;
            hasMatch = sourceMatcher.find();
        }
        sourceMatcher.appendTail(result);
        return result.toString();
    }

    public Collection<Object> visitReverseOperation(Collection<Object> source) {
        CompactLinkedHashSet result;
        block8: {
            CompactLinkedHashSet reversedSet;
            CompactLinkedHashSet temp = new ArrayList(source);
            Collections.reverse(temp);
            result = source instanceof LinkedHashSet ? (reversedSet = new CompactLinkedHashSet(temp)) : temp;
            if (!TraceabilityVisitorUtil.isPrimitive(source)) break block8;
            AbstractTrace trace = this.visitor.getLastExpressionTrace();
            ArrayList regions = new ArrayList();
            for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
                regions.addAll(entry.getValue());
            }
            Collections.sort(regions);
            int regionsLength = 0;
            if (regions.size() == source.size()) {
                int i = regions.size() - 1;
                while (i >= 0) {
                    GeneratedText region = (GeneratedText)regions.get(i);
                    int startOffset = regionsLength;
                    region.setStartOffset(startOffset);
                    region.setEndOffset(regionsLength += region.getEndOffset() - region.getStartOffset());
                    --i;
                }
            } else {
                ArrayList<Integer> valueLengthes = new ArrayList<Integer>(source.size());
                for (Object value : source) {
                    String stringValue = value.toString();
                    valueLengthes.add(stringValue.length());
                }
                Collections.reverse(valueLengthes);
                int i = valueLengthes.size() - 1;
                while (i >= 0) {
                    int valueLength = (Integer)valueLengthes.get(i);
                    GeneratedText region = (GeneratedText)regions.get(i);
                    int regionLength = region.getEndOffset() - region.getStartOffset();
                    int valueRegionsStartIndex = i;
                    int gap = valueLength - regionLength;
                    while (gap > 0) {
                        GeneratedText previous = (GeneratedText)regions.get(--valueRegionsStartIndex);
                        int previousLength = previous.getEndOffset() - previous.getStartOffset();
                        gap -= previousLength;
                    }
                    int j = valueRegionsStartIndex;
                    while (j < regions.size()) {
                        GeneratedText text = (GeneratedText)regions.get(j);
                        int startOffset = regionsLength;
                        region.setStartOffset(startOffset);
                        region.setEndOffset(regionsLength += text.getEndOffset() - text.getEndOffset());
                        ++j;
                    }
                    --i;
                }
            }
        }
        return result;
    }

    public Collection<Object> visitSepOperation(Collection<Object> source, String separator, ExpressionTrace<C> separatorTrace) {
        ArrayList<Object> temp = new ArrayList<Object>(source.size() << 1);
        ArrayList<String> stringSource = new ArrayList<String>();
        Iterator<Object> sourceIterator = source.iterator();
        while (sourceIterator.hasNext()) {
            Object nextSource = sourceIterator.next();
            temp.add(nextSource);
            stringSource.add(nextSource.toString());
            if (!sourceIterator.hasNext()) continue;
            temp.add(separator);
        }
        int separatorLength = separator.length();
        AbstractTrace trace = this.visitor.getLastExpressionTrace();
        int currentSeparatorOffset = 0;
        int i = 0;
        while (i < stringSource.size() - 1) {
            String element = (String)stringSource.get(i);
            currentSeparatorOffset += element.length();
            Iterator<Map.Entry<InputElement, Set<GeneratedText>>> entryIterator = trace.getTraces().entrySet().iterator();
            while (entryIterator.hasNext()) {
                for (GeneratedText text : entryIterator.next().getValue()) {
                    if (text.getStartOffset() < currentSeparatorOffset) continue;
                    text.setStartOffset(text.getStartOffset() + separatorLength);
                    text.setEndOffset(text.getEndOffset() + separatorLength);
                }
            }
            for (Map.Entry<InputElement, Set<GeneratedText>> entry : separatorTrace.getTraces().entrySet()) {
                CompactLinkedHashSet existingTraces = trace.getTraces().get(entry.getKey());
                if (existingTraces == null) {
                    existingTraces = new CompactLinkedHashSet();
                    trace.getTraces().put(entry.getKey(), (Set<GeneratedText>)existingTraces);
                }
                for (GeneratedText text : entry.getValue()) {
                    GeneratedText copy = (GeneratedText)EcoreUtil.copy((EObject)text);
                    copy.setStartOffset(copy.getStartOffset() + currentSeparatorOffset);
                    copy.setEndOffset(copy.getEndOffset() + currentSeparatorOffset);
                    existingTraces.add(copy);
                }
            }
            currentSeparatorOffset += separatorLength;
            ++i;
        }
        return temp;
    }

    public String visitStrtokOperation(String source, String delimiters, Integer flag) {
        String result;
        TraceabilityTokenizer tokenizer;
        if (flag == 0) {
            tokenizer = new TraceabilityTokenizer(source, delimiters);
            TOKENIZERS.put(source, tokenizer);
            result = tokenizer.nextToken();
        } else if (flag == 1) {
            if (TOKENIZERS.containsKey(source)) {
                tokenizer = TOKENIZERS.get(source);
            } else {
                tokenizer = new TraceabilityTokenizer(source, delimiters);
                TOKENIZERS.put(source, tokenizer);
            }
            String token = "";
            if (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
            }
            result = token;
        } else {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString((String)"AcceleoEvaluationEnvironment.IllegalTokenizerFlag", (Object[])new Object[]{flag}));
        }
        this.changeTraceabilityIndicesSubstringReturn(tokenizer.getLastOffset(), tokenizer.getNextOffset());
        return result;
    }

    public String visitSubstringOperation(String source, int startIndex) {
        this.changeTraceabilityIndicesSubstringReturn(startIndex, source.length());
        return source.substring(startIndex);
    }

    public String visitSubstringOperation(String source, int startIndex, int endIndex) {
        this.changeTraceabilityIndicesSubstringReturn(startIndex, endIndex);
        return source.substring(startIndex, endIndex);
    }

    public List<String> visitTokenizeOperation(String source, String delims) {
        TraceabilityTokenizer tokenizer = new TraceabilityTokenizer(source, delims);
        ArrayList<String> result = new ArrayList<String>();
        AbstractTrace trace = this.visitor.getLastExpressionTrace();
        int[][] tokenRegions = new int[tokenizer.countTokens()][2];
        int tokenCount = 0;
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
            int startIndex = tokenizer.getLastOffset();
            int endIndex = tokenizer.getNextOffset();
            tokenRegions[tokenCount][0] = startIndex;
            tokenRegions[tokenCount][1] = endIndex;
            ++tokenCount;
        }
        if (result.size() == 1) {
            this.changeTraceabilityIndicesSubstringReturn(tokenRegions[0][0], tokenRegions[0][1]);
        } else {
            Set<Map.Entry<InputElement, Set<GeneratedText>>> traceRegions = trace.getTraces().entrySet();
            if (trace.getTraces().size() == 1 && traceRegions.iterator().next().getValue().size() == 1) {
                Map.Entry<InputElement, Set<GeneratedText>> entry = traceRegions.iterator().next();
                Set<GeneratedText> generatedRegions = entry.getValue();
                GeneratedText firstRegion = generatedRegions.iterator().next();
                int length = tokenRegions[0][1] - tokenRegions[0][0];
                firstRegion.setStartOffset(0);
                firstRegion.setEndOffset(length);
                int i = 1;
                while (i < tokenRegions.length) {
                    int start = tokenRegions[i][0];
                    int end = tokenRegions[i][1];
                    int startOffset = length;
                    GeneratedText newRegion = (GeneratedText)EcoreUtil.copy((EObject)firstRegion);
                    newRegion.setStartOffset(startOffset);
                    newRegion.setEndOffset(length += end - start);
                    generatedRegions.add(newRegion);
                    ++i;
                }
            } else {
                this.changeTraceabilityIndicesComplexTokenize(trace, tokenRegions);
            }
        }
        return result;
    }

    public String visitTostringOperation(Object source, ModuleElement moduleElement) {
        StringBuffer buffer = new StringBuffer();
        if (source instanceof Collection) {
            Iterator childrenIterator = ((Collection)source).iterator();
            while (childrenIterator.hasNext()) {
                buffer.append(this.visitTostringOperation(childrenIterator.next(), moduleElement));
            }
        } else if (source != null) {
            String result = source.toString();
            buffer.append(result);
            if (source instanceof EObject) {
                AbstractTrace trace = this.visitor.getLastExpressionTrace();
                GeneratedText region = TraceabilityFactory.eINSTANCE.createGeneratedText();
                region.setModuleElement(moduleElement);
                trace.addTrace(this.visitor.getInputElement((EObject)source), region, result);
            }
        }
        return buffer.toString();
    }

    public String visitTrimOperation(String source) {
        return this.visitTrimOperation(source, 0);
    }

    public String visitTrimOperation(String source, int gap) {
        int start = 0;
        int end = source.length();
        char[] chars = source.toCharArray();
        while (start < end && chars[start] <= ' ') {
            ++start;
        }
        while (start < end && chars[end - 1] <= ' ') {
            --end;
        }
        this.changeTraceabilityIndicesSubstringReturn(start += gap, end += gap);
        return source.trim();
    }

    void changeTraceabilityIndicesBooleanReturn(boolean result, Object source, ModuleElement moduleElement) {
        if (!this.visitor.getLastExpressionTrace().getTraces().isEmpty()) {
            this.changeTraceabilityIndicesBooleanReturn(result);
        } else if (source instanceof EObject) {
            AbstractTrace trace = this.visitor.getLastExpressionTrace();
            GeneratedText region = TraceabilityFactory.eINSTANCE.createGeneratedText();
            region.setModuleElement(moduleElement);
            int length = result ? 4 : 5;
            trace.addTrace(this.visitor.getInputElement((EObject)source), region, length);
        }
    }

    void changeTraceabilityIndicesNumberReturn(Number result, Object source, ModuleElement moduleElement) {
        if (!this.visitor.getLastExpressionTrace().getTraces().isEmpty()) {
            this.changeTraceabilityIndicesNumberReturn(result);
        } else if (source instanceof EObject) {
            AbstractTrace trace = this.visitor.getLastExpressionTrace();
            GeneratedText region = TraceabilityFactory.eINSTANCE.createGeneratedText();
            region.setModuleElement(moduleElement);
            int length = String.valueOf(result).length();
            trace.addTrace(this.visitor.getInputElement((EObject)source), region, length);
        }
    }

    private void changeTraceabilityIndicesBooleanReturn(boolean result) {
        AbstractTrace trace = this.visitor.getLastExpressionTrace();
        Map.Entry<InputElement, Set<GeneratedText>> lastEntry = null;
        GeneratedText lastRegion = null;
        ArrayList<GeneratedText> removeRegions = new ArrayList<GeneratedText>();
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
            Iterator<GeneratedText> textIterator = entry.getValue().iterator();
            while (textIterator.hasNext()) {
                GeneratedText text = textIterator.next();
                if (lastRegion == null) {
                    lastRegion = text;
                    lastEntry = entry;
                    continue;
                }
                if (text.getEndOffset() > lastRegion.getEndOffset()) {
                    assert (lastEntry != null);
                    removeRegions.add(lastRegion);
                    if (entry != lastEntry) {
                        lastEntry.getValue().removeAll(removeRegions);
                        removeRegions.clear();
                    }
                    lastRegion = text;
                    lastEntry = entry;
                    continue;
                }
                textIterator.remove();
            }
        }
        int length = result ? 4 : 5;
        if (lastRegion != null) {
            lastRegion.setStartOffset(0);
            lastRegion.setEndOffset(length);
        }
        trace.setOffset(length);
    }

    private void changeTraceabilityIndicesComplexTokenize(AbstractTrace trace, int[][] tokenRegions) {
        HashMap<InputElement, Set<GeneratedText>> traceCopy = new HashMap<InputElement, Set<GeneratedText>>(trace.getTraces());
        trace.getTraces().clear();
        int length = 0;
        int[][] nArray = tokenRegions;
        int n = tokenRegions.length;
        int n2 = 0;
        while (n2 < n) {
            int[] tokenRegion = nArray[n2];
            int tokenStart = tokenRegion[0];
            int tokenEnd = tokenRegion[1];
            int tokenLength = tokenEnd - tokenStart;
            int expectedLength = length + tokenLength;
            Iterator entryIterator = traceCopy.entrySet().iterator();
            while (entryIterator.hasNext() && length < expectedLength) {
                Map.Entry entry = entryIterator.next();
                Iterator textIterator = ((Set)entry.getValue()).iterator();
                while (textIterator.hasNext() && length < expectedLength) {
                    GeneratedText text = (GeneratedText)textIterator.next();
                    GeneratedText tokenText = null;
                    if (text.getStartOffset() <= tokenStart && text.getEndOffset() >= tokenEnd) {
                        tokenText = TraceabilityFactory.eINSTANCE.createGeneratedText();
                        tokenText.setStartOffset(length);
                        tokenText.setEndOffset(length + tokenLength);
                        tokenText.setModuleElement(text.getModuleElement());
                        tokenText.setOutputFile(text.getOutputFile());
                        tokenText.setSourceElement(text.getSourceElement());
                        length += tokenLength;
                    } else if (text.getStartOffset() >= tokenStart && text.getEndOffset() <= tokenEnd) {
                        int textLength = text.getEndOffset() - text.getStartOffset();
                        tokenText = (GeneratedText)EcoreUtil.copy((EObject)text);
                        tokenText.setStartOffset(length);
                        tokenText.setEndOffset(length + textLength);
                        length += textLength;
                    } else if (text.getStartOffset() <= tokenStart && text.getEndOffset() > tokenStart && text.getEndOffset() < tokenEnd) {
                        int tokenRegionLength = text.getEndOffset() - tokenStart;
                        tokenText = TraceabilityFactory.eINSTANCE.createGeneratedText();
                        tokenText.setStartOffset(length);
                        tokenText.setEndOffset(length + tokenRegionLength);
                        tokenText.setModuleElement(text.getModuleElement());
                        tokenText.setOutputFile(text.getOutputFile());
                        tokenText.setSourceElement(text.getSourceElement());
                        length += tokenRegionLength;
                    } else if (text.getStartOffset() < tokenEnd && text.getEndOffset() >= tokenEnd && text.getStartOffset() > tokenStart) {
                        int tokenRegionLength = tokenEnd - text.getStartOffset();
                        tokenText = TraceabilityFactory.eINSTANCE.createGeneratedText();
                        tokenText.setStartOffset(length);
                        tokenText.setEndOffset(length + tokenRegionLength);
                        tokenText.setModuleElement(text.getModuleElement());
                        tokenText.setOutputFile(text.getOutputFile());
                        tokenText.setSourceElement(text.getSourceElement());
                        length += tokenRegionLength;
                    }
                    if (tokenText == null) continue;
                    InputElement tokenKey = (InputElement)entry.getKey();
                    CompactLinkedHashSet tokenTraces = trace.getTraces().get(tokenKey);
                    if (tokenTraces == null) {
                        tokenTraces = new CompactLinkedHashSet();
                        trace.getTraces().put(tokenKey, (Set<GeneratedText>)tokenTraces);
                    }
                    tokenTraces.add((GeneratedText)tokenText);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : traceCopy.entrySet()) {
            ((Set)entry.getValue()).clear();
        }
        traceCopy.clear();
        trace.setOffset(length);
    }

    private void changeTraceabilityIndicesNumberReturn(Number result) {
        AbstractTrace trace = this.visitor.getLastExpressionTrace();
        Map.Entry<InputElement, Set<GeneratedText>> lastEntry = null;
        GeneratedText lastRegion = null;
        ArrayList<GeneratedText> rejectFromEntry = new ArrayList<GeneratedText>();
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
            Iterator<GeneratedText> textIterator = entry.getValue().iterator();
            while (textIterator.hasNext()) {
                GeneratedText text = textIterator.next();
                if (lastRegion == null) {
                    lastRegion = text;
                    lastEntry = entry;
                    continue;
                }
                if (text.getEndOffset() > lastRegion.getEndOffset()) {
                    assert (lastEntry != null);
                    if (lastEntry != entry) {
                        lastEntry.getValue().remove(lastRegion);
                        lastEntry = entry;
                    } else {
                        rejectFromEntry.add(lastRegion);
                    }
                    lastRegion = text;
                    continue;
                }
                textIterator.remove();
            }
            if (rejectFromEntry.isEmpty()) continue;
            entry.getValue().removeAll(rejectFromEntry);
            rejectFromEntry.clear();
        }
        int length = String.valueOf(result).length();
        if (lastRegion != null) {
            lastRegion.setStartOffset(0);
            lastRegion.setEndOffset(length);
        }
        trace.setOffset(length);
    }

    private void changeTraceabilityIndicesOfReplaceOperation(AbstractTrace trace, int startIndex, int endIndex, int replacementLength) {
        ArrayList<GeneratedText> addedRegions = new ArrayList<GeneratedText>();
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
            Iterator<GeneratedText> textIterator = entry.getValue().iterator();
            while (textIterator.hasNext()) {
                GeneratedText text = textIterator.next();
                if (text.getEndOffset() < startIndex) continue;
                if (text.getStartOffset() < startIndex && text.getEndOffset() == endIndex) {
                    text.setEndOffset(startIndex);
                    continue;
                }
                if (text.getStartOffset() == startIndex && text.getEndOffset() > endIndex) {
                    text.setStartOffset(endIndex);
                    text.setEndOffset(text.getEndOffset() + replacementLength);
                    continue;
                }
                if (text.getStartOffset() < startIndex && text.getEndOffset() > endIndex) {
                    GeneratedText endSubstring = (GeneratedText)EcoreUtil.copy((EObject)text);
                    endSubstring.setStartOffset(endIndex + replacementLength);
                    endSubstring.setEndOffset(text.getEndOffset() + replacementLength);
                    text.setEndOffset(startIndex);
                    if (text.eContainer() != null) {
                        ((List)text.eContainer().eGet(text.eContainingFeature())).add(endSubstring);
                    }
                    addedRegions.add(endSubstring);
                    continue;
                }
                if (text.getStartOffset() >= startIndex && text.getEndOffset() <= endIndex) {
                    if (text.eContainer() != null) {
                        EcoreUtil.remove((EObject)text);
                    }
                    textIterator.remove();
                    continue;
                }
                text.setStartOffset(text.getStartOffset() + replacementLength);
                text.setEndOffset(text.getEndOffset() + replacementLength);
            }
            entry.getValue().addAll(addedRegions);
            addedRegions.clear();
        }
    }

    private void changeTraceabilityIndicesSubstringReturn(int startIndex, int endIndex) {
        if (this.visitor.isEvaluatingPostCall()) {
            int offsetGap = -1;
            for (ExpressionTrace trace : this.visitor.getInvocationTraces()) {
                for (Map.Entry entry : trace.getTraces().entrySet()) {
                    for (GeneratedText text : (Set)entry.getValue()) {
                        if (offsetGap != -1 && text.getStartOffset() >= offsetGap) continue;
                        offsetGap = text.getStartOffset();
                    }
                }
            }
            int actualStartIndex = startIndex + offsetGap;
            int actualEndIndex = endIndex + offsetGap;
            for (ExpressionTrace trace : this.visitor.getInvocationTraces()) {
                for (Map.Entry entry : trace.getTraces().entrySet()) {
                    Iterator textIterator = ((Set)entry.getValue()).iterator();
                    while (textIterator.hasNext()) {
                        GeneratedText text = (GeneratedText)textIterator.next();
                        GeneratedFile output = text.getOutputFile();
                        int removedLength = 0;
                        if (text.getEndOffset() <= actualStartIndex || text.getStartOffset() >= actualEndIndex) {
                            textIterator.remove();
                            EcoreUtil.remove((EObject)text);
                            removedLength = text.getEndOffset() - text.getStartOffset();
                        } else {
                            int initialLength = text.getEndOffset() - text.getStartOffset();
                            if (text.getStartOffset() < actualStartIndex && text.getEndOffset() > actualEndIndex) {
                                text.setStartOffset(offsetGap);
                                text.setEndOffset(endIndex - startIndex);
                            } else if (text.getStartOffset() < actualStartIndex) {
                                text.setStartOffset(offsetGap);
                                text.setEndOffset(text.getEndOffset() - startIndex);
                            } else if (text.getEndOffset() > actualEndIndex) {
                                text.setStartOffset(text.getStartOffset() - startIndex);
                                text.setEndOffset(endIndex - startIndex);
                            } else {
                                text.setStartOffset(text.getStartOffset() - startIndex);
                                text.setEndOffset(text.getEndOffset() - startIndex);
                            }
                            removedLength = initialLength - text.getEndOffset() + text.getStartOffset();
                        }
                        if (output == null || removedLength <= 0) continue;
                        output.setLength(output.getLength() - removedLength);
                    }
                }
            }
        } else {
            AbstractTrace trace = this.visitor.isInitializingVariable() ? this.visitor.getInitializingVariableTrace() : this.visitor.getLastExpressionTrace();
            for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
                Iterator<GeneratedText> textIterator = entry.getValue().iterator();
                while (textIterator.hasNext()) {
                    GeneratedText text = textIterator.next();
                    int removedLength = 0;
                    if (text.getEndOffset() <= startIndex || text.getStartOffset() >= endIndex) {
                        textIterator.remove();
                        removedLength = text.getEndOffset() - text.getStartOffset();
                    } else {
                        int initialLength = text.getEndOffset() - text.getStartOffset();
                        if (text.getStartOffset() < startIndex && text.getEndOffset() > endIndex) {
                            text.setStartOffset(0);
                            text.setEndOffset(endIndex - startIndex);
                        } else if (text.getStartOffset() < startIndex) {
                            text.setStartOffset(0);
                            text.setEndOffset(text.getEndOffset() - startIndex);
                        } else if (text.getEndOffset() > endIndex) {
                            text.setStartOffset(text.getStartOffset() - startIndex);
                            text.setEndOffset(endIndex - startIndex);
                        } else {
                            text.setStartOffset(text.getStartOffset() - startIndex);
                            text.setEndOffset(text.getEndOffset() - startIndex);
                        }
                        removedLength = initialLength - text.getEndOffset() + text.getStartOffset();
                    }
                    trace.setOffset(trace.getOffset() - removedLength);
                }
            }
        }
    }

    private boolean insertTextInTrace(ExpressionTrace<C> trace, GeneratedText text) {
        boolean insert = false;
        Iterator<Set<GeneratedText>> setIterator = trace.getTraces().values().iterator();
        while (setIterator.hasNext() && !insert) {
            Set<GeneratedText> candidate = setIterator.next();
            Iterator<GeneratedText> iterator = candidate.iterator();
            while (iterator.hasNext() && !insert) {
                GeneratedText next = iterator.next();
                if (next.getStartOffset() != text.getEndOffset() && next.getEndOffset() != text.getStartOffset()) continue;
                insert = true;
            }
            if (!insert) continue;
            candidate.add(text);
        }
        return insert;
    }
}

