/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Messages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDocumentProvider;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.project.builder.WorkspaceUnitResolver;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class QvtCompilerFacade {
    private static QvtCompilerFacade ourInstance;

    private QvtCompilerFacade() {
    }

    public CompiledUnit compile(ITextEditor editor, IDocument document, QvtCompilerOptions options, IProgressMonitor monitor) {
        if (!this.checkEditor(editor)) {
            return null;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.QvtCompilerFacade_compilingDoc, 4);
        CompiledUnit result = null;
        try {
            monitor.subTask(Messages.QvtCompilerFacade_acquiringDoc);
            IFile file = ((FileEditorInput)editor.getEditorInput()).getFile();
            QvtDocumentProvider documentProvider = (QvtDocumentProvider)editor.getDocumentProvider();
            monitor.worked(1);
            final String contents = document.get();
            try {
                final UnitProxy unit = WorkspaceUnitResolver.getUnit((IFile)file);
                QVTOCompiler compiler = new QVTOCompiler(unit.getResolver()){

                    protected Reader createReader(UnitProxy source) throws IOException {
                        if (source.equals((Object)unit)) {
                            return new StringReader(contents);
                        }
                        return super.createReader(source);
                    }
                };
                result = compiler.compile(unit, options, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                if (result != null) {
                    documentProvider.setMappingModule(result);
                }
            }
            catch (MdaException e) {
                documentProvider.setMappingModule(result);
                Activator.log(e);
            }
            if (options.isReportErrors()) {
                options.isShowAnnotations();
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    public static QvtCompilerFacade getInstance() {
        if (ourInstance == null) {
            ourInstance = new QvtCompilerFacade();
        }
        return ourInstance;
    }

    private boolean checkEditor(ITextEditor editor) {
        return editor != null && editor.getEditorInput() instanceof FileEditorInput && editor.getDocumentProvider() != null;
    }

    static boolean isEditingInQvtSourceContainer(ITextEditor editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return false;
        }
        IFile file = ((FileEditorInput)editorInput).getFile();
        if (file != null && file.exists()) {
            try {
                IContainer srcContainer = QVTOBuilderConfig.getConfig((IProject)file.getProject()).getSourceContainer();
                if (srcContainer.exists()) {
                    IPath editedPath = file.getFullPath();
                    IPath srcPath = srcContainer.getFullPath();
                    return srcPath.isPrefixOf(editedPath);
                }
            }
            catch (CoreException e) {
                QvtPlugin.log((Throwable)e);
            }
        }
        return false;
    }
}

