/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.MetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.IImportResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.DeployedImportResolver;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.osgi.util.NLS;

public class DeployedQvtModule
extends QvtModule {
    private CompiledModule myModule;
    private QvtCompiler myCompiler;
    private String moduleID;

    public DeployedQvtModule(String qvtModuleID) {
        if (qvtModuleID == null || qvtModuleID.length() == 0) {
            throw new IllegalArgumentException("Invalid QVT module ID");
        }
        this.moduleID = qvtModuleID;
    }

    protected IMetamodelRegistryProvider creatMetamodelRegistryProvider() {
        return new MetamodelRegistryProvider();
    }

    public CompiledModule getModule(boolean isCheckErrors) throws MdaException {
        if (this.myModule == null) {
            DeployedImportResolver importResolver = new DeployedImportResolver();
            CFile srcFile = importResolver.resolveImport(this.moduleID);
            if (srcFile == null) {
                throw new MdaException(NLS.bind((String)CompilerMessages.importedModuleNotFound, (Object)this.moduleID));
            }
            QvtCompiler qvtCompiler = new QvtCompiler((IImportResolver)importResolver, this.creatMetamodelRegistryProvider());
            QvtCompilerOptions options = this.getQvtCompilerOptions();
            if (options == null) {
                options = new QvtCompilerOptions();
                options.setGenerateCompletionData(false);
            }
            CompiledModule module = qvtCompiler.compile(srcFile, options, null).getModule();
            if (isCheckErrors) {
                this.checkModuleErrors(module);
            }
            this.myModule = module;
            this.myCompiler = qvtCompiler;
        }
        return this.myModule;
    }

    public CompiledModule getModule() throws MdaException {
        return this.getModule(true);
    }

    public QvtCompiler getCompiler() throws MdaException {
        this.getModule();
        return this.myCompiler;
    }

    public String toString() {
        return "deployed:/" + this.moduleID;
    }
}

