/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io.eclipse;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseResource;

public class EclipseFile
extends EclipseResource
implements CFile {
    private String myUnitName;

    public EclipseFile(IFile file) {
        super((IResource)file);
        this.myUnitName = file.getName();
        int dot = this.myUnitName.lastIndexOf(46);
        if (dot != -1) {
            this.myUnitName = this.myUnitName.substring(0, dot);
        }
    }

    public InputStream getContents() throws IOException {
        try {
            return this.getFile().getContents();
        }
        catch (CoreException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
    }

    public String getUnitName() {
        return this.myUnitName;
    }

    public void create(InputStream contents) throws IOException {
        try {
            this.getFile().create(contents, true, null);
        }
        catch (CoreException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
    }

    public void setContents(InputStream contents) throws IOException {
        try {
            this.getFile().setContents(contents, true, true, null);
        }
        catch (CoreException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
    }

    public String getCharset() throws IOException {
        try {
            String charset = this.getFile().getCharset();
            return charset;
        }
        catch (CoreException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
    }

    public IFile getFile() {
        return (IFile)this.myResource;
    }

    public long getTimeStamp() {
        return this.getFile().getLocalTimeStamp();
    }
}

