/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.FeatureCall;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionExpression
extends FeatureCall {
    private Expression closure;
    private String eleName;

    public CollectionExpression(int end, Identifier opNAme, String eleName, Expression closure, Expression target) {
        super(opNAme.getStart(), end, opNAme.getLine(), opNAme, target);
        this.eleName = eleName;
        this.closure = closure;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(" + (this.eleName != null ? String.valueOf(this.eleName) + "|" : "") + this.closure + ")";
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Object targetObj = null;
        if (this.getTarget() == null) {
            Variable v = ctx.getVariable("this");
            if (v != null) {
                targetObj = v.getValue();
            }
        } else {
            targetObj = this.getTarget().evaluate(ctx);
        }
        if (targetObj == null) {
            return null;
        }
        if (!(targetObj instanceof Collection)) {
            throw new EvaluationException("Couldn't call '" + this.toString() + "' on an object of java type " + targetObj.getClass().getName(), (SyntaxElement)this);
        }
        if (this.getName().getValue().equals("collect")) {
            return this.executeCollect((Collection)targetObj, ctx);
        }
        if (this.getName().getValue().equals("select")) {
            return this.executeSelect((Collection)targetObj, ctx);
        }
        if (this.getName().getValue().equals("reject")) {
            return this.executeReject((Collection)targetObj, ctx);
        }
        if (this.getName().getValue().equals("exists")) {
            return this.executeExists((Collection)targetObj, ctx);
        }
        if (this.getName().getValue().equals("notExists")) {
            return this.executeNotExists((Collection)targetObj, ctx);
        }
        if (this.getName().getValue().equals("forAll")) {
            return this.executeForAll((Collection)targetObj, ctx);
        }
        throw new EvaluationException("Unkown collection operation : " + this.getName().getValue(), (SyntaxElement)this);
    }

    private Object executeForAll(Collection collection, ExecutionContext ctx) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object result = this.closure.evaluate(ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), iter.next())));
            if (result instanceof Boolean && ((Boolean)result).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object executeExists(Collection collection, ExecutionContext ctx) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object result = this.closure.evaluate(ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), iter.next())));
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Object executeNotExists(Collection collection, ExecutionContext ctx) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object result = this.closure.evaluate(ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), iter.next())));
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object executeReject(Collection<?> collection, ExecutionContext ctx) {
        ArrayList resultCol = new ArrayList(collection);
        for (Object ele : collection) {
            Object result = this.closure.evaluate(ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), ele)));
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
            resultCol.remove(ele);
        }
        return resultCol;
    }

    private Object executeSelect(Collection collection, ExecutionContext ctx) {
        ArrayList resultCol = new ArrayList();
        for (Object ele : collection) {
            Object result = this.closure.evaluate(ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), ele)));
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
            resultCol.add(ele);
        }
        return resultCol;
    }

    private Object executeCollect(Collection collection, ExecutionContext ctx) {
        ArrayList<Object> resultCol = new ArrayList<Object>();
        for (Object ele : collection) {
            ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), ele));
            resultCol.add(this.closure.evaluate(ctx));
        }
        return resultCol;
    }

    @Override
    public EClassifier analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier targetType = null;
        if (this.getTarget() == null) {
            Variable v = ctx.getVariable("this");
            if (v != null) {
                targetType = (EClassifier)v.getValue();
            }
        } else {
            targetType = this.getTarget().analyze(ctx, issues);
        }
        if (targetType == null) {
            return null;
        }
        if (!BuiltinMetaModel.isParameterizedType(targetType)) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Collection type expected! was : " + targetType, this.getTarget()));
            return null;
        }
        EClassifier innerEClassifier = BuiltinMetaModel.getInnerType(targetType);
        EDataType result = null;
        ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), innerEClassifier));
        EClassifier closureEClassifier = this.closure.analyze(ctx, issues);
        if (this.getName().getValue().equals("collect")) {
            if (targetType.getName().startsWith("Set")) {
                return BuiltinMetaModel.getSetType(closureEClassifier);
            }
            if (targetType.getName().startsWith("List")) {
                return BuiltinMetaModel.getListType(closureEClassifier);
            }
            return BuiltinMetaModel.getCollectionType(closureEClassifier);
        }
        if (this.getName().getValue().equals("select") || this.getName().getValue().equals("reject")) {
            return targetType;
        }
        if (this.getName().getValue().equals("typeSelect")) {
            if (closureEClassifier == null) {
                return null;
            }
            return BuiltinMetaModel.getListType(closureEClassifier);
        }
        if (this.getName().getValue().equals("exists") || this.getName().getValue().equals("notExists") || this.getName().getValue().equals("forAll")) {
            if (!BuiltinMetaModel.isAssignableFrom((EClassifier)EcorePackage.eINSTANCE.getEBoolean(), closureEClassifier)) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Boolean type expected! was : " + closureEClassifier, this.closure));
            }
            result = EcorePackage.eINSTANCE.getEBoolean();
        } else {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INTERNAL_ERROR, "Unknown operation : " + this.getName().getValue(), this));
        }
        return result;
    }

    private String getElementName() {
        return this.eleName != null ? this.eleName : "element";
    }
}

