/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gef;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.codegen.gmfgen.CustomParser;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.ExpressionLabelParser;
import org.eclipse.gmf.codegen.gmfgen.ExternalParser;
import org.eclipse.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.gmf.codegen.gmfgen.GenLanguage;
import org.eclipse.gmf.codegen.gmfgen.GenLiteralExpressionProvider;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenParserImplementation;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.LabelTextAccessMethod;
import org.eclipse.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.gmf.codegen.gmfgen.PredefinedParser;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelMatcher;
import org.eclipse.gmf.internal.bridge.genmodel.RuntimeGenModelAccess;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserProvider;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ParserHintAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.NeedsSetup;
import org.eclipse.gmf.tests.TestConfiguration;
import org.eclipse.gmf.tests.Utils;
import org.eclipse.gmf.tests.setup.GenProjectSetup;
import org.eclipse.gmf.tests.setup.RuntimeBasedGeneratorConfiguration;
import org.osgi.framework.Bundle;

public class ParsersTest
extends TestCase {
    protected ParsersSetup setup;

    public ParsersTest(String name) {
        super(name);
    }

    @NeedsSetup
    public final void configure(ParsersSetup ps) throws Exception {
        this.setup = ps;
        this.setup.init();
    }

    protected void tearDown() throws Exception {
        this.setup.dispose();
        this.setup = null;
    }

    public void testDefaultLabel() throws Exception {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createURI((String)"uri://org.eclipse.gmf/tests/parkins"));
        EObject nodkin = this.createNodkin();
        r.getContents().add((Object)nodkin);
        this.setAttribute(nodkin, "a1", "aaa");
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rs);
        IParser p = this.getParser(this.setup.genModel.a1);
        String s = p.getPrintString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertEquals((String)"aaa", (String)s);
        s = p.getEditString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertEquals((String)"aaa", (String)s);
        ICommand c = p.getParseCommand((IAdaptable)new EObjectAdapter(nodkin), "bbb", 0);
        ParsersTest.assertTrue((boolean)c.canExecute());
        c.execute((IProgressMonitor)new NullProgressMonitor(), (IAdaptable)new EObjectAdapter(nodkin));
        s = (String)this.getAttribute(nodkin, "a1");
        ParsersTest.assertEquals((String)"bbb", (String)s);
    }

    public void testMultipleAttributes() throws Exception {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createURI((String)"uri://org.eclipse.gmf/tests/parkins"));
        EObject nodkin = this.createNodkin();
        r.getContents().add((Object)nodkin);
        this.setAttribute(nodkin, "a1", "aaa");
        this.setAttribute(nodkin, "a2", "xxx");
        this.setAttribute(nodkin, "a3", new Integer(555));
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rs);
        IParser p = this.getParser(this.setup.genModel.a123);
        String s = p.getPrintString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertEquals((String)"aaa xxx 555", (String)s);
        s = p.getEditString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertEquals((String)"aaa xxx 555", (String)s);
        ICommand c = p.getParseCommand((IAdaptable)new EObjectAdapter(nodkin), "bbb yyy 888", 0);
        ParsersTest.assertTrue((boolean)c.canExecute());
        c.execute((IProgressMonitor)new NullProgressMonitor(), (IAdaptable)new EObjectAdapter(nodkin));
        s = (String)this.getAttribute(nodkin, "a1");
        ParsersTest.assertEquals((String)"bbb", (String)s);
        s = (String)this.getAttribute(nodkin, "a2");
        ParsersTest.assertEquals((String)"yyy", (String)s);
        Integer i = (Integer)this.getAttribute(nodkin, "a3");
        ParsersTest.assertEquals((int)888, (int)i);
    }

    public void testCustomMessageFormatPatterns() throws Exception {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createURI((String)"uri://org.eclipse.gmf/tests/parkins"));
        EObject nodkin = this.createNodkin();
        r.getContents().add((Object)nodkin);
        this.setAttribute(nodkin, "a1", "gold");
        this.setAttribute(nodkin, "a2", "silver");
        this.setAttribute(nodkin, "a3", new Integer(100));
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rs);
        IParser p = this.getParser(this.setup.genModel.ac132);
        String s = p.getPrintString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertEquals((String)"silver x 100 (gold)", (String)s);
        s = p.getEditString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertEquals((String)"silver/100/gold", (String)s);
        ICommand c = p.getParseCommand((IAdaptable)new EObjectAdapter(nodkin), "[50] - ping, pong", 0);
        ParsersTest.assertTrue((boolean)c.canExecute());
        c.execute((IProgressMonitor)new NullProgressMonitor(), (IAdaptable)new EObjectAdapter(nodkin));
        s = (String)this.getAttribute(nodkin, "a1");
        ParsersTest.assertEquals((String)"ping", (String)s);
        s = (String)this.getAttribute(nodkin, "a2");
        ParsersTest.assertEquals((String)"pong", (String)s);
        Integer i = (Integer)this.getAttribute(nodkin, "a3");
        ParsersTest.assertEquals((int)50, (int)i);
    }

    public void testDifferentEditableAttributes() throws Exception {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createURI((String)"uri://org.eclipse.gmf/tests/parkins"));
        EObject nodkin = this.createNodkin();
        r.getContents().add((Object)nodkin);
        this.setAttribute(nodkin, "a1", "gold");
        this.setAttribute(nodkin, "a2", "silver");
        this.setAttribute(nodkin, "a3", new Integer(100));
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rs);
        IParser p = this.getParser(this.setup.genModel.a12e31);
        String s = p.getPrintString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertEquals((String)"gold*silver", (String)s);
        s = p.getEditString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertEquals((String)"<gold>100", (String)s);
        ICommand c = p.getParseCommand((IAdaptable)new EObjectAdapter(nodkin), "23:ping", 0);
        ParsersTest.assertTrue((boolean)c.canExecute());
        c.execute((IProgressMonitor)new NullProgressMonitor(), (IAdaptable)new EObjectAdapter(nodkin));
        s = (String)this.getAttribute(nodkin, "a1");
        ParsersTest.assertEquals((String)"ping", (String)s);
        s = (String)this.getAttribute(nodkin, "a2");
        ParsersTest.assertEquals((String)"silver", (String)s);
        Integer i = (Integer)this.getAttribute(nodkin, "a3");
        ParsersTest.assertEquals((int)23, (int)i);
    }

    public void testNativeParsing() throws Exception {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createURI((String)"uri://org.eclipse.gmf/tests/parkins"));
        EObject nodkin = this.createNodkin();
        r.getContents().add((Object)nodkin);
        this.setAttribute(nodkin, "a2", "aaa");
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rs);
        IParser p = this.getParser(this.setup.genModel.an2);
        String s = p.getPrintString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertEquals((String)"aaa", (String)s);
        s = p.getEditString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertEquals((String)"aaa", (String)s);
        ICommand c = p.getParseCommand((IAdaptable)new EObjectAdapter(nodkin), "bbb", 0);
        ParsersTest.assertTrue((boolean)c.canExecute());
        c.execute((IProgressMonitor)new NullProgressMonitor(), (IAdaptable)new EObjectAdapter(nodkin));
        s = (String)this.getAttribute(nodkin, "a2");
        ParsersTest.assertEquals((String)"bbb", (String)s);
    }

    public void testPrintfAndRegexpParsing() throws Exception {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createURI((String)"uri://org.eclipse.gmf/tests/parkins"));
        EObject nodkin = this.createNodkin();
        r.getContents().add((Object)nodkin);
        this.setAttribute(nodkin, "a2", "aaa");
        this.setAttribute(nodkin, "a3", new Integer(6));
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rs);
        IParser p = this.getParser(this.setup.genModel.apr23);
        String s = p.getPrintString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertEquals((String)"aaa 6", (String)s);
        s = p.getEditString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertEquals((String)"aaa 6", (String)s);
        ICommand c = p.getParseCommand((IAdaptable)new EObjectAdapter(nodkin), "bbb 7", 0);
        ParsersTest.assertTrue((boolean)c.canExecute());
        c.execute((IProgressMonitor)new NullProgressMonitor(), (IAdaptable)new EObjectAdapter(nodkin));
        s = (String)this.getAttribute(nodkin, "a2");
        ParsersTest.assertEquals((String)"bbb", (String)s);
        Integer i = (Integer)this.getAttribute(nodkin, "a3");
        ParsersTest.assertEquals((int)7, (int)i);
    }

    public void testCustomParserPlainLabelModelFacet() throws Exception {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createURI((String)"uri://org.eclipse.gmf/tests/parkins"));
        EObject nodkin = this.createNodkin();
        r.getContents().add((Object)nodkin);
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rs);
        ParsersTest.assertTrue((String)"sanity", (this.setup.genModel.a_cp_pmf.getModelFacet().eClass() == GMFGenPackage.eINSTANCE.getLabelModelFacet() ? 1 : 0) != 0);
        IParser p = this.getParser(this.setup.genModel.a_cp_pmf);
        ParsersTest.assertNotNull((Object)p);
        ParsersTest.assertEquals((String)"MyCustomParser", (String)p.getClass().getSimpleName());
        String s = p.getPrintString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertNotNull((Object)s);
        ParsersTest.assertEquals((String)p.getClass().getName(), (String)s);
    }

    public void testCustomParserFeatureLabelModelFacet() throws Exception {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createURI((String)"uri://org.eclipse.gmf/tests/parkins"));
        EObject nodkin = this.createNodkin();
        this.setAttribute(nodkin, "a1", "aaa");
        r.getContents().add((Object)nodkin);
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rs);
        ParsersTest.assertTrue((String)"sanity", (this.setup.genModel.a_cp_flmf.getModelFacet().eClass() == GMFGenPackage.eINSTANCE.getFeatureLabelModelFacet() ? 1 : 0) != 0);
        IParser p = this.getParser(this.setup.genModel.a_cp_flmf);
        ParsersTest.assertNotNull((Object)p);
        ParsersTest.assertEquals((String)"MyCustomParser", (String)p.getClass().getSimpleName());
        String s = p.getPrintString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertNotNull((Object)s);
        ParsersTest.assertEquals((String)p.getClass().getName(), (String)s);
    }

    public void testExternalParserWithHint() throws Exception {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createURI((String)"uri://org.eclipse.gmf/tests/parkins"));
        EObject nodkin = this.createNodkin();
        r.getContents().add((Object)nodkin);
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rs);
        Class epc = this.setup.project.getBundle().loadClass(this.setup.genModel.a_extp.getEditPartQualifiedClassName());
        Node notationElement = NotationFactory.eINSTANCE.createNode();
        notationElement.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        notationElement.setElement((EObject)notationElement);
        Object epInstance = epc.getConstructor(View.class).newInstance(notationElement);
        IParser p = (IParser)epc.getMethod("getParser", new Class[0]).invoke(epInstance, new Object[0]);
        ParsersTest.assertNotNull((Object)p);
        ParsersTest.assertEquals((String)"org.eclipse.gmf.runtime.diagram.ui.providers.internal.parsers.DescriptionParser", (String)p.getClass().getName());
    }

    public void testExpressionLabelParser() throws Exception {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createURI((String)"uri://org.eclipse.gmf/tests/parkins"));
        EObject nodkin = this.createNodkin();
        this.setAttribute(nodkin, "a1", "aaa");
        this.setAttribute(nodkin, "a2", "");
        r.getContents().add((Object)nodkin);
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rs);
        ParsersTest.assertTrue((String)"sanity", (this.setup.genModel.a_expr.getModelFacet().eClass() == GMFGenPackage.eINSTANCE.getExpressionLabelModelFacet() ? 1 : 0) != 0);
        IParser p = this.getParser(this.setup.genModel.a_expr);
        ParsersTest.assertNotNull((Object)p);
        ParsersTest.assertEquals((String)"MyExpressionParser", (String)p.getClass().getSimpleName());
        String s = p.getPrintString((IAdaptable)new EObjectAdapter(nodkin), 0);
        ParsersTest.assertNotNull((Object)s);
        ParsersTest.assertEquals((String)"aaa ==> <none>", (String)s);
    }

    protected IParser getParser(GenNodeLabel label) throws Exception {
        GenEditorGenerator editorGen = this.setup.genModel.diagramkin.getEditorGen();
        String ppfqn = editorGen.getLabelParsers().getQualifiedClassName();
        Class ppc = this.setup.project.getBundle().loadClass(ppfqn);
        Node notationElement = NotationFactory.eINSTANCE.createNode();
        if (editorGen.getLabelParsers().isExtensibleViaService()) {
            IParserProvider pp = (IParserProvider)ppc.newInstance();
            ParserHintAdapter param = new ParserHintAdapter((EObject)notationElement, String.valueOf(label.getVisualID()));
            return pp.getParser((IAdaptable)param);
        }
        Object ppInstance = ppc.newInstance();
        ParsersTest.assertFalse((boolean)(ppInstance instanceof IParserProvider));
        Method parserAccess = ppc.getMethod("get" + label.getUniqueIdentifier() + "Parser", new Class[0]);
        ParsersTest.assertNotNull((Object)parserAccess);
        return (IParser)parserAccess.invoke(ppInstance, new Object[0]);
    }

    protected EObject createNodkin() throws Exception {
        GenEditorGenerator g = this.setup.genModel.diagramkin.getEditorGen();
        String id = g.getDomainGenModel().getModelPluginID();
        Bundle b = Platform.getBundle((String)id);
        String mfqn = ((GenPackage)g.getDomainGenModel().getGenPackages().get(0)).getQualifiedFactoryClassName();
        Class modelFactoryClass = b.loadClass(mfqn);
        EFactory f = (EFactory)modelFactoryClass.newInstance();
        return f.create(this.setup.domainModel.nodkin);
    }

    protected Object getAttribute(EObject obj, String name) {
        for (EAttribute a : obj.eClass().getEAllAttributes()) {
            if (!a.getName().equals(name)) continue;
            return obj.eGet((EStructuralFeature)a);
        }
        throw new IllegalArgumentException(name);
    }

    protected void setAttribute(EObject obj, String name, Object value) {
        for (EAttribute a : obj.eClass().getEAllAttributes()) {
            if (!a.getName().equals(name)) continue;
            obj.eSet((EStructuralFeature)a, value);
            return;
        }
        throw new IllegalArgumentException(name);
    }

    public static class ParsersDomainModel {
        public EPackage p = EcoreFactory.eINSTANCE.createEPackage();
        public EClass kanvaskin;
        public EClass nodkin;
        public EReference refkin;
        public EAttribute a1;
        public EAttribute a2;
        public EAttribute a3;

        public ParsersDomainModel() {
            this.p.setName("parkin");
            this.p.setNsPrefix("parkin");
            this.p.setNsURI("uri://eclipse/gmf/tests/parkin/" + System.currentTimeMillis() + '/');
            new ResourceImpl(URI.createURI((String)"uri://org.eclipse.gmf/tests/parkind")).getContents().add((Object)this.p);
            this.kanvaskin = EcoreFactory.eINSTANCE.createEClass();
            this.kanvaskin.setName("Kanvaskin");
            this.p.getEClassifiers().add((Object)this.kanvaskin);
            this.nodkin = EcoreFactory.eINSTANCE.createEClass();
            this.nodkin.setName("Nodkin");
            this.p.getEClassifiers().add((Object)this.nodkin);
            this.refkin = EcoreFactory.eINSTANCE.createEReference();
            this.refkin.setContainment(true);
            this.refkin.setName("refkin");
            this.refkin.setEType((EClassifier)this.nodkin);
            this.kanvaskin.getEStructuralFeatures().add((Object)this.refkin);
            this.a1 = EcoreFactory.eINSTANCE.createEAttribute();
            this.a1.setName("a1");
            this.a1.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
            this.nodkin.getEStructuralFeatures().add((Object)this.a1);
            this.a2 = EcoreFactory.eINSTANCE.createEAttribute();
            this.a2.setName("a2");
            this.a2.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
            this.nodkin.getEStructuralFeatures().add((Object)this.a2);
            this.a3 = EcoreFactory.eINSTANCE.createEAttribute();
            this.a3.setName("a3");
            this.a3.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
            this.nodkin.getEStructuralFeatures().add((Object)this.a3);
        }
    }

    public static class ParsersGenModel {
        private int vid = 100;
        public GenDiagram diagramkin;
        public GenTopLevelNode nodkin;
        public GenNodeLabel a1;
        public GenNodeLabel a123;
        public GenNodeLabel ac132;
        public GenNodeLabel a12e31;
        public GenNodeLabel an2;
        public GenNodeLabel apr23;
        public GenNodeLabel a_cp_pmf;
        public GenNodeLabel a_cp_flmf;
        public GenNodeLabel a_extp;
        public GenNodeLabel a_expr;

        public ParsersGenModel(ParsersDomainModel domainModel) {
            GenModel runtimeModel = this.getRuntimeGenModel();
            assert (runtimeModel != null);
            GenModelMatcher gmm = new GenModelMatcher(Utils.createGenModel(domainModel.p));
            this.diagramkin = GMFGenFactory.eINSTANCE.createGenDiagram();
            GenEditorGenerator genBurden = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
            this.diagramkin.setDomainDiagramElement(gmm.findGenClass(domainModel.kanvaskin));
            genBurden.setDomainGenModel(this.diagramkin.getDomainDiagramElement().getGenModel());
            genBurden.setEditor(GMFGenFactory.eINSTANCE.createGenEditorView());
            this.diagramkin.setDiagramRunTimeClass(Utils.findGenClass(runtimeModel, NotationPackage.eINSTANCE.getDiagram()));
            this.diagramkin.setViewmap(ParsersGenModel.createDiagramViewmap());
            this.diagramkin.setVisualID(this.nextVID());
            MetamodelType dgmmType = GMFGenFactory.eINSTANCE.createMetamodelType();
            this.diagramkin.setElementType((ElementType)dgmmType);
            genBurden.setDiagram(this.diagramkin);
            genBurden.setPlugin(GMFGenFactory.eINSTANCE.createGenPlugin());
            genBurden.setDiagramUpdater(GMFGenFactory.eINSTANCE.createGenDiagramUpdater());
            genBurden.setLabelParsers(GMFGenFactory.eINSTANCE.createGenParsers());
            genBurden.setExpressionProviders(GMFGenFactory.eINSTANCE.createGenExpressionProviderContainer());
            new ResourceImpl(URI.createURI((String)"uri://org.eclipse.gmf/tests/parking")).getContents().add((Object)genBurden);
            this.nodkin = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
            this.nodkin.setDiagramRunTimeClass(Utils.findGenClass(runtimeModel, NotationPackage.eINSTANCE.getNode()));
            TypeModelFacet mf = GMFGenFactory.eINSTANCE.createTypeModelFacet();
            mf.setMetaClass(gmm.findGenClass(domainModel.nodkin));
            mf.setContainmentMetaFeature(gmm.findGenFeature((EStructuralFeature)domainModel.refkin));
            mf.setChildMetaFeature(mf.getContainmentMetaFeature());
            this.nodkin.setModelFacet(mf);
            this.nodkin.setElementType((ElementType)GMFGenFactory.eINSTANCE.createMetamodelType());
            this.nodkin.setViewmap(ParsersGenModel.createNodeViewmap());
            this.nodkin.setVisualID(this.nextVID());
            this.diagramkin.getTopLevelNodes().add((Object)this.nodkin);
            PredefinedParser messageFormatParser = GMFGenFactory.eINSTANCE.createPredefinedParser();
            PredefinedParser nativeParser = GMFGenFactory.eINSTANCE.createPredefinedParser();
            nativeParser.setViewMethod(LabelTextAccessMethod.NATIVE);
            nativeParser.setEditMethod(LabelTextAccessMethod.NATIVE);
            PredefinedParser printfRegexParser = GMFGenFactory.eINSTANCE.createPredefinedParser();
            printfRegexParser.setViewMethod(LabelTextAccessMethod.PRINTF);
            printfRegexParser.setEditMethod(LabelTextAccessMethod.REGEXP);
            CustomParser customParser = GMFGenFactory.eINSTANCE.createCustomParser();
            customParser.setQualifiedName(String.valueOf(this.diagramkin.getEditPartsPackageName()) + ".MyCustomParser");
            ExternalParser externalParser = GMFGenFactory.eINSTANCE.createExternalParser();
            externalParser.setHint("\"Description\"");
            ExpressionLabelParser expressionParser = GMFGenFactory.eINSTANCE.createExpressionLabelParser();
            expressionParser.setExpressionContext(this.nodkin.getDomainMetaClass());
            GenJavaExpressionProvider javaProvider = GMFGenFactory.eINSTANCE.createGenJavaExpressionProvider();
            GenExpressionInterpreter oclProvider = GMFGenFactory.eINSTANCE.createGenExpressionInterpreter();
            oclProvider.setLanguage(GenLanguage.OCL_LITERAL);
            GenLiteralExpressionProvider asisProvider = GMFGenFactory.eINSTANCE.createGenLiteralExpressionProvider();
            genBurden.getExpressionProviders().getProviders().add((Object)javaProvider);
            genBurden.getExpressionProviders().getProviders().add((Object)oclProvider);
            genBurden.getExpressionProviders().getProviders().add((Object)asisProvider);
            ValueExpression v1 = GMFGenFactory.eINSTANCE.createValueExpression();
            v1.setBody("self.a1.concat(' ==> ').concat(if self.a2.size() > 0 then self.a2 else '<none>' endif)");
            oclProvider.getExpressions().add((Object)v1);
            expressionParser.setViewExpression(v1);
            ValueExpression v2 = GMFGenFactory.eINSTANCE.createValueExpression();
            v2.setBody("\"[enter new value here]\"");
            asisProvider.getExpressions().add((Object)v2);
            expressionParser.setEditExpression(v2);
            GenConstraint v3 = GMFGenFactory.eINSTANCE.createGenConstraint();
            v3.setBody("return Boolean.valueOf(self.length() > 2);");
            javaProvider.getExpressions().add((Object)v3);
            javaProvider.setInjectExpressionBody(true);
            expressionParser.setValidateExpression(v3);
            expressionParser.setClassName("MyExpressionParser");
            genBurden.getLabelParsers().getImplementations().add((Object)messageFormatParser);
            genBurden.getLabelParsers().getImplementations().add((Object)nativeParser);
            genBurden.getLabelParsers().getImplementations().add((Object)printfRegexParser);
            genBurden.getLabelParsers().getImplementations().add((Object)customParser);
            genBurden.getLabelParsers().getImplementations().add((Object)externalParser);
            genBurden.getLabelParsers().getImplementations().add((Object)expressionParser);
            this.a1 = this.addAttr(gmm, domainModel.a1);
            FeatureLabelModelFacet mf2 = (FeatureLabelModelFacet)this.a1.getModelFacet();
            mf2.setParser((GenParserImplementation)messageFormatParser);
            this.a123 = this.addAttr(gmm, domainModel.a1, domainModel.a2, domainModel.a3);
            mf2 = (FeatureLabelModelFacet)this.a123.getModelFacet();
            mf2.setParser((GenParserImplementation)messageFormatParser);
            this.ac132 = this.addAttr(gmm, domainModel.a1, domainModel.a3, domainModel.a2);
            mf2 = (FeatureLabelModelFacet)this.ac132.getModelFacet();
            mf2.setViewPattern("{2} x {1} ({0})");
            mf2.setEditPattern("[{1}] - {0}, {2}");
            mf2.setEditorPattern("{2}/{1}/{0}");
            mf2.setParser((GenParserImplementation)messageFormatParser);
            this.a12e31 = this.addAttr(gmm, domainModel.a1, domainModel.a2);
            mf2 = (FeatureLabelModelFacet)this.a12e31.getModelFacet();
            mf2.setViewPattern("{0}*{1}");
            mf2.getEditableMetaFeatures().add((Object)gmm.findGenFeature((EStructuralFeature)domainModel.a3));
            mf2.getEditableMetaFeatures().add((Object)gmm.findGenFeature((EStructuralFeature)domainModel.a1));
            mf2.setEditPattern("{0}:{1}");
            mf2.setEditorPattern("<{1}>{0}");
            mf2.setParser((GenParserImplementation)messageFormatParser);
            this.an2 = this.addAttr(gmm, domainModel.a2);
            this.an2.getModelFacet().setParser((GenParserImplementation)nativeParser);
            this.apr23 = this.addAttr(gmm, domainModel.a2, domainModel.a3);
            this.apr23.getModelFacet().setParser((GenParserImplementation)printfRegexParser);
            this.a_cp_pmf = this.addAttr(gmm, new EAttribute[0]);
            this.a_cp_pmf.setModelFacet(GMFGenFactory.eINSTANCE.createLabelModelFacet());
            this.a_cp_pmf.getModelFacet().setParser((GenParserImplementation)customParser);
            this.a_cp_flmf = this.addAttr(gmm, domainModel.a1);
            this.a_cp_flmf.setEditPartClassName("AttrWithCustomParserEditPart");
            this.a_cp_flmf.getModelFacet().setParser((GenParserImplementation)customParser);
            this.a_extp = this.addAttr(gmm, new EAttribute[0]);
            this.a_extp.setEditPartClassName("LabelWithExternalParserEditPart");
            this.a_extp.setModelFacet(GMFGenFactory.eINSTANCE.createLabelModelFacet());
            this.a_extp.getModelFacet().setParser((GenParserImplementation)externalParser);
            this.a_expr = this.addAttr(gmm, new EAttribute[0]);
            this.a_expr.setEditPartClassName("LabelWithExpressionParserEditPart");
            this.a_expr.setModelFacet((LabelModelFacet)GMFGenFactory.eINSTANCE.createExpressionLabelModelFacet());
            this.a_expr.getModelFacet().setParser((GenParserImplementation)expressionParser);
        }

        private int nextVID() {
            return this.vid++;
        }

        protected GenNodeLabel addAttr(GenModelMatcher gmm, EAttribute ... aa) {
            FeatureLabelModelFacet modelFacet = GMFGenFactory.eINSTANCE.createFeatureLabelModelFacet();
            EAttribute[] eAttributeArray = aa;
            int n = aa.length;
            int n2 = 0;
            while (n2 < n) {
                EAttribute a = eAttributeArray[n2];
                modelFacet.getMetaFeatures().add((Object)gmm.findGenFeature((EStructuralFeature)a));
                ++n2;
            }
            GenNodeLabel label = GMFGenFactory.eINSTANCE.createGenNodeLabel();
            label.setModelFacet((LabelModelFacet)modelFacet);
            label.setVisualID(this.nextVID());
            label.setViewmap(ParsersGenModel.createLabelViewmap());
            label.setDiagramRunTimeClass(this.nodkin.getDiagramRunTimeClass());
            this.nodkin.getLabels().add((Object)label);
            return label;
        }

        private GenModel getRuntimeGenModel() {
            RuntimeGenModelAccess runtimeAccess = new RuntimeGenModelAccess();
            runtimeAccess.ensure();
            return runtimeAccess.model();
        }

        private static Viewmap createDiagramViewmap() {
            FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
            v.setFigureQualifiedClassName("org.eclipse.draw2d.FreeformLayer");
            return v;
        }

        private static Viewmap createNodeViewmap() {
            FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
            v.setFigureQualifiedClassName("org.eclipse.draw2d.RoundedRectangle");
            return v;
        }

        private static Viewmap createLabelViewmap() {
            FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
            v.setFigureQualifiedClassName("org.eclipse.draw2d.Label");
            return v;
        }
    }

    public static class ParsersSetup
    implements TestConfiguration {
        public ParsersDomainModel domainModel = new ParsersDomainModel();
        public ParsersGenModel genModel = new ParsersGenModel(this.domainModel);
        public GenProjectSetup project;
        private int uses = 0;

        public ParsersSetup(boolean parsersAsProvider) {
            GenEditorGenerator editorGen = this.genModel.diagramkin.getEditorGen();
            editorGen.getLabelParsers().setExtensibleViaService(parsersAsProvider);
            String pid = editorGen.getPlugin().getID();
            editorGen.getPlugin().setID(String.valueOf(pid) + (parsersAsProvider ? ".provider" : ".direct"));
        }

        public void init() throws Exception {
            ++this.uses;
            if (this.project == null) {
                this.project = new GenProjectSetup(new RuntimeBasedGeneratorConfiguration()){

                    protected void hookExtraCodeGeneration(GenEditorGenerator genEditor, IProject project) throws Exception {
                        String pkgName = genEditor.getDiagram().getEditPartsPackageName();
                        String className = "MyCustomParser";
                        IFolder f = (IFolder)project.findMember(new Path("src").append(pkgName.replace('.', '/')));
                        ParsersTest.assertNotNull((Object)f);
                        String x = "package " + pkgName + ";\n" + "import org.eclipse.core.runtime.IAdaptable;\n" + "import org.eclipse.gmf.runtime.common.core.command.ICommand;\n" + "import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;\n" + "import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;\n" + "import org.eclipse.jface.text.contentassist.IContentAssistProcessor;\n" + "\n" + "public class " + className + " implements IParser {\n" + "public IContentAssistProcessor getCompletionProcessor(IAdaptable element) { return null; }\n" + "public String getEditString(IAdaptable element, int flags) { return null; }\n" + "public ICommand getParseCommand(IAdaptable element, String newString, int flags) { return null; }\n" + "public String getPrintString(IAdaptable element, int flags) { return MyCustomParser.class.getName(); }\n" + "public boolean isAffectingEvent(Object event, int flags) { return false; }\n" + "public IParserEditStatus isValidEditString(IAdaptable element, String editString) { return null; }}";
                        f.getFile(String.valueOf(className) + ".java").create((InputStream)new ByteArrayInputStream(x.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }.init(this.genModel.diagramkin.getEditorGen());
            }
        }

        public void dispose() throws Exception {
            assert (this.uses > 0);
            --this.uses;
            if (this.uses == 0 && this.project != null) {
                this.project.uninstall();
            }
        }
    }
}

