/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.dialogs;

import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;

class StringValidator {
    StringValidator() {
    }

    public static boolean isValid(String input) {
        return StringValidator.isNotEmpty(input) && StringValidator.isDouble(input) && StringValidator.isPositive(input);
    }

    private static boolean isNotEmpty(String input) {
        return input.length() > 0;
    }

    private static boolean isDouble(String input) {
        char[] tokens = input.toCharArray();
        if (!Character.isDigit(tokens[0])) {
            return false;
        }
        try {
            NumberFormat.getNumberInstance().parse(input);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    private static boolean isPositive(String input) {
        if (StringValidator.isDouble(input)) {
            try {
                Number n = NumberFormat.getNumberInstance().parse(input);
                if (n.doubleValue() >= 0.0) {
                    return true;
                }
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return false;
    }
}

