/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.action;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.LabelRetargetAction;

public class ActionMenuManager
extends MenuManager {
    protected final MenuCreatorAction action;
    protected IAction defaultAction = null;
    private final ActionContributionItem actionContributionItem;
    private boolean retargetLastAction;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.action.ActionMenuManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ActionMenuManager(String id, IAction actionHandler) {
        this(id, actionHandler, false);
    }

    public ActionMenuManager(String id, IAction actionHandler, boolean retargetLastAction) {
        super(actionHandler.getText(), id);
        if (!$assertionsDisabled && actionHandler == null) {
            throw new AssertionError();
        }
        this.action = new MenuCreatorAction(actionHandler);
        this.defaultAction = actionHandler;
        this.actionContributionItem = new ActionContributionItem((IAction)this.action);
        this.retargetLastAction = retargetLastAction;
    }

    protected boolean isRetargetLastAction() {
        return this.retargetLastAction;
    }

    protected void subActionSelected(IAction subActionHandler) {
    }

    public void fill(Composite parent) {
        this.retargetLastAction = false;
        this.actionContributionItem.fill(parent);
    }

    public void fill(Menu parent, int index) {
        this.retargetLastAction = false;
        this.actionContributionItem.fill(parent, index);
    }

    public void fill(ToolBar parent, int index) {
        this.actionContributionItem.fill(parent, index);
    }

    public void dispose() {
        this.actionContributionItem.dispose();
        super.dispose();
    }

    public boolean isEnabled() {
        return this.actionContributionItem.isEnabled();
    }

    public boolean isDirty() {
        return this.actionContributionItem.isDirty();
    }

    public boolean isDynamic() {
        return this.actionContributionItem.isDynamic();
    }

    public boolean isGroupMarker() {
        return this.actionContributionItem.isGroupMarker();
    }

    public boolean isSeparator() {
        return this.actionContributionItem.isSeparator();
    }

    public boolean isVisible() {
        return this.actionContributionItem.isVisible();
    }

    public void setParent(IContributionManager parent) {
        this.actionContributionItem.setParent(parent);
    }

    public void setVisible(boolean visible) {
        this.actionContributionItem.setVisible(visible);
    }

    public void update() {
        this.actionContributionItem.update();
    }

    public void update(String id) {
        this.actionContributionItem.update(id);
    }

    public void updateAll(boolean force) {
        this.update(force);
        IContributionItem[] items = this.getRealItems();
        int i = 0;
        while (i < items.length) {
            IMenuManager mm;
            IContributionItem ci = items[i];
            if (ci instanceof IMenuManager && (mm = (IMenuManager)ci).isVisible()) {
                mm.updateAll(force);
            }
            ++i;
        }
    }

    public void update(boolean force) {
        this.update();
    }

    protected void itemAdded(IContributionItem item) {
        super.itemAdded(item);
        if (item instanceof SubContributionItem) {
            item = ((SubContributionItem)item).getInnerItem();
        }
        if (!item.isGroupMarker()) {
            this.action.setEnabled(true);
        }
    }

    protected void itemRemoved(IContributionItem item) {
        super.itemRemoved(item);
        if (item instanceof SubContributionItem) {
            item = ((SubContributionItem)item).getInnerItem();
        }
        if (!item.isGroupMarker()) {
            this.action.setEnabled(false);
            IContributionItem[] items = this.getItems();
            int i = 0;
            while (i < items.length) {
                if (!items[i].isGroupMarker()) {
                    this.action.setEnabled(true);
                    break;
                }
                ++i;
            }
        }
    }

    protected IContributionItem[] getRealItems() {
        IContributionItem[] items = this.getItems();
        IContributionItem[] realItems = new IContributionItem[items.length];
        int i = 0;
        while (i < items.length) {
            realItems[i] = items[i] instanceof SubContributionItem ? ((SubContributionItem)items[i]).getInnerItem() : items[i];
            ++i;
        }
        return realItems;
    }

    public IAction getDefaultAction() {
        return this.defaultAction;
    }

    protected void setDefaultAction(IAction defaultAction) {
        this.defaultAction = defaultAction;
    }

    static /* synthetic */ boolean access$0(ActionMenuManager actionMenuManager) {
        return actionMenuManager.retargetLastAction;
    }

    public class MenuCreatorAction
    extends LabelRetargetAction
    implements IMenuCreator {
        private Menu menu;
        private Listener menuItemListener;

        public MenuCreatorAction(IAction actionHandler) {
            super(actionHandler.getId(), actionHandler.getText());
            this.menuItemListener = new Listener(this){
                final /* synthetic */ MenuCreatorAction this$1;
                {
                    this.this$1 = menuCreatorAction;
                }

                public void handleEvent(Event event) {
                    if (13 == event.type && !event.widget.isDisposed()) {
                        ActionContributionItem item = (ActionContributionItem)event.widget.getData();
                        if (ActionMenuManager.access$0(MenuCreatorAction.access$0(this.this$1))) {
                            this.this$1.setActionHandler(item.getAction());
                            MenuCreatorAction.access$0(this.this$1).setDefaultAction(item.getAction());
                        }
                        MenuCreatorAction.access$0(this.this$1).subActionSelected(item.getAction());
                    }
                }
            };
            this.setEnabled(false);
            this.setActionHandler(actionHandler);
            this.setMenuCreator(this);
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            return this.createMenu(this.menu);
        }

        public Menu getMenu(Menu parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            return this.createMenu(this.menu);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
            super.dispose();
            ActionMenuManager.this.dispose();
        }

        protected Menu createMenu(Menu mnu) {
            IContributionItem[] items = ActionMenuManager.this.getRealItems();
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                if (!(item instanceof AbstractGroupMarker) || i != 0 && i != items.length - 1 && !(items[i + 1] instanceof AbstractGroupMarker) && mnu.getItemCount() >= 1) {
                    try {
                        item.fill(this.menu, -1);
                    }
                    catch (Exception exception) {
                        Log.info((Plugin)CommonUIPlugin.getDefault(), (int)6, (String)("The contribution item (" + item.getId() + ") failed to fill within the menu"));
                    }
                }
                ++i;
            }
            MenuItem[] menuItems = mnu.getItems();
            int i2 = 0;
            while (i2 < menuItems.length) {
                if (menuItems[i2].getStyle() != 2) {
                    menuItems[i2].addListener(13, this.menuItemListener);
                }
                ++i2;
            }
            return mnu;
        }

        protected void propagateChange(PropertyChangeEvent event) {
            if (!event.getProperty().equals("enabled")) {
                super.propagateChange(event);
            }
        }

        protected void setActionHandler(IAction handler) {
            boolean enabled = this.isEnabled();
            super.setActionHandler(handler);
            this.setEnabled(enabled);
        }

        public void run() {
            if (this.getActionHandler() != null && this.getActionHandler().isEnabled()) {
                super.run();
            } else if (ActionMenuManager.this.getDefaultAction().isEnabled()) {
                this.setActionHandler(ActionMenuManager.this.getDefaultAction());
                super.run();
            }
        }

        public void runWithEvent(Event event) {
            if (this.getActionHandler() != null && this.getActionHandler().isEnabled()) {
                super.runWithEvent(event);
            } else if (ActionMenuManager.this.getDefaultAction().isEnabled()) {
                this.setActionHandler(ActionMenuManager.this.getDefaultAction());
                super.runWithEvent(event);
            }
        }

        static /* synthetic */ ActionMenuManager access$0(MenuCreatorAction menuCreatorAction) {
            return menuCreatorAction.ActionMenuManager.this;
        }
    }
}

