/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.mappings;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class Language
extends AbstractEnumerator {
    public static final int OCL = 0;
    public static final int JAVA = 1;
    public static final int REGEXP = 2;
    public static final int NREGEXP = 3;
    public static final Language OCL_LITERAL = new Language(0, "ocl", "ocl");
    public static final Language JAVA_LITERAL = new Language(1, "java", "java");
    public static final Language REGEXP_LITERAL = new Language(2, "regexp", "regexp");
    public static final Language NREGEXP_LITERAL = new Language(3, "nregexp", "nregexp");
    private static final Language[] VALUES_ARRAY = new Language[]{OCL_LITERAL, JAVA_LITERAL, REGEXP_LITERAL, NREGEXP_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static Language get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Language result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Language getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Language result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Language get(int value) {
        switch (value) {
            case 0: {
                return OCL_LITERAL;
            }
            case 1: {
                return JAVA_LITERAL;
            }
            case 2: {
                return REGEXP_LITERAL;
            }
            case 3: {
                return NREGEXP_LITERAL;
            }
        }
        return null;
    }

    private Language(int value, String name, String literal) {
        super(value, name, literal);
    }
}

