/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.gmf.codegen.gmfgen.Palette;
import org.eclipse.gmf.codegen.gmfgen.Separator;
import org.eclipse.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.gmf.codegen.gmfgen.ToolGroupItem;
import org.eclipse.gmf.internal.bridge.genmodel.BasicDiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.MapSetup;
import org.eclipse.gmf.tests.setup.ToolDefSetup;
import org.eclipse.gmf.tests.tr.GenModelTransformerTest;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooldef.GMFToolFactory;
import org.eclipse.gmf.tooldef.GenericTool;
import org.eclipse.gmf.tooldef.ToolGroup;

public class PaletteTransformationTest
extends GenModelTransformerTest {
    private static final int TOOLS_FOR_CHECK = 5;
    private static final int SEP_2_POS = 4;
    private static final int SEP_1_POS = 2;
    private AbstractTool myTool2Reuse;
    private GenericTool myToolWithClass;
    private CreationTool myToolFromWrongPalette;
    private ToolGroup myGroupWithWrongTool;
    private ToolGroup myGroupWithOrderAndSeparators;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gmf.tests.tr.PaletteTransformationTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PaletteTransformationTest(String name) {
        super(name);
    }

    protected MapDefSource initMapModel(DiaDefSource graphDef) {
        ToolDefSetup toolDefSetup = new ToolDefSetup();
        this.myTool2Reuse = toolDefSetup.getNodeCreationTool();
        this.myTool2Reuse.setTitle("NodeTool");
        MapSetup init = new MapSetup().init(graphDef, this.getSetup().getDomainModel(), toolDefSetup);
        init.getNodeA().setTool(this.myTool2Reuse);
        init.getNodeB().setTool(this.myTool2Reuse);
        this.myToolWithClass = GMFToolFactory.eINSTANCE.createGenericTool();
        this.myToolWithClass.setTitle("ToolWithClass");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.myToolWithClass.setToolClass((Class)clazz);
        init.getMapping().getDiagram().getPalette().getTools().add((Object)this.myToolWithClass);
        this.myToolFromWrongPalette = GMFToolFactory.eINSTANCE.createCreationTool();
        this.myToolFromWrongPalette.setTitle("ToolFromWrongPalette");
        this.myGroupWithWrongTool = GMFToolFactory.eINSTANCE.createToolGroup();
        this.myGroupWithWrongTool.setTitle("GroupWithWrongTool");
        this.myGroupWithWrongTool.getTools().add((Object)this.myToolFromWrongPalette);
        init.getClassLink().setTool((AbstractTool)this.myToolFromWrongPalette);
        this.myGroupWithOrderAndSeparators = GMFToolFactory.eINSTANCE.createToolGroup();
        this.myGroupWithOrderAndSeparators.setTitle("GroupWithOrderAndSeparators");
        this.myGroupWithOrderAndSeparators.getTools().addAll((Collection)PaletteTransformationTest.createToolsForOrderCheck(5));
        this.myGroupWithOrderAndSeparators.getTools().add(2, (Object)GMFToolFactory.eINSTANCE.createPaletteSeparator());
        this.myGroupWithOrderAndSeparators.getTools().add(4, (Object)GMFToolFactory.eINSTANCE.createPaletteSeparator());
        toolDefSetup.getPalette().getTools().add((Object)this.myGroupWithOrderAndSeparators);
        return init;
    }

    private static List createToolsForOrderCheck(int numOfTools) {
        if (!$assertionsDisabled && numOfTools <= 0) {
            throw new AssertionError();
        }
        ArrayList<GenericTool> rv = new ArrayList<GenericTool>(numOfTools);
        int i = 0;
        while (i < numOfTools) {
            GenericTool t = GMFToolFactory.eINSTANCE.createGenericTool();
            t.setTitle("ToolOrder" + i);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            t.setToolClass((Class)clazz);
            rv.add(t);
            ++i;
        }
        return rv;
    }

    public void testToolEntryReuse() {
        ToolEntry te = this.findToolEntry(this.myTool2Reuse);
        PaletteTransformationTest.assertNotNull((Object)te);
        PaletteTransformationTest.assertEquals((int)2, (int)te.getGenNodes().size());
        PaletteTransformationTest.assertEquals((int)2, (int)te.getElements().size());
        PaletteTransformationTest.assertEquals((int)0, (int)te.getGenLinks().size());
        PaletteTransformationTest.assertEquals((String)"Node[A|B] should share same ToolEntry", (int)1, (int)this.countToolEntriesWithName(this.myTool2Reuse.getTitle()));
    }

    public void testUseNonReferencedTool() {
        ToolEntry te = this.findToolEntry((AbstractTool)this.myToolWithClass);
        PaletteTransformationTest.assertNotNull((String)"Present", (Object)te);
        PaletteTransformationTest.assertEquals((String)"... and only once", (int)1, (int)this.countToolEntriesWithName(this.myToolWithClass.getTitle()));
        PaletteTransformationTest.assertEquals((int)0, (int)te.getGenNodes().size());
        PaletteTransformationTest.assertEquals((int)0, (int)te.getElements().size());
        PaletteTransformationTest.assertEquals((int)0, (int)te.getGenLinks().size());
    }

    public void testUseToolWithClass() {
        ToolEntry te = this.findToolEntry((AbstractTool)this.myToolWithClass);
        PaletteTransformationTest.assertNotNull((String)"Present", (Object)te);
        PaletteTransformationTest.assertNotNull((Object)te.getQualifiedToolName());
        PaletteTransformationTest.assertEquals((String)this.myToolWithClass.getToolClass().getName(), (String)te.getQualifiedToolName());
    }

    public void testTopLevelToolDefMovedToDefaultGroup() {
        ToolEntry te = this.findToolEntry((AbstractTool)this.myToolWithClass);
        PaletteTransformationTest.assertNotNull((String)"Present", (Object)te);
        PaletteTransformationTest.assertFalse((String)"not in palette...", (boolean)(te.eContainer() instanceof Palette));
        PaletteTransformationTest.assertTrue((String)"... rather in some group ...", (boolean)(te.eContainer() instanceof org.eclipse.gmf.codegen.gmfgen.ToolGroup));
        org.eclipse.gmf.codegen.gmfgen.ToolGroup group = (org.eclipse.gmf.codegen.gmfgen.ToolGroup)te.eContainer();
        PaletteTransformationTest.assertTrue((String)"... which in turn is child of palette", (boolean)(group.eContainer() instanceof Palette));
    }

    public void testReferenceToolFromWrongPalette() {
        ToolEntry te = this.findToolEntry((AbstractTool)this.myToolFromWrongPalette);
        PaletteTransformationTest.assertNotNull((String)"Present", (Object)te);
        PaletteTransformationTest.assertEquals((String)"... and only once", (int)1, (int)this.countToolEntriesWithName(this.myToolFromWrongPalette.getTitle()));
        PaletteTransformationTest.assertTrue((String)"There's some group for mis-referenced tools...", (boolean)(te.eContainer() instanceof org.eclipse.gmf.codegen.gmfgen.ToolGroup));
        org.eclipse.gmf.codegen.gmfgen.ToolGroup group = (org.eclipse.gmf.codegen.gmfgen.ToolGroup)te.eContainer();
        if (!$assertionsDisabled && !this.myGroupWithWrongTool.getTools().contains((Object)this.myToolFromWrongPalette)) {
            throw new AssertionError((Object)"just make sure we didn't forget to add one to another");
        }
        PaletteTransformationTest.assertNotSame((String)"But it's not the transformation of the original owner", (Object)this.myGroupWithWrongTool.getTitle(), (Object)group.getTitle());
    }

    /*
     * Unable to fully structure code
     */
    public void testOrderPreserved() {
        transformed = this.findTransformedGroup(this.myGroupWithOrderAndSeparators);
        PaletteTransformationTest.assertNotNull((Object)transformed);
        itTransformed = transformed.getEntries().iterator();
        toolsCompared = 0;
        itOriginal = this.myGroupWithOrderAndSeparators.getTools().iterator();
        block0: while (itOriginal.hasNext()) {
            next = null;
            do {
                if (!((o = itOriginal.next()) instanceof GenericTool)) continue;
                next = (GenericTool)o;
            } while (next == null && itOriginal.hasNext());
            if (next != null || itOriginal.hasNext()) ** GOTO lbl19
            break;
lbl-1000:
            // 1 sources

            {
                o = itTransformed.next();
                if (!(o instanceof ToolEntry)) continue;
                PaletteTransformationTest.assertEquals((String)next.getTitle(), (String)((ToolEntry)o).getTitle());
                ++toolsCompared;
                continue block0;
lbl19:
                // 2 sources

                ** while (itTransformed.hasNext())
            }
lbl20:
            // 1 sources

        }
        PaletteTransformationTest.assertEquals((int)5, (int)toolsCompared);
    }

    public void testSeparators() {
        org.eclipse.gmf.codegen.gmfgen.ToolGroup transformed = this.findTransformedGroup(this.myGroupWithOrderAndSeparators);
        PaletteTransformationTest.assertNotNull((Object)transformed);
        ToolGroupItem item = (ToolGroupItem)transformed.getEntries().get(2);
        PaletteTransformationTest.assertTrue((boolean)(item instanceof Separator));
        item = (ToolGroupItem)transformed.getEntries().get(4);
        PaletteTransformationTest.assertTrue((boolean)(item instanceof Separator));
    }

    private org.eclipse.gmf.codegen.gmfgen.ToolGroup findTransformedGroup(ToolGroup toolGroup) {
        org.eclipse.gmf.codegen.gmfgen.ToolGroup transformed = null;
        Iterator it = this.getResultPalette().getGroups().iterator();
        while (it.hasNext()) {
            org.eclipse.gmf.codegen.gmfgen.ToolGroup next = (org.eclipse.gmf.codegen.gmfgen.ToolGroup)it.next();
            if (!toolGroup.getTitle().equals(next.getTitle())) continue;
            transformed = next;
            break;
        }
        return transformed;
    }

    private ToolEntry findToolEntry(AbstractTool tool) {
        Palette palette = this.getResultPalette();
        TreeIterator it = palette.eAllContents();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof ToolEntry)) continue;
            ToolEntry toolEntry = (ToolEntry)next;
            if (!tool.getTitle().equals(toolEntry.getTitle())) continue;
            return toolEntry;
        }
        return null;
    }

    private Palette getResultPalette() {
        Palette palette = this.transformationResult.getDiagram().getPalette();
        return palette;
    }

    private int countToolEntriesWithName(String name) {
        int count = 0;
        Palette palette = this.getResultPalette();
        TreeIterator it = palette.eAllContents();
        while (it.hasNext()) {
            ToolEntry toolEntry;
            Object next = it.next();
            if (!(next instanceof ToolEntry) || !name.equals((toolEntry = (ToolEntry)next).getTitle())) continue;
            ++count;
        }
        return count;
    }

    protected DiagramRunTimeModelHelper getRTHelper() {
        return new BasicDiagramRunTimeModelHelper();
    }
}

