/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.type.baseimpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.expression.ExpressionFacade;

public class CollectionFeaturesTest
extends TestCase {
    ExecutionContextImpl ec;
    private ExpressionFacade ef;
    private ArrayList<String> vals;

    protected void setUp() throws Exception {
        this.vals = new ArrayList();
        this.vals.add("1");
        this.vals.add("2");
        this.vals.add("3");
        this.vals.add("4");
        this.vals.add("5");
        this.ec = new ExecutionContextImpl(null, new EPackage[0]);
        this.ef = new ExpressionFacade((ExecutionContext)this.ec);
    }

    public final void testSelect() {
        Collection result = (Collection)this.ef.evaluate("vals.select(s| s.compareTo(\"3\") >= 0)", Collections.singletonMap("vals", this.vals));
        CollectionFeaturesTest.assertEquals((int)3, (int)result.size());
        CollectionFeaturesTest.assertTrue((boolean)result.contains("3"));
        CollectionFeaturesTest.assertTrue((boolean)result.contains("4"));
        CollectionFeaturesTest.assertTrue((boolean)result.contains("5"));
    }

    public final void testCollect() {
        Collection result = (Collection)this.ef.evaluate("vals.collect( s| s.length())", Collections.singletonMap("vals", this.vals));
        CollectionFeaturesTest.assertEquals((int)5, (int)result.size());
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            CollectionFeaturesTest.assertEquals((Object)1, iter.next());
        }
    }

    public final void testExists() {
        CollectionFeaturesTest.assertEquals((Object)Boolean.TRUE, (Object)this.ef.evaluate("vals.exists(s| s == \"3\")", Collections.singletonMap("vals", this.vals)));
        CollectionFeaturesTest.assertEquals((Object)Boolean.FALSE, (Object)this.ef.evaluate("vals.exists(s| s == \"33\")", Collections.singletonMap("vals", this.vals)));
    }

    public final void testForAll() {
        CollectionFeaturesTest.assertEquals((Object)Boolean.TRUE, (Object)this.ef.evaluate("vals.forAll(s| s.length() == 1)", Collections.singletonMap("vals", this.vals)));
        CollectionFeaturesTest.assertEquals((Object)Boolean.FALSE, (Object)this.ef.evaluate("vals.forAll(s| s == \"3\")", Collections.singletonMap("vals", this.vals)));
    }
}

