/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.core.internal.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.gmf.runtime.common.core.util.HashUtil;

public class HashUtilTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)HashUtilTest.suite());
    }

    public static Test suite() {
        return new TestSuite(HashUtilTest.class);
    }

    public HashUtilTest(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void test_hash_boolean() {
        HashUtilTest.assertTrue((629 == HashUtil.hash((boolean)false) - 1 ? 1 : 0) != 0);
        HashUtilTest.assertTrue((37 == HashUtil.hash((int)1, (boolean)false) - 1 ? 1 : 0) != 0);
        HashUtilTest.assertTrue((629 == HashUtil.hash((boolean)true) - 0 ? 1 : 0) != 0);
        HashUtilTest.assertTrue((HashUtil.hash((int)0, (boolean)true) - 0 == 0 ? 1 : 0) != 0);
    }

    public void test_hash_byte() {
        HashUtilTest.assertTrue((629 == HashUtil.hash((byte)127) - 127 ? 1 : 0) != 0);
        HashUtilTest.assertTrue((-4736 == HashUtil.hash((int)-128, (byte)127) - 127 ? 1 : 0) != 0);
    }

    public void test_hash_char() {
        HashUtilTest.assertTrue((629 == HashUtil.hash((char)'\uffff') - 65535 ? 1 : 0) != 0);
        HashUtilTest.assertTrue((HashUtil.hash((int)0, (char)'\uffff') - 65535 == 0 ? 1 : 0) != 0);
    }

    public void test_hash_double() {
        HashUtilTest.assertTrue((629 == HashUtil.hash((long)Double.doubleToLongBits(Double.MAX_VALUE)) - (int)(Double.doubleToLongBits(Double.MAX_VALUE) ^ Double.doubleToLongBits(Double.MAX_VALUE) >>> 32) ? 1 : 0) != 0);
        HashUtilTest.assertTrue((37 * (int)(Double.doubleToLongBits(Double.MIN_VALUE) ^ Double.doubleToLongBits(Double.MIN_VALUE) >>> 32) == HashUtil.hash((int)((int)(Double.doubleToLongBits(Double.MIN_VALUE) ^ Double.doubleToLongBits(Double.MIN_VALUE) >>> 32)), (long)Double.doubleToLongBits(Double.MAX_VALUE)) - (int)(Double.doubleToLongBits(Double.MAX_VALUE) ^ Double.doubleToLongBits(Double.MAX_VALUE) >>> 32) ? 1 : 0) != 0);
    }

    public void test_hash_float() {
        HashUtilTest.assertTrue((629 == HashUtil.hash((float)Float.MAX_VALUE) - Float.floatToIntBits(Float.MAX_VALUE) ? 1 : 0) != 0);
        HashUtilTest.assertTrue((37 * Float.floatToIntBits(Float.MIN_VALUE) == HashUtil.hash((int)Float.floatToIntBits(Float.MIN_VALUE), (float)Float.MAX_VALUE) - Float.floatToIntBits(Float.MAX_VALUE) ? 1 : 0) != 0);
    }

    public void test_hash_int() {
        HashUtilTest.assertTrue((629 == HashUtil.hash((int)Integer.MAX_VALUE) - Integer.MAX_VALUE ? 1 : 0) != 0);
        HashUtilTest.assertTrue((Integer.MIN_VALUE == HashUtil.hash((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE) - Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    public void test_hash_long() {
        HashUtilTest.assertTrue((629 == HashUtil.hash((long)Long.MAX_VALUE) - Integer.MIN_VALUE ? 1 : 0) != 0);
        HashUtilTest.assertTrue((Integer.MIN_VALUE == HashUtil.hash((int)Integer.MIN_VALUE, (long)Long.MAX_VALUE) - Integer.MIN_VALUE ? 1 : 0) != 0);
    }

    public void test_hash_short() {
        HashUtilTest.assertTrue((629 == HashUtil.hash((short)Short.MAX_VALUE) - Short.MAX_VALUE ? 1 : 0) != 0);
        HashUtilTest.assertTrue((-1212416 == HashUtil.hash((int)Short.MIN_VALUE, (short)Short.MAX_VALUE) - Short.MAX_VALUE ? 1 : 0) != 0);
    }

    public void test_hash_Object() {
        HashUtilTest.assertTrue((629 == HashUtil.hash((Object)((Object)this)) - ((Object)((Object)this)).hashCode() ? 1 : 0) != 0);
        HashUtilTest.assertTrue((37 * ((Object)((Object)this)).hashCode() == HashUtil.hash((int)((Object)((Object)this)).hashCode(), (Object)((Object)this)) - ((Object)((Object)this)).hashCode() ? 1 : 0) != 0);
    }
}

