/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.XpandFacade;
import org.eclipse.gmf.internal.xpand.ast.Definition;
import org.eclipse.gmf.internal.xpand.ast.Template;
import org.eclipse.gmf.internal.xpand.ast.TextStatement;
import org.eclipse.gmf.internal.xpand.eval.EvaluationListener;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.Scope;
import org.eclipse.gmf.internal.xpand.model.Variable;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.tests.xpand.AbstractXpandTest;
import org.eclipse.gmf.tests.xpand.DumpEvaluationListener;
import org.eclipse.gmf.tests.xpand.TestsResourceManager;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;

public class StatementEvaluatorTest
extends AbstractXpandTest {
    private ExecutionContextImpl execCtx;
    private BufferOutput out;
    private StringBuilder buffer;

    protected void setUp() throws Exception {
        super.setUp();
        if (QvtPlugin.getDefault() == null) {
            new QvtPlugin();
        }
        this.buffer = new StringBuilder();
        this.out = new BufferOutput(this.buffer);
        this.execCtx = this.createCtx((Output)this.out);
    }

    private ExecutionContextImpl createCtx(Output out) {
        this.buffer.setLength(0);
        ExecutionContextImpl result = new ExecutionContextImpl(new Scope((ResourceManager)new TestsResourceManager(), null, out));
        result.getScope().setEvaluationListener((EvaluationListener)new DumpEvaluationListener());
        return result;
    }

    public final void testEvaluation() throws Exception {
        new XpandFacade((ExecutionContext)this.execCtx).evaluate("org::eclipse::gmf::tests::xpand::evaluate::EvaluateStart::start", (Object)"test", new Object[0]);
        System.out.println(this.buffer.toString());
    }

    public final void testIf() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("DEFINE test FOR ecore::EClass")) + this.tag("IF test=1") + "if" + this.tag("ELSEIF test=2") + "elseif" + this.tag("ELSE") + "else" + this.tag("ENDIF") + this.tag("ENDDEFINE"));
        StatementEvaluatorTest.assertEquals((int)1, (int)t.getDefinitions().length);
        XpandDefinition temlateWithIf = t.getDefinitions()[0];
        Variable self = new Variable("this", (EClassifier)EcorePackage.eINSTANCE.getEClass(), (Object)EcorePackage.eINSTANCE.getEAnnotation());
        ExecutionContext ctx = this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{self, new Variable("test", null, (Object)new Integer(1))});
        temlateWithIf.evaluate(ctx);
        StatementEvaluatorTest.assertEquals((String)"if", (String)this.buffer.toString().trim());
        temlateWithIf.evaluate(this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{self, new Variable("test", null, (Object)new Integer(2))}));
        StatementEvaluatorTest.assertEquals((String)"elseif", (String)this.buffer.toString().trim());
        temlateWithIf.evaluate(this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{self, new Variable("test", null, (Object)new Integer(3))}));
        StatementEvaluatorTest.assertEquals((String)"else", (String)this.buffer.toString().trim());
    }

    public final void testForeach() throws Exception {
        Variable self = new Variable("this", (EClassifier)EcorePackage.eINSTANCE.getEClass(), (Object)EcorePackage.eINSTANCE.getEAnnotation());
        ArrayList<String> tests = new ArrayList<String>();
        this.createDefineWithForeach().evaluate(this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{self, new Variable("tests", null, tests)}));
        StatementEvaluatorTest.assertEquals((String)"", (String)this.buffer.toString().trim());
        tests.add("hallo");
        this.createDefineWithForeach().evaluate(this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{self, new Variable("tests", null, tests)}));
        StatementEvaluatorTest.assertEquals((String)"hallo", (String)this.buffer.toString().trim());
        tests.add("Du");
        this.createDefineWithForeach().evaluate(this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{self, new Variable("tests", null, tests)}));
        StatementEvaluatorTest.assertEquals((String)"hallo,Du", (String)this.buffer.toString().trim());
        tests.add("da");
        this.createDefineWithForeach().evaluate(this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{self, new Variable("tests", null, tests)}));
        StatementEvaluatorTest.assertEquals((String)"hallo,Du,da", (String)this.buffer.toString().trim());
    }

    private XpandDefinition createDefineWithForeach() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("DEFINE test FOR ecore::EClass")) + this.tag("FOREACH tests AS test SEPARATOR ','") + this.tag("test") + this.tag("ENDFOREACH") + this.tag("ENDDEFINE"));
        StatementEvaluatorTest.assertEquals((int)1, (int)t.getDefinitions().length);
        XpandDefinition defineWithForeach = t.getDefinitions()[0];
        return defineWithForeach;
    }

    public final void testMultilineText() throws Exception {
        String text = "abc\r\ncba";
        String str = String.valueOf(this.tag("DEFINE z FOR o")) + text + this.tag("ENDDEFINE");
        Template t = this.parse(str);
        StatementEvaluatorTest.assertNotNull((Object)t);
        TextStatement textStmt = (TextStatement)((Definition)t.getDefinitions()[0]).getBody()[0];
        StatementEvaluatorTest.assertEquals((String)text, (String)textStmt.getValue());
    }

    public final void testTrailingText() {
        String str = String.valueOf(this.tag("DEFINE z FOR o")) + "abc" + this.tag("ENDDEFINExxx");
        try {
            Template t = this.parse(str);
            StatementEvaluatorTest.assertNull((Object)t);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            StatementEvaluatorTest.fail((String)("Parsing should not fail with exception (" + ex.getClass().getSimpleName() + ")even when the grammar is incorrect"));
        }
    }

    public final void testCommentOnly() throws Exception {
        StatementEvaluatorTest.assertNotNull((Object)this.parse(String.valueOf(this.tag("REM")) + "zx" + this.tag("ENDREM")));
    }

    public final void testCommentNestedTag() throws Exception {
        String nestedTag = String.valueOf(this.tag("DEFINE")) + "placeholder" + this.tag("ENDDEFINE");
        String string = String.valueOf(this.tag("REM")) + " bla-bla " + nestedTag + " foo" + this.tag("ENDREM");
        string = String.valueOf(string) + this.tag("DEFINE z FOR o") + this.tag("ENDDEFINE");
        StatementEvaluatorTest.assertNotNull((Object)this.parse(string));
    }

    public final void testWhitespacesAtTopLevel() throws Exception {
        String text = String.valueOf(this.tag("REM")) + "zx" + this.tag("ENDREM");
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + this.tag("DEFINE test FOR Object") + this.tag("ENDDEFINE");
        text = String.valueOf(text) + "\r";
        StatementEvaluatorTest.assertNotNull((Object)this.parse(text));
    }

    public final void testComment() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("DEFINE test FOR ecore::EClass")) + "TEST" + this.tag("REM") + "zx" + this.tag("ENDREM") + "test" + this.tag("FOREACH tests AS test SEPARATOR ','") + this.tag("test") + this.tag("ENDFOREACH") + this.tag("ENDDEFINE"));
        TextStatement text = (TextStatement)((Definition)t.getDefinitions()[0]).getBody()[0];
        StatementEvaluatorTest.assertEquals((String)"TEST", (String)text.getValue());
        text = (TextStatement)((Definition)t.getDefinitions()[0]).getBody()[1];
        StatementEvaluatorTest.assertEquals((String)"test", (String)text.getValue());
    }

    public final void testMultiParams1() throws Exception {
        new XpandFacade((ExecutionContext)this.execCtx).evaluate("org::eclipse::gmf::tests::xpand::evaluate::MultiParams::test", (Object)"A", new Object[]{"B", "C"});
        StatementEvaluatorTest.assertEquals((String)"ABC1", (String)this.buffer.toString());
    }

    public final void testMultiParams2() throws Exception {
        new XpandFacade((ExecutionContext)this.execCtx).evaluate("org::eclipse::gmf::tests::xpand::evaluate::MultiParams::test", (Object)"A", new Object[]{"B", new Integer(1)});
        StatementEvaluatorTest.assertEquals((String)"AB12", (String)this.buffer.toString());
    }

    public final void testForeach2() throws Exception {
        new XpandFacade((ExecutionContext)this.execCtx).evaluate("org::eclipse::gmf::tests::xpand::evaluate::Foreach::test", (Object)"X", new Object[0]);
        String[] result = this.buffer.toString().trim().split(",");
        StatementEvaluatorTest.assertEquals((String)"XXX", (String)result[0].trim());
        StatementEvaluatorTest.assertEquals((String)"XXXXX", (String)result[1].trim());
    }

    public void testReferenceAnotherDefinition() throws Exception {
        String test = String.valueOf(this.tag("DEFINE test FOR String")) + "TEST" + this.tag("EXPAND test2") + this.tag("ENDDEFINE");
        String test2 = String.valueOf(this.tag("DEFINE test2 FOR String")) + "2" + this.tag("ENDDEFINE");
        Template t = this.parse(String.valueOf(test) + "\n" + test2);
        XpandDefinition xpandDefinition = t.getDefinitions()[0];
        ExecutionContextImpl ctx = new ExecutionContextImpl(new Scope((Output)this.out){});
        ctx = ctx.cloneWithVariable(new Variable[]{new Variable("this", null, (Object)"")});
        xpandDefinition.evaluate((ExecutionContext)ctx);
        StatementEvaluatorTest.assertEquals((String)"TEST2", (String)this.buffer.toString());
    }
}

