/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.ecore.expressions.EcoreAbstractExpression;
import org.eclipse.gmf.ecore.expressions.EcoreOCLFactory;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class EcoreVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.gmf.ecore.editor/debug/visualID";
    private static EcoreAbstractExpression EDataType_2004_Constraint;
    private static EcoreAbstractExpression EDataType_3006_Constraint;
    private static EcoreAbstractExpression EReference_4002_Constraint;
    private static EcoreAbstractExpression EReference_4003_Constraint;

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Ecore".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return EcoreVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                EcoreDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (EcorePackage.eINSTANCE.getEPackage().isSuperTypeOf(domainElement.eClass()) && EcoreVisualIDRegistry.isDiagram((EPackage)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = EcoreVisualIDRegistry.getModelID(containerView);
        if (!"Ecore".equals(containerModelID) && !"ecore".equals(containerModelID)) {
            return -1;
        }
        if ("Ecore".equals(containerModelID)) {
            containerVisualID = EcoreVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 7001: {
                if (!EcorePackage.eINSTANCE.getEAttribute().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7002: {
                if (!EcorePackage.eINSTANCE.getEOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7003: {
                if (!EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7004: {
                if (!EcorePackage.eINSTANCE.getEClass().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 7005: {
                if (!EcorePackage.eINSTANCE.getEPackage().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7006: {
                if (!EcorePackage.eINSTANCE.getEDataType().isSuperTypeOf(domainElement.eClass()) || !EcoreVisualIDRegistry.isEDataType_3006((EDataType)domainElement)) break;
                return 3006;
            }
            case 7007: {
                if (!EcorePackage.eINSTANCE.getEEnum().isSuperTypeOf(domainElement.eClass())) break;
                return 3007;
            }
            case 7008: {
                if (!EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7009: {
                if (!EcorePackage.eINSTANCE.getEStringToStringMapEntry().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7010: {
                if (!EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7011: {
                if (!EcorePackage.eINSTANCE.getEEnumLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7012: {
                if (!EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 1000: {
                if (EcorePackage.eINSTANCE.getEClass().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (EcorePackage.eINSTANCE.getEPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (EcorePackage.eINSTANCE.getEDataType().isSuperTypeOf(domainElement.eClass()) && EcoreVisualIDRegistry.isEDataType_2004((EDataType)domainElement)) {
                    return 2004;
                }
                if (!EcorePackage.eINSTANCE.getEEnum().isSuperTypeOf(domainElement.eClass())) break;
                return 2005;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = EcoreVisualIDRegistry.getModelID(containerView);
        if (!"Ecore".equals(containerModelID) && !"ecore".equals(containerModelID)) {
            return false;
        }
        if ("Ecore".equals(containerModelID)) {
            containerVisualID = EcoreVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (7005 == nodeVisualID) {
                    return true;
                }
                if (7006 == nodeVisualID) {
                    return true;
                }
                if (7007 == nodeVisualID) {
                    return true;
                }
                if (7008 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (7009 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7010 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (7011 == nodeVisualID) {
                    return true;
                }
                if (7012 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7011: {
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7012: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6003 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6004 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (EcorePackage.eINSTANCE.getEReference().isSuperTypeOf(domainElement.eClass()) && EcoreVisualIDRegistry.isEReference_4002((EReference)domainElement)) {
            return 4002;
        }
        if (EcorePackage.eINSTANCE.getEReference().isSuperTypeOf(domainElement.eClass()) && EcoreVisualIDRegistry.isEReference_4003((EReference)domainElement)) {
            return 4003;
        }
        return -1;
    }

    private static boolean isDiagram(EPackage element) {
        return true;
    }

    private static boolean isEDataType_2004(EDataType domainElement) {
        Object result;
        if (EDataType_2004_Constraint == null) {
            EDataType_2004_Constraint = EcoreOCLFactory.getExpression("not oclIsKindOf(ecore::EEnum)", (EClassifier)EcorePackage.eINSTANCE.getEDataType());
        }
        return (result = EDataType_2004_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isEDataType_3006(EDataType domainElement) {
        Object result;
        if (EDataType_3006_Constraint == null) {
            EDataType_3006_Constraint = EcoreOCLFactory.getExpression("not oclIsKindOf(ecore::EEnum)", (EClassifier)EcorePackage.eINSTANCE.getEDataType());
        }
        return (result = EDataType_3006_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isEReference_4002(EReference domainElement) {
        Object result;
        if (EReference_4002_Constraint == null) {
            EReference_4002_Constraint = EcoreOCLFactory.getExpression("not containment and not container", (EClassifier)EcorePackage.eINSTANCE.getEReference());
        }
        return (result = EReference_4002_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isEReference_4003(EReference domainElement) {
        Object result;
        if (EReference_4003_Constraint == null) {
            EReference_4003_Constraint = EcoreOCLFactory.getExpression("containment", (EClassifier)EcorePackage.eINSTANCE.getEReference());
        }
        return (result = EReference_4003_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }
}

