/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.RuntimeDiagramTestBase;

public class LinkCreationConstraintsTest
extends RuntimeDiagramTestBase {
    public LinkCreationConstraintsTest(String name) {
        super(name);
    }

    public void testCreateConstrainedLinks() throws Exception {
        Diagram diagram = (Diagram)this.getDiagramEditPart().getModel();
        Node sourceContainerNode = this.createNode((GenCommonBase)this.getSourceGenNode(), (View)diagram);
        this.setBusinessElementStructuralFeature((View)sourceContainerNode, "acceptLinkKind", null);
        Node targetNode = this.createNode((GenCommonBase)this.getTargetGenNode(), (View)diagram);
        LinkCreationConstraintsTest.assertNotNull((Object)this.findEditPart((View)targetNode));
        this.setBusinessElementStructuralFeature((View)sourceContainerNode, "acceptLinkKind", null);
        LinkCreationConstraintsTest.assertFalse((String)"Can start link without acceptedLinkKind", (boolean)this.canStartLinkFrom(this.getRefGenLink(), (View)sourceContainerNode));
        String linkKind = "kind1";
        this.setBusinessElementStructuralFeature((View)sourceContainerNode, "acceptLinkKind", linkKind);
        LinkCreationConstraintsTest.assertTrue((String)"Allow start link with acceptedLinkKind", (boolean)this.canStartLinkFrom(this.getRefGenLink(), (View)sourceContainerNode));
        LinkCreationConstraintsTest.assertNull((String)"Do not create link to node with different linkKind", (Object)this.createLink(this.getRefGenLink(), (View)sourceContainerNode, (View)targetNode));
        this.setBusinessElementStructuralFeature((View)targetNode, "acceptLinkKind", linkKind);
        Edge link = this.createLink(this.getRefGenLink(), (View)sourceContainerNode, (View)targetNode);
        LinkCreationConstraintsTest.assertNotNull((String)"Link start should be allowed", (Object)link);
        LinkCreationConstraintsTest.assertNull((String)"Do not create already existing link", (Object)this.createLink(this.getRefGenLink(), (View)sourceContainerNode, (View)targetNode));
        LinkCreationConstraintsTest.assertFalse((String)"Do allow start for 2nd link", (boolean)this.canStartLinkFrom(this.getRefGenLink(), (View)sourceContainerNode));
        LinkCreationConstraintsTest.assertNotNull((String)"Should create link for nodes with equal acceptLinkKind", (Object)this.createLink(this.getClassGenLink(), (View)sourceContainerNode, (View)targetNode));
        this.setBusinessElementStructuralFeature((View)sourceContainerNode, "acceptLinkKind", null);
        LinkCreationConstraintsTest.assertTrue((String)"Should start link with no restriction", (boolean)this.canStartLinkFrom(this.getClassGenLink(), (View)sourceContainerNode));
        LinkCreationConstraintsTest.assertNull((String)"Should not create link for nodes with different acceptLinkKind", (Object)this.createLink(this.getClassGenLink(), (View)sourceContainerNode, (View)targetNode));
        this.setBusinessElementStructuralFeature((View)targetNode, "acceptLinkKind", "kind1");
        this.setBusinessElementStructuralFeature((View)sourceContainerNode, "acceptLinkKind", "kind1");
        LinkCreationConstraintsTest.assertTrue((boolean)this.canStartLinkFrom(this.getClassGenLink(), (View)sourceContainerNode));
        LinkCreationConstraintsTest.assertNotNull((String)"Should create link for nodes with equal acceptLinkKind", (Object)this.createLink(this.getClassGenLink(), (View)sourceContainerNode, (View)targetNode));
    }

    private GenLink getRefGenLink() {
        return this.getGenModel().getLinkD();
    }

    private GenNode getSourceGenNode() {
        return this.getGenModel().getNodeA();
    }

    private GenLink getClassGenLink() {
        return this.getGenModel().getLinkC();
    }

    private GenNode getTargetGenNode() {
        return this.getGenModel().getNodeB();
    }
}

