/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.providers.internal;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNodesOperation;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.DiagramProvidersDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.DiagramProvidersPlugin;
import org.eclipse.gmf.runtime.diagram.ui.requests.SetAllBendpointRequest;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.Assert;

public abstract class DefaultProvider
extends AbstractLayoutEditPartProvider {
    protected int minX = -1;
    protected int minY = -1;
    protected int layoutDefaultMargin = 0;
    protected IMapMode mm;
    protected static final int NODE_PADDING = 30;
    protected static final int MIN_EDGE_PADDING = 5;
    protected static final int MAX_EDGE_PADDING = 90;

    protected IMapMode getMapMode() {
        return this.mm;
    }

    public boolean provides(IOperation operation) {
        Assert.isNotNull((Object)operation);
        View cview = this.getContainer(operation);
        if (cview == null) {
            return false;
        }
        IAdaptable layoutHint = ((LayoutNodesOperation)operation).getLayoutHint();
        String layoutType = (String)layoutHint.getAdapter(String.class);
        return "DEFAULT".equals(layoutType);
    }

    public Command layoutEditParts(GraphicalEditPart containerEditPart, IAdaptable layoutHint) {
        if (containerEditPart == null) {
            InvalidParameterException ipe = new InvalidParameterException();
            Trace.throwing((Plugin)DiagramProvidersPlugin.getInstance(), (String)DiagramProvidersDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"layout()", (Throwable)ipe);
            throw ipe;
        }
        this.mm = MapModeUtil.getMapMode((IFigure)containerEditPart.getFigure());
        DirectedGraph g = this.createGraph();
        this.build_graph(g, containerEditPart.getChildren());
        this.createGraphLayout().visit(g);
        Command cmd = this.update_diagram(containerEditPart, g, false);
        this.mm = null;
        return cmd;
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        if (selectedObjects.size() == 0) {
            return null;
        }
        GraphicalEditPart editPart = (GraphicalEditPart)selectedObjects.get(0);
        GraphicalEditPart containerEditPart = (GraphicalEditPart)editPart.getParent();
        this.mm = MapModeUtil.getMapMode((IFigure)containerEditPart.getFigure());
        DirectedGraph g = this.createGraph();
        this.build_graph(g, selectedObjects);
        this.createGraphLayout().visit(g);
        Command cmd = this.update_diagram(containerEditPart, g, true);
        this.mm = null;
        return cmd;
    }

    protected boolean layoutTopDown(ConnectionEditPart poly) {
        return false;
    }

    protected NodeList build_nodes(List selectedObjects, Map editPartToNodeDict, Subgraph root) {
        ListIterator li = selectedObjects.listIterator();
        NodeList nodes = new NodeList();
        while (li.hasNext()) {
            IGraphicalEditPart gep = (IGraphicalEditPart)li.next();
            if (!(gep instanceof ShapeEditPart)) continue;
            ShapeEditPart shapeEP = (ShapeEditPart)gep;
            Point position = shapeEP.getLocation();
            if (this.minX == -1) {
                this.minX = position.x;
                this.minY = position.y;
            } else {
                this.minX = Math.min(this.minX, position.x);
                this.minY = Math.min(this.minY, position.y);
            }
            Node n = new Node((Object)shapeEP);
            n.setPadding(new Insets(30));
            Dimension size = shapeEP.getSize();
            this.setNodeMetrics(n, new Rectangle(position.x, position.y, size.width, size.height));
            editPartToNodeDict.put(shapeEP, n);
            nodes.add((Object)n);
        }
        return nodes;
    }

    protected final void setNodeMetrics(Node n, Rectangle r) {
        Rectangle rectGraph = this.translateToGraph(r);
        n.x = rectGraph.x;
        n.y = rectGraph.y;
        n.width = rectGraph.width;
        n.height = rectGraph.height;
    }

    protected Rectangle getNodeMetrics(Node n) {
        Rectangle rect = null;
        Subgraph parent = n.getParent();
        while (parent != null && !(parent.data instanceof IGraphicalEditPart)) {
            parent = parent.getParent();
        }
        rect = parent != null ? new Rectangle(n.x - parent.x, n.y - parent.y, n.width, n.height) : new Rectangle(n.x, n.y, n.width, n.height);
        return this.translateFromGraph(rect);
    }

    protected abstract Rectangle translateToGraph(Rectangle var1);

    protected abstract Rectangle translateFromGraph(Rectangle var1);

    protected EdgeList build_edges(List selectedObjects, Map editPartToNodeDict) {
        EdgeList edges = new EdgeList();
        ArrayList objects = new ArrayList();
        objects.addAll(selectedObjects);
        ListIterator li = objects.listIterator();
        ArrayList<ConnectionEditPart> notTopDownEdges = new ArrayList<ConnectionEditPart>();
        boolean shouldHandleListItems = this.shouldHandleConnectableListItems();
        while (li.hasNext()) {
            EditPart gep = (EditPart)li.next();
            if (!(gep instanceof ConnectionEditPart)) continue;
            ConnectionEditPart poly = (ConnectionEditPart)gep;
            if (this.layoutTopDown(poly)) {
                EditPart from = poly.getSource();
                EditPart to = poly.getTarget();
                if (from instanceof IBorderItemEditPart) {
                    from = from.getParent();
                } else if (shouldHandleListItems && from instanceof ListItemEditPart) {
                    from = this.getFirstAnscestorinNodesMap(from, editPartToNodeDict);
                }
                if (to instanceof IBorderItemEditPart) {
                    to = to.getParent();
                } else if (shouldHandleListItems && to instanceof ListItemEditPart) {
                    to = this.getFirstAnscestorinNodesMap(to, editPartToNodeDict);
                }
                Node fromNode = (Node)editPartToNodeDict.get(from);
                Node toNode = (Node)editPartToNodeDict.get(to);
                if (fromNode == null || toNode == null || fromNode.equals(toNode)) continue;
                this.addEdge(edges, poly, toNode, fromNode);
                continue;
            }
            notTopDownEdges.add(poly);
        }
        li = notTopDownEdges.listIterator();
        while (li.hasNext()) {
            ConnectionEditPart poly = (ConnectionEditPart)li.next();
            EditPart from = poly.getSource();
            EditPart to = poly.getTarget();
            if (from instanceof IBorderItemEditPart) {
                from = from.getParent();
            } else if (shouldHandleListItems && from instanceof ListItemEditPart) {
                from = this.getFirstAnscestorinNodesMap(from, editPartToNodeDict);
            }
            if (to instanceof IBorderItemEditPart) {
                to = to.getParent();
            } else if (shouldHandleListItems && to instanceof ListItemEditPart) {
                to = this.getFirstAnscestorinNodesMap(to, editPartToNodeDict);
            }
            Node fromNode = (Node)editPartToNodeDict.get(from);
            Node toNode = (Node)editPartToNodeDict.get(to);
            if (fromNode == null || toNode == null || fromNode.equals(toNode)) continue;
            this.addEdge(edges, poly, fromNode, toNode);
        }
        return edges;
    }

    private void addEdge(EdgeList edges, ConnectionEditPart connectionEP, Node fromNode, Node toNode) {
        Edge edge = new Edge((Object)connectionEP, fromNode, toNode);
        this.initializeEdge(connectionEP, edge);
        edges.add((Object)edge);
    }

    protected void initializeEdge(ConnectionEditPart connectionEP, Edge edge) {
        List affectingChildren = this.getAffectingChildren(connectionEP);
        edge.setPadding(Math.max(edge.getPadding(), this.calculateEdgePadding(connectionEP, affectingChildren)));
        edge.setDelta(Math.max(edge.getDelta(), affectingChildren.size() / 2));
    }

    private int calculateEdgePadding(ConnectionEditPart connectionEP, List affectingChildren) {
        ListIterator li = affectingChildren.listIterator();
        int padding = 0;
        while (li.hasNext()) {
            GraphicalEditPart gep = (GraphicalEditPart)li.next();
            padding = Math.max(padding, Math.max(gep.getFigure().getBounds().width, gep.getFigure().getBounds().height));
        }
        Rectangle.SINGLETON.x = 0;
        Rectangle.SINGLETON.y = 0;
        Rectangle.SINGLETON.width = padding;
        Rectangle.SINGLETON.height = padding;
        return Math.min(Math.max(Math.round((float)this.translateToGraph((Rectangle)Rectangle.SINGLETON).width * 1.5f), 5), 90);
    }

    private List getAffectingChildren(ConnectionEditPart conn) {
        List children = conn.getChildren();
        ListIterator lli = children.listIterator();
        ArrayList<GraphicalEditPart> affectingChildrenList = new ArrayList<GraphicalEditPart>();
        while (lli.hasNext()) {
            Object obj = lli.next();
            if (!(obj instanceof GraphicalEditPart)) continue;
            GraphicalEditPart lep = (GraphicalEditPart)obj;
            Rectangle lepBox = lep.getFigure().getBounds().getCopy();
            if (!lep.getFigure().isVisible() || lepBox.width == 0 || lepBox.height == 0) continue;
            affectingChildrenList.add(lep);
        }
        return affectingChildrenList;
    }

    protected List getRelevantConnections(Hashtable editPartToNodeDict) {
        Enumeration enumeration = editPartToNodeDict.keys();
        ArrayList<ConnectionEditPart> connectionsToMove = new ArrayList<ConnectionEditPart>();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            GraphicalEditPart shapeEP = (GraphicalEditPart)e;
            HashSet sourceConnections = new HashSet(shapeEP.getSourceConnections());
            if (shapeEP instanceof IBorderedShapeEditPart) {
                List borderItems = this.getBorderItemEditParts((EditPart)shapeEP);
                for (GraphicalEditPart element : borderItems) {
                    sourceConnections.addAll(element.getSourceConnections());
                }
            }
            for (ConnectionEditPart connectionEP : sourceConnections) {
                Object o;
                EditPart target = connectionEP.getTarget();
                if (target instanceof IBorderItemEditPart) {
                    target = target.getParent();
                }
                if ((o = editPartToNodeDict.get(target)) == null) continue;
                connectionsToMove.add(connectionEP);
            }
            if (!this.shouldHandleConnectableListItems()) continue;
            this.handleConnectableListItems(shapeEP, editPartToNodeDict, connectionsToMove);
        }
        return connectionsToMove;
    }

    private void handleConnectableListItems(GraphicalEditPart shapeEP, Map editPartToNodeDict, ArrayList connectionsToMove) {
        List children = shapeEP.getChildren();
        for (EditPart ep : children) {
            if (!(ep instanceof ListCompartmentEditPart)) continue;
            List listItems = ep.getChildren();
            for (GraphicalEditPart listItem : listItems) {
                List connections = listItem.getSourceConnections();
                for (ConnectionEditPart connectionEP : connections) {
                    EditPart ancestor = this.getFirstAnscestorinNodesMap(connectionEP.getTarget(), editPartToNodeDict);
                    if (ancestor == null) continue;
                    connectionsToMove.add(connectionEP);
                }
            }
        }
    }

    private EditPart getFirstAnscestorinNodesMap(EditPart editPart, Map editPartToNodeDict) {
        EditPart ancestor = editPart;
        while (ancestor != null) {
            if (editPartToNodeDict.get(ancestor) != null) {
                return ancestor;
            }
            ancestor = ancestor.getParent();
        }
        return null;
    }

    private List getBorderItemEditParts(EditPart parent) {
        Iterator iter = parent.getChildren().iterator();
        ArrayList<EditPart> list = new ArrayList<EditPart>();
        while (iter.hasNext()) {
            EditPart child = (EditPart)iter.next();
            if (!(child instanceof IBorderItemEditPart)) continue;
            list.add(child);
        }
        return list;
    }

    protected void build_graph(DirectedGraph g, List selectedObjects) {
        Hashtable editPartToNodeDict = new Hashtable(500);
        this.minX = -1;
        this.minY = -1;
        NodeList nodes = this.build_nodes(selectedObjects, editPartToNodeDict, null);
        ArrayList objects = new ArrayList();
        objects.addAll(selectedObjects);
        objects.addAll(this.getRelevantConnections(editPartToNodeDict));
        EdgeList edges = this.build_edges(objects, editPartToNodeDict);
        g.nodes = nodes;
        g.edges = edges;
        this.postProcessGraph(g, editPartToNodeDict);
    }

    protected void postProcessGraph(DirectedGraph g, Hashtable editPartToNodeDict) {
    }

    private void reverse(PointList c, PointList rc) {
        rc.removeAllPoints();
        int i = c.size() - 1;
        while (i >= 0) {
            rc.addPoint(c.getPoint(i));
            --i;
        }
    }

    Command routeThrough(Edge edge, ConnectionEditPart connectEP, Node source, Node target, PointList points, int diffX, int diffY) {
        if (connectEP == null) {
            return null;
        }
        PointList routePoints = points;
        if (source.data == connectEP.getTarget()) {
            routePoints = new PointList(points.size());
            this.reverse(points, routePoints);
            Node tmpNode = source;
            source = target;
            target = tmpNode;
        }
        int totalEdgeDiffX = diffX;
        int totalEdgeDiffY = diffY;
        Subgraph parent = null;
        parent = source.getParent();
        if (parent == null) {
            parent = target.getParent();
        }
        if (parent != null) {
            Rectangle targetExt = this.getNodeMetrics((Node)parent);
            totalEdgeDiffX += targetExt.x;
            totalEdgeDiffY += targetExt.y;
        }
        PointList allPoints = new PointList(routePoints.size());
        int i = 0;
        while (i < routePoints.size()) {
            allPoints.addPoint(routePoints.getPoint((int)i).x + totalEdgeDiffX, routePoints.getPoint((int)i).y + totalEdgeDiffY);
            ++i;
        }
        Rectangle sourceExt = this.getNodeMetrics(source);
        Point ptSourceReference = sourceExt.getCenter().getTranslated(diffX, diffY);
        Rectangle targetExt = this.getNodeMetrics(target);
        Point ptTargetReference = targetExt.getCenter().getTranslated(diffX, diffY);
        SetAllBendpointRequest request = new SetAllBendpointRequest("set_all_connection_bendpoint", allPoints, ptSourceReference, ptTargetReference);
        CompoundCommand cc = new CompoundCommand("");
        Command cmd = connectEP.getCommand((Request)request);
        if (cmd != null) {
            cc.add(cmd);
        }
        List affectingChildren = this.getAffectingChildren(connectEP);
        Request snapBackRequest = new Request((Object)"snap_back");
        ListIterator li = affectingChildren.listIterator();
        while (li.hasNext()) {
            EditPart ep = (EditPart)li.next();
            cmd = ep.getCommand(snapBackRequest);
            if (cmd == null) continue;
            cc.add(cmd);
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    protected Command update_diagram(GraphicalEditPart diagramEP, DirectedGraph g, boolean isLayoutForSelected) {
        CompoundCommand cc = new CompoundCommand("");
        Point diff = this.getLayoutPositionDelta(g, isLayoutForSelected);
        this.layoutDefaultMargin = MapModeUtil.getMapMode((IFigure)diagramEP.getFigure()).DPtoLP(25);
        Command cmd = this.createNodeChangeBoundCommands(g, diff);
        if (cmd != null) {
            cc.add(cmd);
        }
        if ((cmd = this.createEdgesChangeBoundsCommands(g, diff)) != null) {
            cc.add(cmd);
        }
        return cc;
    }

    protected Command createEdgesChangeBoundsCommands(DirectedGraph g, Point diff) {
        CompoundCommand cc = new CompoundCommand("");
        PointList points = new PointList(10);
        ListIterator vi = g.edges.listIterator();
        while (vi.hasNext()) {
            Edge edge = (Edge)vi.next();
            if (edge.data == null || edge.getPoints() == null) continue;
            points.removeAllPoints();
            ConnectionEditPart cep = null;
            Node source = null;
            Node target = null;
            this.collectPoints(points, edge);
            cep = (ConnectionEditPart)edge.data;
            source = edge.source;
            target = edge.target;
            if (cep == null) continue;
            PointListUtilities.normalizeSegments((PointList)points, (int)MapModeUtil.getMapMode((IFigure)cep.getFigure()).DPtoLP(3));
            Command cmd = this.routeThrough(edge, cep, source, target, points, diff.x, diff.y);
            if (cmd == null) continue;
            cc.add(cmd);
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    private void collectPoints(PointList points, Edge edge) {
        PointList pointList = edge.getPoints();
        Rectangle start = this.translateFromGraph(new Rectangle(pointList.getFirstPoint().x, pointList.getFirstPoint().y, 0, 0));
        points.addPoint(start.getTopLeft());
        NodeList vnodes = edge.vNodes;
        if (vnodes != null) {
            int i = 0;
            while (i < vnodes.size()) {
                Node vn = vnodes.getNode(i);
                Rectangle nodeExt = this.getNodeMetrics(vn);
                int x = nodeExt.x;
                int y = nodeExt.y;
                points.addPoint(x + nodeExt.width / 2, y + nodeExt.height / 2);
                ++i;
            }
        }
        Rectangle end = this.translateFromGraph(new Rectangle(pointList.getLastPoint().x, pointList.getLastPoint().y, 0, 0));
        points.addPoint(end.getTopLeft());
    }

    protected Command createNodeChangeBoundCommands(DirectedGraph g, Point diff) {
        ListIterator vi = g.nodes.listIterator();
        CompoundCommand cc = new CompoundCommand("");
        this.createSubCommands(diff, vi, cc);
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    protected void createSubCommands(Point diff, ListIterator vi, CompoundCommand cc) {
        while (vi.hasNext()) {
            Node node = (Node)vi.next();
            if (!(node.data instanceof ShapeEditPart)) continue;
            IGraphicalEditPart gep = (IGraphicalEditPart)node.data;
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
            Rectangle nodeExt = this.getNodeMetrics(node);
            Point ptLocation = new Point(nodeExt.x + diff.x, nodeExt.y + diff.y);
            Point ptOldLocation = gep.getFigure().getBounds().getLocation();
            gep.getFigure().translateToAbsolute((Translatable)ptOldLocation);
            gep.getFigure().translateToAbsolute((Translatable)ptLocation);
            Dimension delta = ptLocation.getDifference(ptOldLocation);
            request.setEditParts((EditPart)gep);
            request.setMoveDelta(new Point(delta.width, delta.height));
            request.setLocation(ptLocation);
            Command cmd = gep.getCommand((Request)request);
            if (cmd == null || !cmd.canExecute()) continue;
            cc.add(cmd);
        }
    }

    private Point getLayoutPositionDelta(DirectedGraph g, boolean isLayoutForSelected) {
        if (isLayoutForSelected) {
            ListIterator vi = g.nodes.listIterator();
            Point ptLayoutMin = new Point(-1, -1);
            while (vi.hasNext()) {
                Node node = (Node)vi.next();
                if (node.data == null) continue;
                Rectangle nodeExt = this.getNodeMetrics(node);
                if (ptLayoutMin.x == -1) {
                    ptLayoutMin.x = nodeExt.x;
                    ptLayoutMin.y = nodeExt.y;
                    continue;
                }
                ptLayoutMin.x = Math.min(ptLayoutMin.x, nodeExt.x);
                ptLayoutMin.y = Math.min(ptLayoutMin.y, nodeExt.y);
            }
            return new Point(this.minX - ptLayoutMin.x, this.minY - ptLayoutMin.y);
        }
        return new Point(this.layoutDefaultMargin, this.layoutDefaultMargin);
    }

    protected DirectedGraph createGraph() {
        return new DirectedGraph();
    }

    protected DirectedGraphLayout createGraphLayout() {
        return new DirectedGraphLayout();
    }

    protected boolean shouldHandleConnectableListItems() {
        return false;
    }
}

