/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ObliqueRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouterUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RouterHelper;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class RectilinearRouter
extends ObliqueRouter
implements OrthogonalRouter {
    private static int CONNECTION_OFFSET = 26;
    private static final int maxRoutingDepth = 10;

    protected boolean removeSegmentsInViews(Connection conn, PointList newLine) {
        PointList newPoints = new PointList(newLine.size());
        Point ptStart = new Point(newLine.getFirstPoint());
        Point ptEnd = new Point(newLine.getLastPoint());
        int i = 0;
        while (i < newLine.size()) {
            if (i != 0 && i != newLine.size() - 1) {
                newPoints.addPoint(new Point(newLine.getPoint(i)));
            }
            ++i;
        }
        if (newPoints.size() < 3) {
            return false;
        }
        int lastIntersect = 0;
        int count = 0;
        boolean found = false;
        boolean bChanged = false;
        IFigure sourceFigure = conn.getSourceAnchor().getOwner();
        if (sourceFigure == null) {
            return false;
        }
        PointList startPolygon = this.getFigurePolygon(sourceFigure, conn);
        int i2 = 0;
        while (i2 < newPoints.size() - 1) {
            boolean in2;
            boolean in1 = PointListUtilities.containsPoint(startPolygon, newPoints.getPoint(i2));
            if (in1 != (in2 = PointListUtilities.containsPoint(startPolygon, newPoints.getPoint(i2 + 1)))) {
                lastIntersect = count;
                found = true;
            } else if (!in1 && !in2) break;
            ++count;
            ++i2;
        }
        if (found) {
            i2 = 0;
            while (i2 <= lastIntersect) {
                newPoints.removePoint(0);
                bChanged = true;
                ++i2;
            }
        }
        lastIntersect = count = newLine.size() - 1;
        found = false;
        IFigure targetFigure = conn.getTargetAnchor().getOwner();
        if (targetFigure == null) {
            return false;
        }
        PointList endPolygon = this.getFigurePolygon(targetFigure, conn);
        int i3 = newPoints.size() - 1;
        while (i3 > 0) {
            boolean in2;
            boolean in1 = PointListUtilities.containsPoint(endPolygon, newPoints.getPoint(i3));
            if (in1 != (in2 = PointListUtilities.containsPoint(endPolygon, newPoints.getPoint(i3 - 1)))) {
                lastIntersect = count;
                found = true;
            } else if (!in1 && !in2) break;
            --count;
            --i3;
        }
        if (found) {
            i3 = newPoints.size() - 1;
            while (i3 >= lastIntersect) {
                newPoints.removePoint(newPoints.size() - 1);
                bChanged = true;
                --i3;
            }
        }
        if (newPoints.size() != newLine.size()) {
            newLine.removeAllPoints();
            newLine.addPoint(ptStart);
            i3 = 0;
            while (i3 < newPoints.size()) {
                newLine.addPoint(new Point(newPoints.getPoint(i3)));
                ++i3;
            }
            newLine.addPoint(ptEnd);
        }
        return bChanged;
    }

    protected boolean updateToBiTerminal(Connection conn, PointList newLine) {
        boolean retVal = false;
        if (newLine.size() == 2) {
            boolean isOblique;
            Rectangle bBoxT;
            Rectangle bBoxF;
            Point ptOrig = new Point(newLine.getPoint(0));
            Point ptTerm = new Point(newLine.getPoint(1));
            Dimension offsets = new Dimension(10, 10);
            conn.translateToRelative((Translatable)offsets);
            if (conn.getSourceAnchor().getOwner() != null) {
                bBoxF = this.getBounds(conn.getSourceAnchor().getOwner());
                conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)bBoxF);
                conn.translateToRelative((Translatable)bBoxF);
            } else {
                bBoxF = new Rectangle(ptOrig.x - offsets.width / 2, ptOrig.y - offsets.height / 2, offsets.width, offsets.height);
            }
            if (conn.getTargetAnchor().getOwner() != null) {
                bBoxT = this.getBounds(conn.getTargetAnchor().getOwner());
                conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)bBoxT);
                conn.translateToRelative((Translatable)bBoxT);
            } else {
                bBoxT = new Rectangle(ptTerm.x - offsets.width / 2, ptTerm.y - offsets.height / 2, offsets.width, offsets.height);
            }
            int ix1 = Math.max(bBoxF.getLeft().x, bBoxT.getLeft().x);
            int ix2 = Math.min(bBoxF.getRight().x, bBoxT.getRight().x);
            Point posF = bBoxF.getCenter();
            Point posT = bBoxT.getCenter();
            Ray origSeg = new Ray(ptOrig, ptTerm);
            boolean bl = isOblique = origSeg.y != 0 && origSeg.x != 0;
            if (ix1 <= ix2) {
                if (isOblique || ptOrig.x < ix1 || ptOrig.x > ix2) {
                    posF.x = isOblique && ptOrig.x > ix1 && ptOrig.x < ix2 ? ptOrig.x : ix1 + (ix2 - ix1) / 2;
                    posT.x = posF.x;
                    newLine.removeAllPoints();
                    newLine.addPoint(posF);
                    newLine.addPoint(posT);
                    retVal = true;
                }
            } else {
                int iy2;
                int iy1 = Math.max(bBoxF.getTop().y, bBoxT.getTop().y);
                if (iy1 <= (iy2 = Math.min(bBoxF.getBottom().y, bBoxT.getBottom().y)) && (isOblique || ptOrig.y < iy1 || ptOrig.y > iy2)) {
                    posF.y = isOblique && ptOrig.y > iy1 && ptOrig.y < iy2 ? ptOrig.y : iy1 + (iy2 - iy1) / 2;
                    posT.y = posF.y;
                    newLine.removeAllPoints();
                    newLine.addPoint(posF);
                    newLine.addPoint(posT);
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    protected void resetEndPointsToEdge(Connection conn, PointList newLine) {
        if (this.isReorienting(conn)) {
            super.resetEndPointsToEdge(conn, newLine);
            return;
        }
        Point origin = null;
        if (conn.getSourceAnchor().getOwner() instanceof Connection) {
            origin = this.getIntersectionPoint((Connection)conn.getSourceAnchor().getOwner(), new LineSeg(newLine.getPoint(1), newLine.getPoint(0)));
        }
        if (origin == null) {
            LineSeg edgeLine1 = OrthogonalRouterUtilities.getOrthogonalLineSegToAnchorLoc(conn, conn.getSourceAnchor(), newLine.getPoint(1));
            origin = edgeLine1.getOrigin();
        }
        Point terminus = null;
        if (conn.getTargetAnchor().getOwner() instanceof Connection) {
            int numPoints = newLine.size();
            terminus = this.getIntersectionPoint((Connection)conn.getTargetAnchor().getOwner(), new LineSeg(newLine.getPoint(numPoints - 2), newLine.getPoint(numPoints - 1)));
        }
        if (terminus == null) {
            LineSeg edgeLine2 = OrthogonalRouterUtilities.getOrthogonalLineSegToAnchorLoc(conn, conn.getTargetAnchor(), newLine.getPoint(newLine.size() - 2));
            terminus = edgeLine2.getOrigin();
        }
        if (origin != null && terminus != null) {
            Point ptNext;
            Point ptCurrent;
            int i;
            newLine.setPoint(origin, 0);
            if (newLine.size() > 2) {
                i = 0;
                while (i < 2) {
                    ptCurrent = newLine.getPoint(i);
                    ptNext = newLine.getPoint(i + 1);
                    this.makeOrthogonal(ptCurrent, ptNext);
                    newLine.setPoint(ptNext, i + 1);
                    ++i;
                }
            }
            newLine.setPoint(terminus, newLine.size() - 1);
            if (newLine.size() > 2) {
                i = newLine.size() - 1;
                while (i >= newLine.size() - 2) {
                    ptCurrent = newLine.getPoint(i);
                    ptNext = newLine.getPoint(i - 1);
                    this.makeOrthogonal(ptCurrent, ptNext);
                    newLine.setPoint(ptNext, i - 1);
                    --i;
                }
            }
        } else {
            super.resetEndPointsToEdge(conn, newLine);
        }
    }

    private void makeOrthogonal(Point ptCurrent, Point ptNext) {
        if (Math.abs(ptNext.x - ptCurrent.x) < Math.abs(ptNext.y - ptCurrent.y)) {
            ptNext.x = ptCurrent.x;
        } else {
            ptNext.y = ptCurrent.y;
        }
    }

    protected void updateIfNotRectilinear(Connection conn, PointList newLine) {
        Point p2;
        Point p1;
        Point p0;
        boolean isRectilinear = true;
        int i = 0;
        while (i < newLine.size() - 1) {
            Ray segVector = new Ray(newLine.getPoint(i), newLine.getPoint(i + 1));
            if (segVector.x != 0 && segVector.y != 0) {
                isRectilinear = false;
                break;
            }
            ++i;
        }
        if (isRectilinear && this.areEndsInBounds(conn, newLine)) {
            return;
        }
        if (this.updateToBiTerminal(conn, newLine) && this.areEndsInBounds(conn, newLine)) {
            return;
        }
        OrthogonalRouterUtilities.resetEndPointsToCenter(conn, newLine);
        PointList oldPoints = PointListUtilities.copyPoints(newLine);
        PointList newPoints = new PointList();
        newPoints.addPoint(oldPoints.removePoint(0));
        while (oldPoints.size() > 0) {
            if (oldPoints.size() >= 2) {
                p0 = newPoints.getLastPoint();
                p1 = oldPoints.removePoint(0);
                p2 = oldPoints.removePoint(0);
                if (Math.abs(p2.y - p0.y) > Math.abs(p2.x - p0.x)) {
                    newPoints.addPoint(new Point(p1.x, p0.y));
                    newPoints.addPoint(new Point(p1.x, p2.y));
                } else {
                    newPoints.addPoint(new Point(p0.x, p1.y));
                    newPoints.addPoint(new Point(p2.x, p1.y));
                }
                newPoints.addPoint(p2);
                continue;
            }
            if (oldPoints.size() != 1) continue;
            p0 = newPoints.getLastPoint();
            p1 = oldPoints.removePoint(0);
            if (Math.abs(p1.y - p0.y) > Math.abs(p1.x - p0.x)) {
                newPoints.addPoint(new Point(p1.x, p0.y));
            } else {
                newPoints.addPoint(new Point(p0.x, p1.y));
            }
            newPoints.addPoint(p1);
        }
        oldPoints.removeAllPoints();
        oldPoints.addPoint(newPoints.removePoint(0));
        while (newPoints.size() >= 2) {
            p0 = oldPoints.getLastPoint();
            p1 = newPoints.getPoint(0);
            p2 = newPoints.getPoint(1);
            if (p0.x == p1.x && p0.x == p2.x) {
                newPoints.removePoint(0);
                continue;
            }
            if (p0.y == p1.y && p0.y == p2.y) {
                newPoints.removePoint(0);
                continue;
            }
            oldPoints.addPoint(newPoints.removePoint(0));
        }
        while (newPoints.size() > 0) {
            oldPoints.addPoint(newPoints.removePoint(0));
        }
        newLine.removeAllPoints();
        int i2 = 0;
        while (i2 < oldPoints.size()) {
            newLine.addPoint(oldPoints.getPoint(i2));
            ++i2;
        }
    }

    protected boolean checkEndSegments(Connection conn, PointList newLine) {
        boolean bOk = true;
        Dimension connection_offset = new Dimension(CONNECTION_OFFSET, 0);
        conn.translateToRelative((Translatable)connection_offset);
        if (newLine.size() > 2) {
            Point ptNext;
            Point ptFix = new Point(newLine.getPoint(1));
            if (!this.checkEndSegment(conn, conn.getSourceAnchor(), ptFix, connection_offset.width / 2)) {
                newLine.setPoint(ptFix, 1);
                ptNext = newLine.getPoint(2);
                this.makeOrthogonal(ptFix, ptNext);
                newLine.setPoint(ptNext, 2);
                bOk = false;
            }
            ptFix = new Point(newLine.getPoint(newLine.size() - 2));
            if (!this.checkEndSegment(conn, conn.getTargetAnchor(), ptFix, connection_offset.width / 2)) {
                newLine.setPoint(ptFix, newLine.size() - 2);
                ptNext = newLine.getPoint(newLine.size() - 3);
                this.makeOrthogonal(ptFix, ptNext);
                newLine.setPoint(ptNext, newLine.size() - 3);
                bOk = false;
            }
        }
        return bOk;
    }

    protected void straightenPoints(PointList newLine) {
        int i = 0;
        while (i < newLine.size() - 1) {
            Point ptCurrent = newLine.getPoint(i);
            Point ptNext = newLine.getPoint(i + 1);
            this.makeOrthogonal(ptCurrent, ptNext);
            newLine.setPoint(ptNext, i + 1);
            ++i;
        }
    }

    protected boolean checkEndSegment(Connection conn, ConnectionAnchor anchor, Point ptNext, int offset) {
        LineSeg seg = OrthogonalRouterUtilities.getOrthogonalLineSegToAnchorLoc(conn, anchor, ptNext);
        if (seg != null && seg.length() < (double)offset) {
            seg.pointOn(offset, LineSeg.KeyPoint.ORIGIN, ptNext);
            return false;
        }
        return true;
    }

    public void routeLine(Connection conn, int nestedRoutingDepth, PointList newLine) {
        boolean skipNormalization = (this.routerFlags & 1) != 0;
        int nStartSize = newLine.size();
        if (this.isReorienting(conn)) {
            super.routeLine(conn, nestedRoutingDepth, newLine);
            this.resetEndPointsToEdge(conn, newLine);
            return;
        }
        if (this.checkSelfRelConnection(conn, newLine)) {
            this.checkEndSegments(conn, newLine);
            this.resetEndPointsToEdge(conn, newLine);
            return;
        }
        if (this.checkShapesIntersect(conn, newLine)) {
            this.checkEndSegments(conn, newLine);
            this.resetEndPointsToEdge(conn, newLine);
            return;
        }
        this.updateIfNotRectilinear(conn, newLine);
        boolean normalizationChangedLine = false;
        if (!skipNormalization) {
            normalizationChangedLine = this.removeSegmentsInViews(conn, newLine);
            normalizationChangedLine |= this.removePointsInViews(conn, newLine);
            Dimension tolerance = new Dimension(3, 0);
            if (!RouterHelper.getInstance().isFeedback(conn)) {
                tolerance = (Dimension)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)tolerance);
            }
            normalizationChangedLine |= PointListUtilities.normalizeSegments(newLine, tolerance.width);
        }
        this.checkEndSegments(conn, newLine);
        this.resetEndPointsToEdge(conn, newLine);
        this.straightenPoints(newLine);
        if (normalizationChangedLine) {
            if (nestedRoutingDepth < 10) {
                this.routeLine(conn, ++nestedRoutingDepth, newLine);
                if (nestedRoutingDepth != 0) {
                    --nestedRoutingDepth;
                }
            }
        } else {
            Rectangle startRect = this.getBounds(conn.getSourceAnchor().getOwner());
            conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)startRect);
            conn.translateToRelative((Translatable)startRect);
            Dimension buffer = new Dimension(2, 2);
            conn.translateToRelative((Translatable)buffer);
            startRect.expand(buffer.width, buffer.height);
            Rectangle endRect = this.getBounds(conn.getTargetAnchor().getOwner());
            conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)endRect);
            conn.translateToRelative((Translatable)endRect);
            endRect.expand(buffer.width, buffer.height);
            if (!startRect.contains(newLine.getPoint(0)) || !endRect.contains(newLine.getPoint(newLine.size() - 1)) || newLine.size() - nStartSize >= 2) {
                newLine.removeAllPoints();
                Point r1 = conn.getSourceAnchor().getReferencePoint();
                conn.translateToRelative((Translatable)r1);
                newLine.addPoint(r1);
                Point r2 = conn.getTargetAnchor().getReferencePoint();
                conn.translateToRelative((Translatable)r2);
                newLine.addPoint(r2);
                this.updateIfNotRectilinear(conn, newLine);
                this.resetEndPointsToEdge(conn, newLine);
            }
        }
    }

    private boolean areEndsInBounds(Connection connection, PointList line) {
        PrecisionRectangle startRect = new PrecisionRectangle(this.getBounds(connection.getSourceAnchor().getOwner()));
        connection.getSourceAnchor().getOwner().translateToAbsolute((Translatable)startRect);
        connection.translateToRelative((Translatable)startRect);
        PrecisionRectangle endRect = new PrecisionRectangle(this.getBounds(connection.getTargetAnchor().getOwner()));
        connection.getTargetAnchor().getOwner().translateToAbsolute((Translatable)endRect);
        connection.translateToRelative((Translatable)endRect);
        return startRect.contains(line.getPoint(0)) && endRect.contains(line.getPoint(line.size() - 1));
    }

    private Rectangle getBounds(IFigure figure) {
        return figure instanceof Connection ? ((Connection)figure).getPoints().getBounds().getCopy() : figure.getBounds().getCopy();
    }

    private Point getIntersectionPoint(Connection connection, LineSeg lineSeg) {
        PointList intersections = lineSeg.getLineIntersectionsWithLineSegs(connection.getPoints());
        if (intersections.size() > 0) {
            return PointListUtilities.pickClosestPoint(intersections, lineSeg.getOrigin());
        }
        return null;
    }
}

