/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.codegen.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorChildReference;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorReferenceType;
import org.eclipse.gmf.codegen.gmfgen.GenNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenModelGraphAnalyzer {
    public GenModelGraphAnalyzer(GenDiagram diagram) {
    }

    public static List<List<GenCommonBase>> getConnectionPaths(GenNavigatorChildReference reference) {
        assert (reference.getParent() != null);
        if (reference.getReferenceType() == GenNavigatorReferenceType.CHILDREN_LITERAL) {
            return GenModelGraphAnalyzer.getChildConnectionPaths(reference.getParent(), reference.getChild());
        }
        if (reference.getReferenceType() == GenNavigatorReferenceType.IN_SOURCE_LITERAL) {
            return GenModelGraphAnalyzer.getInSourceLinkConnectionPaths(reference.getParent(), reference.getChild(), reference.getNavigator().getEditorGen().getDiagram());
        }
        if (reference.getReferenceType() == GenNavigatorReferenceType.OUT_TAGET_LITERAL) {
            return GenModelGraphAnalyzer.getOutTargetLinkConnectionPaths(reference.getParent(), reference.getChild(), reference.getNavigator().getEditorGen().getDiagram());
        }
        return Collections.emptyList();
    }

    private static List<List<GenCommonBase>> getOutTargetLinkConnectionPaths(GenCommonBase source, GenCommonBase target, GenDiagram diagram) {
        return new LinkedConnectionFinder(diagram, true).findConnectionPaths(source, target);
    }

    private static List<List<GenCommonBase>> getInSourceLinkConnectionPaths(GenCommonBase source, GenCommonBase target, GenDiagram diagram) {
        return new LinkedConnectionFinder(diagram, false).findConnectionPaths(source, target);
    }

    private static List<List<GenCommonBase>> getChildConnectionPaths(GenCommonBase source, GenCommonBase target) {
        return new ChildConnectionFinder().findConnectionPaths(source, target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractConnectionFinder {
        private Set<GenCommonBase> myVisiting = new LinkedHashSet<GenCommonBase>();

        protected abstract Collection<GenCommonBase> getConnectedNodes(GenCommonBase var1);

        public List<List<GenCommonBase>> findConnectionPaths(GenCommonBase source, GenCommonBase target) {
            if (this.isConnectionFound(source, target)) {
                ArrayList<GenCommonBase> path = new ArrayList<GenCommonBase>();
                path.add(target);
                ArrayList<List<GenCommonBase>> connections = new ArrayList<List<GenCommonBase>>();
                connections.add(path);
                return connections;
            }
            if (this.isVisiting(source)) {
                return new ArrayList<List<GenCommonBase>>();
            }
            this.startVisiting(source);
            try {
                Collection<GenCommonBase> connectedNodes = this.getConnectedNodes(source);
                ArrayList<List<GenCommonBase>> connections = new ArrayList<List<GenCommonBase>>();
                for (GenCommonBase genCommonBase : connectedNodes) {
                    connections.addAll(this.findConnectionPaths(genCommonBase, target));
                }
                for (List list : connections) {
                    list.add(0, source);
                }
                ArrayList<List<GenCommonBase>> arrayList = connections;
                return arrayList;
            }
            finally {
                this.stopVisiting(source);
            }
        }

        private boolean isVisiting(GenCommonBase node) {
            return this.myVisiting.contains(node);
        }

        private void startVisiting(GenCommonBase node) {
            this.myVisiting.add(node);
        }

        private void stopVisiting(GenCommonBase node) {
            this.myVisiting.remove(node);
        }

        protected Iterable<GenCommonBase> getPath() {
            return this.myVisiting;
        }

        private boolean isConnectionFound(GenCommonBase source, GenCommonBase target) {
            return this.myVisiting.size() > 0 && source == target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildConnectionFinder
    extends AbstractConnectionFinder {
        private ChildConnectionFinder() {
        }

        @Override
        protected Collection<GenCommonBase> getConnectedNodes(GenCommonBase source) {
            ArrayList<GenCommonBase> children = new ArrayList<GenCommonBase>();
            if (source instanceof GenContainerBase) {
                children.addAll((Collection<GenCommonBase>)((GenContainerBase)source).getContainedNodes());
            }
            if (source instanceof GenDiagram) {
                children.addAll((Collection<GenCommonBase>)((GenDiagram)source).getLinks());
            }
            if (source instanceof GenNode) {
                children.addAll((Collection<GenCommonBase>)((GenNode)source).getCompartments());
                children.addAll((Collection<GenCommonBase>)((GenNode)source).getLabels());
            }
            if (source instanceof GenLink) {
                children.addAll((Collection<GenCommonBase>)((GenLink)source).getLabels());
            }
            return children;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkedConnectionFinder
    extends AbstractConnectionFinder {
        private GenDiagram myDiagram;
        private boolean myIsInLinkDirection;

        public LinkedConnectionFinder(GenDiagram diagram, boolean inLinkDirection) {
            this.myDiagram = diagram;
            this.myIsInLinkDirection = inLinkDirection;
        }

        @Override
        protected Collection<GenCommonBase> getConnectedNodes(GenCommonBase source) {
            if (source instanceof GenNode) {
                return this.getPotentiallyConnectedLinks((GenNode)source);
            }
            if (source instanceof GenLink) {
                return this.getPotentiallyConnectedNodes((GenLink)source);
            }
            return Collections.emptyList();
        }

        private Collection<GenCommonBase> getPotentiallyConnectedLinks(GenNode node) {
            for (GenCommonBase nextPathElement : this.getPath()) {
                if (!(nextPathElement instanceof GenLink)) continue;
                return Collections.emptyList();
            }
            ArrayList<GenCommonBase> potentialLinks = new ArrayList<GenCommonBase>();
            block1: for (GenLink nextLink : this.myDiagram.getLinks()) {
                if (nextLink.getModelFacet() == null) {
                    potentialLinks.add(nextLink);
                    continue;
                }
                EList genClasses = this.myIsInLinkDirection ? nextLink.getModelFacet().getSourceTypes() : nextLink.getModelFacet().getTargetTypes();
                for (GenClass nextGenClass : genClasses) {
                    if (!nextGenClass.getEcoreClass().isSuperTypeOf(node.getDomainMetaClass().getEcoreClass())) continue;
                    potentialLinks.add(nextLink);
                    continue block1;
                }
            }
            return potentialLinks;
        }

        private Collection<GenCommonBase> getPotentiallyConnectedNodes(GenLink link) {
            ArrayList<GenCommonBase> potentialNodes = new ArrayList<GenCommonBase>();
            if (link.getModelFacet() == null) {
                potentialNodes.addAll((Collection<GenCommonBase>)this.myDiagram.getAllNodes());
            } else {
                EList genClasses = this.myIsInLinkDirection ? link.getModelFacet().getTargetTypes() : link.getModelFacet().getSourceTypes();
                block0: for (GenNode nextNode : this.myDiagram.getAllNodes()) {
                    for (GenClass genClass : genClasses) {
                        if (!genClass.getEcoreClass().isSuperTypeOf(nextNode.getDomainMetaClass().getEcoreClass())) continue;
                        potentialNodes.add(nextNode);
                        continue block0;
                    }
                }
            }
            return potentialNodes;
        }
    }
}

