/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.properties.descriptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gmf.runtime.common.ui.services.properties.ICompositePropertySource;
import org.eclipse.gmf.runtime.common.ui.services.properties.descriptors.ICompositeSourcePropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class CompositePropertySource
implements ICompositePropertySource {
    private Object object = null;
    private ICompositePropertySource enclosed = null;
    private String category = null;
    private Map propertyDescriptors = new HashMap();

    public CompositePropertySource(Object object) {
        this.object = object;
    }

    public CompositePropertySource(Object object, String category) {
        this(object);
        this.category = category;
    }

    @Override
    public void addPropertySource(ICompositePropertySource source) {
        assert (this != source) : "self is not allowed - this will result in stack overflows";
        if (this.enclosed == null) {
            this.enclosed = source;
        } else {
            this.enclosed.addPropertySource(source);
        }
    }

    public void addPropertyDescriptor(ICompositeSourcePropertyDescriptor descriptor) {
        if (!this.isPropertySet(descriptor.getId())) {
            if (descriptor.getCategory() == null) {
                descriptor.setCategory(this.getCategory());
            }
            this.getLocalDescriptors().put(descriptor.getId(), descriptor);
        }
    }

    public Object getEditableValue() {
        if (this.getObject() == null && this.enclosed != null) {
            return this.enclosed.getEditableValue();
        }
        return this.getObject();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList list = new ArrayList(this.getLocalDescriptors().values());
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[list.size()];
        System.arraycopy(list.toArray(), 0, descriptors, 0, list.size());
        if (this.enclosed != null) {
            IPropertyDescriptor[] enclosedDecriptors = this.enclosed.getPropertyDescriptors();
            IPropertyDescriptor[] all = new IPropertyDescriptor[descriptors.length + enclosedDecriptors.length];
            System.arraycopy(enclosedDecriptors, 0, all, 0, enclosedDecriptors.length);
            System.arraycopy(descriptors, 0, all, enclosedDecriptors.length, descriptors.length);
            return all;
        }
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        ICompositeSourcePropertyDescriptor descriptor = (ICompositeSourcePropertyDescriptor)this.getLocalDescriptors().get(id);
        return descriptor != null ? descriptor.getPropertyValue() : (this.enclosed != null ? this.enclosed.getPropertyValue(id) : null);
    }

    public boolean isPropertySet(Object id) {
        return this.getLocalDescriptors().containsKey(id) ? true : (this.enclosed != null ? this.enclosed.isPropertySet(id) : false);
    }

    public void resetPropertyValue(Object id) {
        ICompositeSourcePropertyDescriptor descriptor = (ICompositeSourcePropertyDescriptor)this.getLocalDescriptors().get(id);
        if (descriptor != null) {
            descriptor.resetPropertyValue();
        } else if (this.enclosed != null) {
            this.enclosed.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object propertyId, Object value) {
        ICompositeSourcePropertyDescriptor descriptor = (ICompositeSourcePropertyDescriptor)this.getLocalDescriptors().get(propertyId);
        if (descriptor != null) {
            descriptor.setPropertyValue(value);
        } else if (this.enclosed != null) {
            this.enclosed.setPropertyValue(propertyId, value);
        }
    }

    public String getCategory() {
        return this.category;
    }

    public Object getObject() {
        return this.object;
    }

    protected Map getLocalDescriptors() {
        return this.propertyDescriptors;
    }

    protected ICompositePropertySource getEnclosed() {
        return this.enclosed;
    }
}

