/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.ruler;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.GuideMap;
import org.eclipse.gmf.runtime.notation.Alignment;
import org.eclipse.gmf.runtime.notation.Guide;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramGuide {
    private static DiagramGuide self = null;
    private WeakHashMap guideMap = new WeakHashMap();

    private DiagramGuide() {
    }

    public static DiagramGuide getInstance() {
        if (self == null) {
            self = new DiagramGuide();
        }
        return self;
    }

    public List getViews() {
        return new ArrayList(this.guideMap.keySet());
    }

    public Guide getHorizontalGuide(View part) {
        GuideMap theMap = (GuideMap)this.guideMap.get(part);
        if (theMap == null) {
            return null;
        }
        return theMap.getHorizontal();
    }

    public int getHorizontalAlignment(View part) {
        Guide guide = this.getHorizontalGuide(part);
        if (guide == null) {
            return -2;
        }
        EMap nodes = guide.getNodeMap();
        Alignment align = (Alignment)nodes.get((Object)part);
        if (align != null) {
            switch (align.getValue()) {
                case 0: 
                case 3: {
                    return -1;
                }
                case 2: {
                    return 0;
                }
                case 1: 
                case 4: {
                    return 1;
                }
            }
        }
        return -2;
    }

    public int getVerticalAlignment(View part) {
        Guide guide = this.getVerticalGuide(part);
        if (guide == null) {
            return -2;
        }
        EMap nodes = guide.getNodeMap();
        Alignment align = (Alignment)nodes.get((Object)part);
        if (align != null) {
            switch (align.getValue()) {
                case 0: 
                case 3: {
                    return -1;
                }
                case 2: {
                    return 0;
                }
                case 1: 
                case 4: {
                    return 1;
                }
            }
        }
        return -2;
    }

    public Guide getVerticalGuide(View part) {
        GuideMap theMap = (GuideMap)this.guideMap.get(part);
        if (theMap == null) {
            return null;
        }
        return theMap.getVertical();
    }

    public void setHorizontalGuide(View view, Guide toSet) {
        GuideMap theMap = (GuideMap)this.guideMap.get(view);
        if (theMap == null && toSet != null) {
            theMap = new GuideMap();
            this.guideMap.put(view, theMap);
        }
        if (theMap != null) {
            theMap.setHorizontal(toSet);
        }
        this.checkAndRemove(view, theMap);
    }

    public void setVerticalGuide(View view, Guide toSet) {
        GuideMap theMap = (GuideMap)this.guideMap.get(view);
        if (theMap == null && toSet != null) {
            theMap = new GuideMap();
            this.guideMap.put(view, theMap);
        }
        if (theMap != null) {
            theMap.setVertical(toSet);
        }
        this.checkAndRemove(view, theMap);
    }

    private void checkAndRemove(View view, GuideMap map) {
        if (map != null && map.getHorizontal() == null && map.getVertical() == null) {
            this.guideMap.remove(view);
        }
    }
}

