/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.core.internal.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.gmf.runtime.common.core.util.Proxy;
import org.eclipse.gmf.runtime.common.core.util.StringUtil;

public class StringUtilTest
extends TestCase {
    private final String src = "I am writing a test case with the word a.\nThe word a is a very important word because I want to replace all instances of it.  It is a word.  And I must test case sensitive replaces too, okay?";

    public static void main(String[] args) {
        TestRunner.run((Test)StringUtilTest.suite());
    }

    public static Test suite() {
        return new TestSuite(StringUtilTest.class);
    }

    public StringUtilTest(String name) {
        super(name);
    }

    public void test_Replace() {
        StringUtilTest.assertTrue((boolean)StringUtil.replace((String)"I am writing a test case with the word a.\nThe word a is a very important word because I want to replace all instances of it.  It is a word.  And I must test case sensitive replaces too, okay?", (String)"a", (String)"a a", (boolean)false).equals("I a am writing a test case with the word a.\nThe word a is a very important word because I want to replace all instances of it.  It is a word.  And I must test case sensitive replaces too, okay?"));
        StringUtilTest.assertTrue((boolean)StringUtil.replaceAll((String)"I am writing a test case with the word a.\nThe word a is a very important word because I want to replace all instances of it.  It is a word.  And I must test case sensitive replaces too, okay?", (String)"a", (String)"a a", (boolean)true).equals("I a am writing a a test ca ase with the word a a.\nThe word a a is a a very importa ant word beca ause I wa ant to repla ace a all insta ances of it.  It is a a word.  And I must test ca ase sensitive repla aces too, oka ay?"));
    }

    public void test_ReplaceWholeWords() {
        StringUtilTest.assertTrue((boolean)StringUtil.replaceWholeWords((String)"I am writing a test case with the word a.\nThe word a is a very important word because I want to replace all instances of it.  It is a word.  And I must test case sensitive replaces too, okay?", (String)"a", (String)"a a", (boolean)true).equals("I am writing a a test case with the word a.\nThe word a is a very important word because I want to replace all instances of it.  It is a word.  And I must test case sensitive replaces too, okay?"));
        StringUtilTest.assertTrue((boolean)StringUtil.replaceAllWholeWords((String)"I am writing a test case with the word a.\nThe word a is a very important word because I want to replace all instances of it.  It is a word.  And I must test case sensitive replaces too, okay?", (String)"a", (String)"a a", (boolean)false).equals("I am writing a a test case with the word a a.\nThe word a a is a a very important word because I want to replace all instances of it.  It is a a word.  And I must test case sensitive replaces too, okay?"));
    }

    public void test_dgdEncodeURL() {
        StringUtilTest.assertTrue((boolean)StringUtil.encodeURL((String)"http://www.ibm.ca/").equals("http://www.ibm.ca/"));
        StringUtilTest.assertTrue((boolean)StringUtil.encodeURL((String)"http://www.ibm.ca").equals("http://www.ibm.ca"));
        StringUtilTest.assertTrue((boolean)StringUtil.encodeURL((String)"C:\\dir\\sub").equals("C:\\dir\\sub"));
        StringUtilTest.assertTrue((boolean)StringUtil.encodeURL((String)"Fil\u00e9name with spaces.doc").equals("Fil\u00e9name with spaces.doc"));
        StringUtilTest.assertTrue((boolean)StringUtil.encodeURL((String)"http://www.ibm.com/Search/?q=rational&v=14&lang=en&cc=ca").equals("http://www.ibm.com/Search/?q=rational&v=14&lang=en&cc=ca"));
        StringUtilTest.assertTrue((boolean)StringUtil.encodeURL((String)"http://www.ibm.com/Search/?q=\u00e9\u00e7\u00e5\u00e2\u00e8&v=14&lang=en&cc=ca").equals("http://www.ibm.com/Search/?q=%C3%A9%C3%A7%C3%A5%C3%A2%C3%A8&v=14&lang=en&cc=ca"));
        StringUtilTest.assertTrue((boolean)StringUtil.encodeURL((String)"http://www.ibm.com/Search/?q=\u00e9\u00e7\u00e5\u00e2\u00e8%3d&v=14&lang=en&cc=ca").equals("http://www.ibm.com/Search/?q=%C3%A9%C3%A7%C3%A5%C3%A2%C3%A8%3d&v=14&lang=en&cc=ca"));
        StringUtilTest.assertTrue((boolean)StringUtil.encodeURL((String)"http://www.ibm.com/Search/?q=\u00e9\u00e7\u00e5\u00e2\u00e8%a&v=14&lang=en&cc=ca").equals("http://www.ibm.com/Search/?q=%C3%A9%C3%A7%C3%A5%C3%A2%C3%A8%25a&v=14&lang=en&cc=ca"));
        StringUtilTest.assertTrue((boolean)StringUtil.encodeURL((String)"http://www.ibm.com/Search/?q=\u00e9\u00e7\u00e5\u00e2\u00e8%fg%a&v=14&lang=en&cc=ca").equals("http://www.ibm.com/Search/?q=%C3%A9%C3%A7%C3%A5%C3%A2%C3%A8%25fg%25a&v=14&lang=en&cc=ca"));
        StringUtilTest.assertTrue((boolean)StringUtil.encodeURL((String)"http://www.ibm.com/Search/?q=\u00e9\u00e7\u00e5\u00e2\u00e8%%a&v=14&lang=en&cc=ca").equals("http://www.ibm.com/Search/?q=%C3%A9%C3%A7%C3%A5%C3%A2%C3%A8%25%25a&v=14&lang=en&cc=ca"));
        StringUtilTest.assertTrue((boolean)StringUtil.encodeURL((String)"http://www.ibm.com/Search/?q=\u00e9\u00e7\u00e5\u00e2\u00e8%&v=14&lang=en&cc=ca").equals("http://www.ibm.com/Search/?q=%C3%A9%C3%A7%C3%A5%C3%A2%C3%A8%25&v=14&lang=en&cc=ca"));
    }

    protected static class Fixture
    extends Proxy {
        protected Fixture(Object realObject) {
            super(realObject);
        }
    }
}

