/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.xtend.ast;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateExtensionStatement
extends Extension {
    private final Expression expression;
    private final String returnVarName;
    private final Map<List<Object>, Object> cache = new HashMap<List<Object>, Object>();

    public CreateExtensionStatement(int start, int end, int line, int startOffset, int endOffset, Identifier name, Identifier returnType, Identifier rtName, List<DeclaredParameter> params, Expression expr, boolean isPrivate) {
        super(start, end, line, startOffset, endOffset, name, returnType, params, true, isPrivate);
        this.expression = expr;
        this.returnVarName = rtName != null ? rtName.getValue() : "this";
    }

    @Override
    protected EClassifier internalGetReturnType(EClassifier[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        return ctx.getTypeForName(this.getReturnTypeIdentifier().getValue());
    }

    @Override
    public void analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier t = ctx.getTypeForName(this.returnType.getValue());
        if (t == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.TYPE_NOT_FOUND, "Couldn't resolve type " + this.returnType + "!", this.returnType));
            return;
        }
        ctx = ctx.cloneWithVariable(new Variable(this.returnVarName, t));
        this.expression.analyze(ctx, issues);
    }

    @Override
    public Object evaluate(Object[] parameters, ExecutionContext ctx) {
        List<Object> l = Arrays.asList(parameters);
        if (this.cache.containsKey(l)) {
            return this.cache.get(l);
        }
        EClassifier t = (ctx = ctx.cloneWithResource(this.getExtensionFile())).getTypeForName(this.returnType.getValue());
        if (t == null) {
            throw new EvaluationException("Couldn't resolve type " + this.returnType, (SyntaxElement)this.returnType);
        }
        Object inst = BuiltinMetaModel.newInstance(t);
        this.cache.put(l, inst);
        ctx = ctx.cloneWithVariable(new Variable(this.returnVarName, inst));
        int i = 0;
        while (i < parameters.length) {
            Object object = parameters[i];
            ctx = ctx.cloneWithVariable(new Variable(this.getParameterNames().get(i), object));
            ++i;
        }
        this.expression.evaluate(ctx);
        return inst;
    }

    @Override
    protected Object evaluateInternal(Object[] parameters, ExecutionContext ctx) {
        throw new UnsupportedOperationException();
    }
}

