/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewRefactorHelper;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.requests.ApplyAppearancePropertiesRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangeChildPropertyValueRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class PropertyHandlerEditPolicy
extends AbstractEditPolicy {
    private static final String APPLY_APPEARANCE_PROPERTIES_UNDO_COMMAND_NAME = "Apply appearance properties";

    public Command getCommand(Request request) {
        if (!this.understandsRequest(request)) {
            return null;
        }
        if (request.getType().equals("property_change") || request.getType().equals("child_property_change")) {
            EditPart ep = this.getHost();
            if (ep instanceof IGraphicalEditPart) {
                View view = ((IGraphicalEditPart)ep).getNotationView();
                ChangePropertyValueRequest cpvr = (ChangePropertyValueRequest)request;
                if (request.getType().equals("child_property_change")) {
                    view = ViewUtil.getChildBySemanticHint((View)view, (String)((ChangeChildPropertyValueRequest)cpvr).getNotationViewType());
                }
                if (view != null && ViewUtil.isPropertySupported((View)view, (Object)cpvr.getPropertyID())) {
                    return new ICommandProxy((ICommand)new SetPropertyCommand(this.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)view), cpvr.getPropertyID(), cpvr.getPropertyName(), ((ChangePropertyValueRequest)request).getValue()));
                }
            }
        } else if (request.getType().equals("show_all_compartments")) {
            EditPart ep = this.getHost();
            if (ep instanceof TopGraphicEditPart) {
                TopGraphicEditPart topEP = (TopGraphicEditPart)ep;
                List resizableViews = topEP.getResizableNotationViews();
                if (resizableViews.isEmpty()) {
                    return null;
                }
                ChangePropertyValueRequest cpvr = (ChangePropertyValueRequest)request;
                CompositeCommand compositeCommand = new CompositeCommand(cpvr.getPropertyName());
                for (View childView : resizableViews) {
                    if (!ViewUtil.isPropertySupported((View)childView, (Object)cpvr.getPropertyID())) continue;
                    compositeCommand.compose((IUndoableOperation)new SetPropertyCommand(this.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)childView), cpvr.getPropertyID(), cpvr.getPropertyName(), ((ChangePropertyValueRequest)request).getValue()));
                }
                return new ICommandProxy((ICommand)compositeCommand);
            }
        } else if (request instanceof ApplyAppearancePropertiesRequest && this.getHost() instanceof IGraphicalEditPart) {
            final ApplyAppearancePropertiesRequest aapr = (ApplyAppearancePropertiesRequest)request;
            final IGraphicalEditPart gep = (IGraphicalEditPart)this.getHost();
            final ViewRefactorHelper vrh = new ViewRefactorHelper(gep.getDiagramPreferencesHint());
            final List exclusions = this.getStyleExclusionsForCopyAppearance();
            AbstractTransactionalCommand viewStyleCommand = new AbstractTransactionalCommand(this.getEditingDomain(), APPLY_APPEARANCE_PROPERTIES_UNDO_COMMAND_NAME, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    vrh.copyViewAppearance(aapr.getViewToCopyFrom(), gep.getNotationView(), exclusions);
                    return CommandResult.newOKCommandResult();
                }
            };
            return new ICommandProxy((ICommand)viewStyleCommand);
        }
        return null;
    }

    protected List getStyleExclusionsForCopyAppearance() {
        ArrayList<EClass> exclusions = new ArrayList<EClass>();
        exclusions.add(NotationPackage.eINSTANCE.getDescriptionStyle());
        exclusions.add(NotationPackage.eINSTANCE.getImageBufferStyle());
        return exclusions;
    }

    public boolean understandsRequest(Request request) {
        if (request.getType().equals("property_change") || request.getType().equals("child_property_change") || request.getType().equals("show_all_compartments")) {
            return true;
        }
        if (request instanceof ApplyAppearancePropertiesRequest && this.getHost() instanceof IGraphicalEditPart) {
            return true;
        }
        return super.understandsRequest(request);
    }

    public EditPart getTargetEditPart(Request request) {
        if (!this.understandsRequest(request)) {
            return null;
        }
        if (request.getType().equals("property_change") || request.getType().equals("child_property_change") || request.getType().equals("show_all_compartments")) {
            return this.getHost();
        }
        if (request instanceof ApplyAppearancePropertiesRequest) {
            return this.getHost();
        }
        return super.getTargetEditPart(request);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }
}

