/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.io.IOException;
import java.io.Reader;
import lpg.lpgjavaruntime.LexStream;
import org.eclipse.gmf.internal.xpand.ast.Template;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.parser.XpandLexer;
import org.eclipse.gmf.internal.xpand.parser.XpandParser;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.StreamConverter;

public class XpandResourceParser {
    public XpandResource parse(Reader source, String qualifiedTemplateName) throws IOException, ParserException {
        Template tpl = null;
        XpandParser parser = null;
        XpandLexer scanner = null;
        char[] buffer = new StreamConverter().toCharArray(source);
        try {
            scanner = new XpandLexer(buffer, qualifiedTemplateName);
            parser = new XpandParser((LexStream)scanner);
            scanner.lexer(parser);
            tpl = parser.parser();
        }
        catch (Exception exception) {
            ParserException.ErrorLocationInfo[] errors = XpandResourceParser.extractErrors(scanner, parser);
            if (errors.length == 0) {
                throw new IOException("Unexpected exception while parsing");
            }
            throw new ParserException(qualifiedTemplateName, errors);
        }
        if (tpl != null) {
            tpl.setFullyQualifiedName(qualifiedTemplateName);
            return tpl;
        }
        ParserException.ErrorLocationInfo[] errors = XpandResourceParser.extractErrors(scanner, parser);
        assert (errors.length > 0) : "otherwise, no reason not to get template";
        throw new ParserException(qualifiedTemplateName, errors);
    }

    private static ParserException.ErrorLocationInfo[] extractErrors(XpandLexer scanner, XpandParser parser) {
        ParserException.ErrorLocationInfo[] e1 = scanner.getErrors();
        ParserException.ErrorLocationInfo[] e2 = parser.getErrors();
        ParserException.ErrorLocationInfo[] res = new ParserException.ErrorLocationInfo[e1.length + e2.length];
        System.arraycopy(e1, 0, res, 0, e1.length);
        System.arraycopy(e2, 0, res, e1.length, e2.length);
        return res;
    }
}

