/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.migration.MigrationExecutionContext;
import org.eclipse.gmf.internal.xpand.migration.OperationCallTrace;
import org.eclipse.gmf.internal.xpand.xtend.ast.JavaExtensionStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExtensionDescriptor {
    public static final String NATIVE_LIBRARY_CLASS_PREFIX = "Native";
    private String extensionName;
    private String className;
    private String methodName;
    private EClassifier returnType;
    private List<EClassifier> parameterTypes = new ArrayList<EClassifier>();
    private List<String> parameterNames = new ArrayList<String>();
    private List<String> javaParameterTypes = new ArrayList<String>();
    private boolean staticQvtoCall;

    public static String getNativeLibraryName(JavaExtensionStatement extension) {
        String name = extension.getExtensionFile().getFullyQualifiedName();
        int delimiterIndex = name.lastIndexOf("::");
        if (delimiterIndex < 0) {
            return NATIVE_LIBRARY_CLASS_PREFIX + name;
        }
        String packageName = name.substring(0, delimiterIndex);
        name = name.substring(delimiterIndex + "::".length());
        return String.valueOf(packageName) + "::" + NATIVE_LIBRARY_CLASS_PREFIX + name;
    }

    public JavaExtensionDescriptor(JavaExtensionStatement javaExtension, MigrationExecutionContext ctx) {
        this.extensionName = javaExtension.getName();
        this.className = javaExtension.getJavaType().getValue();
        this.methodName = javaExtension.getJavaMethod().getValue();
        assert (javaExtension.getReturnTypeIdentifier() != null);
        this.returnType = ctx.getTypeForName(javaExtension.getReturnTypeIdentifier().getValue());
        for (DeclaredParameter parameter : javaExtension.getFormalParameters()) {
            this.parameterTypes.add(ctx.getTypeForName(parameter.getType().getValue()));
            this.parameterNames.add(parameter.getName().getValue());
        }
        assert (javaExtension.getFormalParameters().size() == javaExtension.getJavaParameterTypes().size());
        for (Identifier paramType : javaExtension.getJavaParameterTypes()) {
            this.javaParameterTypes.add(paramType.getValue());
        }
        this.staticQvtoCall = OperationCallTrace.isStaticQvtoCall(ctx, javaExtension);
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public EClassifier getReturnType() {
        return this.returnType;
    }

    public List<EClassifier> getParameterTypes() {
        return this.parameterTypes;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public List<String> getJavaParameterTypes() {
        return this.javaParameterTypes;
    }

    public boolean isStaticQvtoCall() {
        return this.staticQvtoCall;
    }
}

