/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.figures;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.swt.graphics.Path;

public class NoteFigure
extends DefaultSizeNodeFigure
implements IPolygonAnchorableFigure {
    private boolean diagramLinkMode = false;
    private boolean withDanglingCorner = true;
    public static final int CLIP_HEIGHT_DP = 12;
    public static final int MARGIN_DP = 5;
    public static final int CLIP_MARGIN_DP = 14;

    public NoteFigure(int width, int height, Insets insets) {
        super(width, height);
        this.setBorder((Border)new NoteFigureBorder(insets));
        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout(){

            public Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
                Insets aNinsets = container.getInsets();
                Dimension aMminSize = new Dimension(0, 0);
                return this.transposer.t(aMminSize).expand(aNinsets.getWidth(), aNinsets.getHeight()).union(this.getBorderPreferredSize(container));
            }
        };
        layout.setMinorAlignment(1);
        layout.setSpacing(insets.top);
        this.setLayoutManager((LayoutManager)layout);
    }

    private int getClipHeight() {
        return MapModeUtil.getMapMode((IFigure)this).DPtoLP(12);
    }

    private int getClipWidth() {
        return this.getClipHeight() + MapModeUtil.getMapMode((IFigure)this).DPtoLP(1);
    }

    protected PointList getPointList(Rectangle r) {
        PointList p = new PointList();
        p.addPoint(r.x, r.y);
        if (!this.isDiagramLinkMode()) {
            p.addPoint(r.x + r.width - this.getClipWidth(), r.y);
            p.addPoint(r.x + r.width - 1, r.y + this.getClipHeight());
        } else {
            p.addPoint(r.x + r.width - 1, r.y);
        }
        p.addPoint(r.x + r.width - 1, r.y + r.height - 1);
        p.addPoint(r.x, r.y + r.height - 1);
        p.addPoint(r.x, r.y);
        return p;
    }

    protected void paintBorder(Graphics g) {
        if (!this.isDiagramLinkMode()) {
            this.getBorder().paint((IFigure)this, g, NO_INSETS);
        }
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        this.applyTransparency(g);
        if (!this.isUsingGradient()) {
            g.fillPath(this.getPath());
        } else {
            this.fillGradient(g);
        }
    }

    public boolean setDiagramLinkMode(boolean diagramLinkMode) {
        boolean bOldDiagramLinkMode = this.diagramLinkMode;
        ConstrainedToolbarLayout layout = (ConstrainedToolbarLayout)this.getLayoutManager();
        if (diagramLinkMode) {
            layout.setMinorAlignment(0);
        } else {
            layout.setMinorAlignment(1);
        }
        this.diagramLinkMode = diagramLinkMode;
        return bOldDiagramLinkMode;
    }

    public boolean isDiagramLinkMode() {
        return this.diagramLinkMode;
    }

    public PointList getPolygonPoints() {
        return this.getPointList(this.getBounds());
    }

    protected Path getPath() {
        Path path = new Path(null);
        PointList pl = this.getPointList(this.getBounds().getCopy().shrink(this.getLineWidth() / 2, this.getLineWidth() / 2));
        path.moveTo((float)pl.getPoint((int)0).x, (float)pl.getPoint((int)0).y);
        int i = 0;
        while (i < pl.size()) {
            path.lineTo((float)pl.getPoint((int)i).x, (float)pl.getPoint((int)i).y);
            ++i;
        }
        path.close();
        return path;
    }

    public class NoteFigureBorder
    extends AbstractBorder {
        private Insets margin;

        NoteFigureBorder(Insets insets) {
            this.margin = insets;
        }

        public Insets getMargin() {
            return this.margin;
        }

        public void setMargin(Insets margin) {
            this.margin = margin;
        }

        public Insets getInsets(IFigure figure) {
            NoteFigure noteFigure = (NoteFigure)figure;
            int width = noteFigure.getLineWidth();
            return new Insets(width + this.margin.top, width + this.margin.left, width + this.margin.bottom, width + this.margin.right);
        }

        public void paint(IFigure figure, Graphics g, Insets insets) {
            NoteFigure noteFigure = (NoteFigure)figure;
            Rectangle r = noteFigure.getBounds().getCopy();
            r.shrink(noteFigure.getLineWidth() / 2, noteFigure.getLineWidth() / 2);
            PointList p = noteFigure.getPointList(r);
            p.addPoint(r.x, r.y - noteFigure.getLineWidth() / 2);
            g.setLineWidth(noteFigure.getLineWidth());
            g.setLineStyle(noteFigure.getLineStyle());
            g.drawPolyline(p);
            if (NoteFigure.this.withDanglingCorner) {
                PointList corner = new PointList();
                corner.addPoint(r.x + r.width - NoteFigure.this.getClipWidth(), r.y);
                corner.addPoint(r.x + r.width - NoteFigure.this.getClipWidth(), r.y + NoteFigure.this.getClipHeight());
                corner.addPoint(r.x + r.width, r.y + NoteFigure.this.getClipHeight());
                g.drawPolyline(corner);
            }
        }
    }
}

