/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.ui.services.action.contributionitem;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.ContributionItemService;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.tests.runtime.common.ui.services.action.contributionitem.ContributionPolicy;
import org.eclipse.gmf.tests.runtime.common.ui.services.action.contributionitem.MyWorkbenchPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.services.IServiceLocator;

public class ContributionItemServiceTests
extends TestCase {
    private static final String MY_ACTIVITY_ID = "MyActivityID";
    private static final String MY_ACTIVITY_ID_OF_SPECIFIC_ENTRIES = "MyActivityIDOfSpecificEntries";

    public ContributionItemServiceTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ContributionItemServiceTests.suite());
    }

    public static Test suite() {
        return new TestSuite(ContributionItemServiceTests.class);
    }

    protected void setUp() throws Exception {
        this.toggleActivity(MY_ACTIVITY_ID, true);
        this.toggleActivity(MY_ACTIVITY_ID_OF_SPECIFIC_ENTRIES, true);
    }

    public void testCapabilityFiltering() throws Exception {
        String EDITOR1 = "editor1";
        String EDITOR2 = "editor2";
        MyWorkbenchPartDescriptor editor1Descriptor = new MyWorkbenchPartDescriptor(EDITOR1);
        MyWorkbenchPartDescriptor editor2Descriptor = new MyWorkbenchPartDescriptor(EDITOR2);
        MyActionBars editor1ActionBars = new MyActionBars();
        MyActionBars editor2ActionBars = new MyActionBars();
        this.toggleActivity(MY_ACTIVITY_ID, false);
        ContributionItemService.getInstance().contributeToActionBars((IActionBars)editor1ActionBars, (IWorkbenchPartDescriptor)editor1Descriptor);
        this.validateActionBars(editor1ActionBars, false, false);
        ContributionItemService.getInstance().contributeToActionBars((IActionBars)editor2ActionBars, (IWorkbenchPartDescriptor)editor2Descriptor);
        this.validateActionBars(editor2ActionBars, false, false);
        this.toggleActivity(MY_ACTIVITY_ID, true);
        ContributionItemService.getInstance().updateActionBars((IActionBars)editor1ActionBars, (IWorkbenchPartDescriptor)editor1Descriptor);
        this.validateActionBars(editor1ActionBars, true, true);
        this.validateActionBars(editor2ActionBars, false, true);
        ContributionItemService.getInstance().updateActionBars((IActionBars)editor2ActionBars, (IWorkbenchPartDescriptor)editor2Descriptor);
        this.validateActionBars(editor1ActionBars, true, true);
        this.validateActionBars(editor2ActionBars, true, true);
        int expectedLength = editor2ActionBars.getToolBarManager().getItems().length;
        IContributionItem expectedItem0 = editor2ActionBars.getToolBarManager().getItems()[0];
        IContributionItem expectedItem2 = editor2ActionBars.getToolBarManager().getItems()[2];
        ContributionItemService.getInstance().updateActionBars((IActionBars)editor2ActionBars, (IWorkbenchPartDescriptor)editor2Descriptor);
        ContributionItemServiceTests.assertEquals((int)expectedLength, (int)editor2ActionBars.getToolBarManager().getItems().length);
        ContributionItemServiceTests.assertEquals((Object)expectedItem0, (Object)editor2ActionBars.getToolBarManager().getItems()[0]);
        ContributionItemServiceTests.assertEquals((Object)expectedItem2, (Object)editor2ActionBars.getToolBarManager().getItems()[2]);
        this.validateActionBars(editor1ActionBars, true, true);
        this.validateActionBars(editor2ActionBars, true, true);
        this.toggleActivity(MY_ACTIVITY_ID, false);
        this.validateActionBars(editor1ActionBars, true, false);
        this.validateActionBars(editor2ActionBars, true, false);
        this.toggleActivity(MY_ACTIVITY_ID, true);
        this.validateActionBars(editor1ActionBars, true, true);
        this.validateActionBars(editor2ActionBars, true, true);
    }

    public void testCapabilityFilteringOfSpecificEntries() throws Exception {
        String EDITOR1 = "editor1";
        MyWorkbenchPartDescriptor editor1Descriptor = new MyWorkbenchPartDescriptor(EDITOR1);
        MyActionBars editor1ActionBars = new MyActionBars();
        this.toggleActivity(MY_ACTIVITY_ID_OF_SPECIFIC_ENTRIES, false);
        ContributionItemService.getInstance().contributeToActionBars((IActionBars)editor1ActionBars, (IWorkbenchPartDescriptor)editor1Descriptor);
        this.validateActionBars(editor1ActionBars, true, false);
        this.toggleActivity(MY_ACTIVITY_ID_OF_SPECIFIC_ENTRIES, true);
        ContributionItemService.getInstance().updateActionBars((IActionBars)editor1ActionBars, (IWorkbenchPartDescriptor)editor1Descriptor);
        this.validateActionBars(editor1ActionBars, true, true);
    }

    public void testPolicy_ClassAttribute() throws Exception {
        this.toggleActivity(MY_ACTIVITY_ID, true);
        ContributionItemService.getInstance().contributeToPopupMenu((IMenuManager)new MenuManager(), (IWorkbenchPart)new MyWorkBenchPart());
        ContributionItemServiceTests.assertTrue((String)"The policy should be called at least once", (ContributionPolicy.getCallCount() >= 1 ? 1 : 0) != 0);
    }

    private void toggleActivity(String activityID, boolean enabled) {
        boolean changeMade;
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        HashSet<String> enabledActivityIds = new HashSet<String>(workbenchActivitySupport.getActivityManager().getEnabledActivityIds());
        boolean bl = changeMade = enabled ? enabledActivityIds.add(activityID) : enabledActivityIds.remove(activityID);
        if (changeMade) {
            workbenchActivitySupport.setEnabledActivityIds(enabledActivityIds);
        }
    }

    private void validateActionBars(IActionBars actionBars, boolean provider2Contributed, boolean provider2Visible) {
        ContributionItemServiceTests.assertNotNull((Object)actionBars.getToolBarManager().find("action1"));
        if (provider2Contributed) {
            ContributionItemServiceTests.assertNotNull((Object)actionBars.getToolBarManager().find("action2"));
            ContributionItemServiceTests.assertNotNull((Object)((IMenuManager)actionBars.getToolBarManager().find("menu1")).find("menu2"));
        } else {
            ContributionItemServiceTests.assertNull((Object)actionBars.getToolBarManager().find("action2"));
            ContributionItemServiceTests.assertNull((Object)((IMenuManager)actionBars.getToolBarManager().find("menu1")).find("menu2"));
        }
        if (provider2Contributed) {
            this.validateVisibility(actionBars.getMenuManager().getItems(), provider2Visible);
            this.validateVisibility(actionBars.getToolBarManager().getItems(), provider2Visible);
        }
    }

    private void validateVisibility(IContributionItem[] items, boolean visibility) {
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            if (item.getId().equals("action2")) {
                ContributionItemServiceTests.assertEquals((boolean)visibility, (boolean)item.isVisible());
            }
            if (item instanceof IMenuManager) {
                this.validateVisibility(((IMenuManager)item).getItems(), visibility);
            }
            ++i;
        }
    }

    class MyActionBars
    implements IActionBars {
        IToolBarManager myToolBarManager = new ToolBarManager();
        IMenuManager myMenuManager = new MenuManager();

        MyActionBars() {
        }

        public void clearGlobalActionHandlers() {
        }

        public IAction getGlobalActionHandler(String actionId) {
            return null;
        }

        public IMenuManager getMenuManager() {
            return this.myMenuManager;
        }

        public IStatusLineManager getStatusLineManager() {
            return null;
        }

        public IToolBarManager getToolBarManager() {
            return this.myToolBarManager;
        }

        public void setGlobalActionHandler(String actionId, IAction handler) {
        }

        public void updateActionBars() {
        }

        public IServiceLocator getServiceLocator() {
            return null;
        }
    }

    class MySelection
    implements ISelection,
    IStructuredSelection {
        MySelection() {
        }

        public boolean isEmpty() {
            return true;
        }

        public Object getFirstElement() {
            return null;
        }

        public Iterator iterator() {
            return Collections.EMPTY_LIST.iterator();
        }

        public int size() {
            return 0;
        }

        public Object[] toArray() {
            return null;
        }

        public List toList() {
            return null;
        }
    }

    class MySelectionProvider
    implements ISelectionProvider {
        MySelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return new MySelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    class MySite
    implements IWorkbenchPartSite {
        MySite() {
        }

        public String getId() {
            return null;
        }

        public IKeyBindingService getKeyBindingService() {
            return null;
        }

        public IWorkbenchPart getPart() {
            return null;
        }

        public String getPluginId() {
            return null;
        }

        public String getRegisteredName() {
            return null;
        }

        public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
        }

        public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
        }

        public IWorkbenchPage getPage() {
            return null;
        }

        public ISelectionProvider getSelectionProvider() {
            return new MySelectionProvider();
        }

        public Shell getShell() {
            return null;
        }

        public IWorkbenchWindow getWorkbenchWindow() {
            return null;
        }

        public void setSelectionProvider(ISelectionProvider provider) {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public Object getService(Class api) {
            return null;
        }

        public boolean hasService(Class api) {
            return false;
        }
    }

    class MyWorkBenchPart
    implements IWorkbenchPart {
        MyWorkBenchPart() {
        }

        public void addPropertyListener(IPropertyListener listener) {
        }

        public void createPartControl(Composite parent) {
        }

        public void dispose() {
        }

        public IWorkbenchPartSite getSite() {
            return new MySite();
        }

        public String getTitle() {
            return null;
        }

        public Image getTitleImage() {
            return null;
        }

        public String getTitleToolTip() {
            return null;
        }

        public void removePropertyListener(IPropertyListener listener) {
        }

        public void setFocus() {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    class MyWorkbenchPartDescriptor
    implements IWorkbenchPartDescriptor {
        String partId;

        public MyWorkbenchPartDescriptor(String id) {
            this.partId = id;
        }

        public String getPartId() {
            return this.partId;
        }

        public Class getPartClass() {
            return MyWorkbenchPart.class;
        }

        public IWorkbenchPage getPartPage() {
            return null;
        }
    }
}

