/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;

public class DiagramCommandStack
extends CommandStack {
    private Map stackToManager = new HashMap();
    private IDiagramEditDomain editDomain;
    private Command cmdRecent = null;
    private IOperationHistory delegate;
    private IUndoContext undoContext;
    static /* synthetic */ Class class$0;

    public DiagramCommandStack(IDiagramEditDomain editDomain) {
        this.editDomain = editDomain;
    }

    public void addCommandStackListener(CommandStackListener listener) {
        final CommandStackListener csl = listener;
        this.removeCommandStackListener(csl);
        IOperationHistoryListener cmcl = new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                if (csl != null) {
                    csl.commandStackChanged((EventObject)new HistoryEventObject(event));
                }
            }
        };
        this.stackToManager.put(csl, cmcl);
        this.getOperationHistory().addOperationHistoryListener(cmcl);
    }

    public boolean canRedo() {
        return this.getOperationHistory().canRedo(this.getUndoContext());
    }

    public boolean canUndo() {
        return this.getOperationHistory().canUndo(this.getUndoContext());
    }

    public void execute(Command command) {
        this.execute(command, null);
    }

    public void execute(Command command, IProgressMonitor progressMonitor) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.execute(DiagramCommandStack.getICommand(command), progressMonitor);
    }

    protected void execute(ICommand command) {
        this.execute(command, null);
    }

    protected void execute(ICommand command, IProgressMonitor progressMonitor) {
        if (progressMonitor != null) {
            try {
                command.addContext(this.getUndoContext());
                this.getOperationHistory().execute((IUndoableOperation)command, progressMonitor, null);
            }
            catch (ExecutionException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"execute", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)4, (String)"execute", (Throwable)e);
            }
        } else {
            try {
                command.addContext(this.getUndoContext());
                this.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"execute", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)4, (String)"execute", (Throwable)e);
            }
        }
    }

    public static ICommand getICommand(Command command) {
        if (command instanceof CompoundCommand) {
            CompositeCommand composite = new CompositeCommand(command.getLabel());
            Object[] subCommands = ((CompoundCommand)command).getChildren();
            int i = 0;
            while (i < subCommands.length) {
                composite.compose((IUndoableOperation)DiagramCommandStack.getICommand((Command)subCommands[i]));
                ++i;
            }
            return composite.reduce();
        }
        if (command instanceof ICommandProxy) {
            return DiagramCommandStack.getICommand(((ICommandProxy)command).getICommand());
        }
        return new CommandProxy(command);
    }

    public static ICommand getICommand(ICommand command) {
        ICommand result = command;
        if (command instanceof ICompositeCommand) {
            ArrayList<Object> processedCommands = new ArrayList<Object>();
            ICompositeCommand composite = (ICompositeCommand)command;
            if (!composite.isEmpty()) {
                Iterator i = composite.iterator();
                while (i.hasNext()) {
                    IUndoableOperation nextOperation = (IUndoableOperation)i.next();
                    i.remove();
                    if (nextOperation instanceof ICommand) {
                        ICommand nextCommand = (ICommand)nextOperation;
                        processedCommands.add(DiagramCommandStack.getICommand(nextCommand));
                        continue;
                    }
                    processedCommands.add(nextOperation);
                }
                i = processedCommands.iterator();
                while (i.hasNext()) {
                    composite.add((IUndoableOperation)i.next());
                }
                result = composite.reduce();
            }
        } else if (command instanceof CommandProxy) {
            return DiagramCommandStack.getICommand(((CommandProxy)command).getCommand());
        }
        return result;
    }

    public Command getMostRecentCommand() {
        return this.cmdRecent;
    }

    public Command getRedoCommand() {
        if (this.getOperationHistory().canRedo(this.getUndoContext())) {
            Command emptyCmd = new Command(){};
            IUndoableOperation redo = this.getOperationHistory().getRedoOperation(this.getUndoContext());
            emptyCmd.setLabel(redo.getLabel());
            return emptyCmd;
        }
        return null;
    }

    public Command getUndoCommand() {
        if (this.getOperationHistory().canUndo(this.getUndoContext())) {
            Command emptyCmd = new Command(){};
            IUndoableOperation undo = this.getOperationHistory().getUndoOperation(this.getUndoContext());
            emptyCmd.setLabel(undo.getLabel());
            return emptyCmd;
        }
        return null;
    }

    public void redo() {
        this.cmdRecent = this.getRedoCommand();
        try {
            this.getOperationHistory().redo(this.getUndoContext(), (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            DiagramUIPlugin diagramUIPlugin = DiagramUIPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.internal.tools.ConnectionHandleTool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((Plugin)diagramUIPlugin, (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"redo", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)4, (String)"redo", (Throwable)e);
        }
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        CommandStackListener csl = listener;
        if (csl != null) {
            IOperationHistoryListener historyListener = (IOperationHistoryListener)this.stackToManager.get(csl);
            if (historyListener != null) {
                this.getOperationHistory().removeOperationHistoryListener(historyListener);
            }
            this.stackToManager.remove(csl);
        }
    }

    public void undo() {
        this.cmdRecent = this.getUndoCommand();
        try {
            this.getOperationHistory().undo(this.getUndoContext(), (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            DiagramUIPlugin diagramUIPlugin = DiagramUIPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.internal.tools.ConnectionHandleTool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((Plugin)diagramUIPlugin, (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"undo", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)4, (String)"undo", (Throwable)e);
        }
    }

    protected IDiagramEditDomain getDiagramEditDomain() {
        return this.editDomain;
    }

    protected IOperationHistory getOperationHistory() {
        if (this.delegate == null) {
            this.delegate = OperationHistoryFactory.getOperationHistory();
        }
        return this.delegate;
    }

    public void setOperationHistory(IOperationHistory operationHistory) {
        this.delegate = operationHistory;
    }

    public static Collection getReturnValues(Command c) {
        if (c instanceof CompoundCommand) {
            CompoundCommand cc = (CompoundCommand)c;
            ArrayList l = new ArrayList(cc.size());
            Iterator i = cc.getCommands().iterator();
            while (i.hasNext()) {
                l.addAll(DiagramCommandStack.getReturnValues((Command)i.next()));
            }
            return l;
        }
        if (c instanceof ICommandProxy) {
            return DiagramCommandStack.getReturnValues((ICommandProxy)c);
        }
        return Collections.EMPTY_LIST;
    }

    public static Collection getReturnValues(ICommandProxy cmd) {
        return DiagramCommandStack.getReturnValues(cmd.getICommand());
    }

    public static Collection getReturnValues(CommandProxy cmd) {
        return DiagramCommandStack.getReturnValues(cmd.getCommand());
    }

    public static Collection getReturnValues(ICommand cmd) {
        Object o;
        if (cmd instanceof ICompositeCommand) {
            ICompositeCommand cc = (ICompositeCommand)cmd;
            ArrayList l = new ArrayList();
            Iterator i = cc.iterator();
            while (i.hasNext()) {
                IUndoableOperation child = (IUndoableOperation)i.next();
                if (!(child instanceof ICommand)) continue;
                l.addAll(DiagramCommandStack.getReturnValues((ICommand)child));
            }
            return l;
        }
        if (cmd instanceof CommandProxy) {
            return DiagramCommandStack.getReturnValues((CommandProxy)cmd);
        }
        CommandResult r = cmd.getCommandResult();
        Object object = o = r != null ? r.getReturnValue() : null;
        if (o instanceof Collection) {
            return (Collection)o;
        }
        if (o != null) {
            return Collections.singletonList(o);
        }
        return Collections.EMPTY_LIST;
    }

    public IUndoContext getUndoContext() {
        if (this.undoContext == null) {
            this.undoContext = new ObjectUndoContext((Object)this);
        }
        return this.undoContext;
    }

    public void setUndoContext(IUndoContext undoContext) {
        this.undoContext = undoContext;
    }

    public void dispose() {
        Set entries = this.stackToManager.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            IOperationHistoryListener historyListener = (IOperationHistoryListener)element.getValue();
            if (historyListener == null) continue;
            this.getOperationHistory().removeOperationHistoryListener(historyListener);
        }
        super.dispose();
    }

    private final class HistoryEventObject
    extends EventObject {
        private final OperationHistoryEvent event;

        private HistoryEventObject(OperationHistoryEvent event) {
            super(event.getHistory());
            this.event = event;
        }

        public OperationHistoryEvent getOperationHistoryEvent() {
            return this.event;
        }
    }
}

