/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandDefinitionWrap {
    private final XpandDefinition def;
    private final XpandExecutionContext ctx;

    public XpandDefinitionWrap(XpandDefinition def, XpandExecutionContext ctx) {
        this.def = def;
        this.ctx = ctx;
    }

    public String getName() {
        return this.def.getName();
    }

    public EClassifier getTargetType() {
        return this.ctx.getTypeForName(this.def.getTargetType());
    }

    public List<EClassifier> getParamTypes() {
        DeclaredParameter[] p = this.def.getParams();
        ArrayList<EClassifier> result = new ArrayList<EClassifier>();
        DeclaredParameter[] declaredParameterArray = p;
        int n = 0;
        int n2 = declaredParameterArray.length;
        while (n < n2) {
            DeclaredParameter element = declaredParameterArray[n];
            result.add(this.ctx.getTypeForName(element.getType().getValue()));
            ++n;
        }
        return result;
    }

    public List<String> getParamNames() {
        DeclaredParameter[] p = this.def.getParams();
        ArrayList<String> result = new ArrayList<String>();
        DeclaredParameter[] declaredParameterArray = p;
        int n = 0;
        int n2 = declaredParameterArray.length;
        while (n < n2) {
            DeclaredParameter element = declaredParameterArray[n];
            result.add(element.getName().getValue());
            ++n;
        }
        return result;
    }

    public void proceed() {
        this.def.evaluate(this.ctx);
    }

    public void proceed(Object target, List<?> list) {
        XpandExecutionContext context = this.ctx;
        if (target != null) {
            context = (XpandExecutionContext)context.cloneWithVariable(new Variable("this", target));
        }
        if (list != null) {
            List<String> n = this.getParamNames();
            int i = 0;
            int x = list.size();
            while (i < x) {
                Object o = list.get(i);
                if (o == null || n.size() < i) continue;
                context = (XpandExecutionContext)context.cloneWithVariable(new Variable(n.get(i), o));
            }
        }
        this.def.evaluate(context);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '[' + this.def.toString() + ']';
    }
}

