/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorCallExpression
extends Expression {
    private Identifier type;

    public ConstructorCallExpression(int i, int end, int j, Identifier type) {
        super(i, end, j);
        this.type = type;
    }

    @Override
    protected Object evaluateInternal(ExecutionContext ctx) {
        EClassifier t = ctx.getTypeForName(this.type.getValue());
        if (t != null) {
            return BuiltinMetaModel.newInstance(t);
        }
        throw new EvaluationException("Couldn't find type " + this.type, (SyntaxElement)this);
    }

    @Override
    public EClassifier analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier t = ctx.getTypeForName(this.type.getValue());
        if (t == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.TYPE_NOT_FOUND, "Type not found : " + this.type, this.type));
            return null;
        }
        if (t instanceof EEnum) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Can't instantiate enum " + this.type, this.type));
            return null;
        }
        if (t instanceof EClass && (((EClass)t).isAbstract() || ((EClass)t).isInterface())) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Can't instantiate abstract type " + this.type, this.type));
            return null;
        }
        return t;
    }
}

