/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;

public class TetherConnectionEditPolicy
extends GraphicalEditPolicyEx {
    private Polyline tether;
    private OwnerMovedListener ownerMovedListener = new OwnerMovedListener();

    private Polyline getConnection() {
        if (this.tether == null) {
            this.tether = new PolylineConnectionEx();
            this.tether.setLineStyle(2);
        }
        return this.tether;
    }

    public void activate() {
        super.activate();
        this.addConnection();
        ((IGraphicalEditPart)this.getHost()).getFigure().addFigureListener((FigureListener)this.ownerMovedListener);
    }

    public void deactivate() {
        ((IGraphicalEditPart)this.getHost()).getFigure().removeFigureListener((FigureListener)this.ownerMovedListener);
        this.removeConnection();
        super.deactivate();
    }

    private void removeConnection() {
        if (this.getParentFigure().getChildren().contains(this.getConnection())) {
            this.getParentFigure().remove((IFigure)this.getConnection());
        }
    }

    private void addConnection() {
        if (!this.getParentFigure().getChildren().contains(this.getConnection())) {
            this.getParentFigure().add((IFigure)this.getConnection());
        }
    }

    public void refresh() {
        IFigure figure = ((GraphicalEditPart)this.getHost()).getFigure();
        Rectangle r = figure.getBounds().getCopy();
        PointList pl = new PointList();
        Point refPoint = new Point();
        if (this.getHost().getParent() instanceof AbstractConnectionEditPart) {
            AbstractConnectionEditPart connectionClassEP = (AbstractConnectionEditPart)this.getHost().getParent();
            pl = connectionClassEP.getConnectionFigure().getPoints();
            refPoint = PointListUtilities.calculatePointRelativeToLine((PointList)pl, (int)0, (int)50, (boolean)true);
        } else {
            refPoint = ((AbstractGraphicalEditPart)this.getHost().getParent()).getFigure().getBounds().getLocation();
        }
        Point midTop = new Point(r.x + r.width / 2, r.y);
        Point midBottom = new Point(r.x + r.width / 2, r.y + r.height);
        Point midLeft = new Point(r.x, r.y + r.height / 2);
        Point midRight = new Point(r.x + r.width, r.y + r.height / 2);
        Point startPoint = midTop;
        int x = r.x + r.width / 2 - refPoint.x;
        int y = r.y + r.height / 2 - refPoint.y;
        startPoint = y > 0 && y > x && y > -x ? midTop : (y < 0 && y < x && y < -x ? midBottom : (x < 0 && y > x && y < -x ? midRight : midLeft));
        this.getConnection().setStart(startPoint);
        this.getConnection().setEnd(refPoint);
        this.getConnection().setForegroundColor(((AbstractGraphicalEditPart)this.getHost().getParent()).getFigure().getForegroundColor());
    }

    private IFigure getParentFigure() {
        return this.getHostFigure().getParent();
    }

    private class OwnerMovedListener
    implements FigureListener {
        private OwnerMovedListener() {
        }

        public void figureMoved(IFigure source) {
            TetherConnectionEditPolicy.this.refresh();
        }
    }
}

