/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.net4j.examples.mvc.util.DuplicateAspectException;
import org.eclipse.net4j.examples.mvc.util.UnknownAspectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAspectDataMap<DATA, TARGET> {
    private Map<Class, DATA> map = new HashMap<Class, DATA>();

    public Class[] getAspects() {
        return this.map.keySet().toArray(new Class[this.map.size()]);
    }

    public boolean hasAspect(Class aspect) {
        return this.map.containsKey(aspect);
    }

    public DATA getAspectData(Class aspect) throws UnknownAspectException {
        DATA data = this.map.get(aspect);
        if (data == null) {
            throw new UnknownAspectException(aspect);
        }
        return data;
    }

    public void putAspectData(Class aspect, DATA data) throws DuplicateAspectException {
        DATA old = this.map.put(aspect, data);
        if (old != null) {
            throw new DuplicateAspectException(aspect);
        }
    }

    public DATA removeAspectData(Class aspect) throws UnknownAspectException {
        DATA data = this.map.remove(aspect);
        if (data == null) {
            throw new UnknownAspectException(aspect);
        }
        return data;
    }

    public DATA ensureAspectData(Class aspect) {
        if (this.hasAspect(aspect)) {
            return this.getAspectData(aspect);
        }
        DATA data = this.createData();
        this.putAspectData(aspect, data);
        return data;
    }

    protected abstract DATA createData();
}

