/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.net4j.core.AlreadyRequestingException;
import org.eclipse.net4j.core.BufferPool;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.ChannelCancelledException;
import org.eclipse.net4j.core.Connector;
import org.eclipse.net4j.core.IllegalEventException;
import org.eclipse.net4j.core.Indication;
import org.eclipse.net4j.core.IndicationWithResponse;
import org.eclipse.net4j.core.Multiplexer;
import org.eclipse.net4j.core.Protocol;
import org.eclipse.net4j.core.Request;
import org.eclipse.net4j.core.RequestWithConfirmation;
import org.eclipse.net4j.core.ResponseTimedOutException;
import org.eclipse.net4j.core.impl.BufferImpl;
import org.eclipse.net4j.core.impl.ResponseExceptionWrapper;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.eclipse.net4j.util.Assert;
import org.eclipse.net4j.util.BitHelper;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ThreadInterruptedException;
import org.eclipse.net4j.util.fsm.IStateMachine;
import org.eclipse.net4j.util.fsm.StateMachine;
import org.eclipse.net4j.util.thread.DeadlockDetector;

public class ChannelImpl
extends ServiceImpl
implements Channel {
    public static boolean TRACING = false;
    public static boolean TRACING_BUFFERS = false;
    public static boolean TRACING_STATES = false;
    public static int TRACE_MODE = 3;
    public static final boolean DEBUG_MODE = !System.getProperty("java.vm.info", "").contains("sharing");
    public static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16 = "UTF-16";
    public static final String CHARSET = "UTF-16";
    protected static final int CHANNEL_PAD = 6;
    protected static final int COMM_STATE_BITS = 3;
    protected static final int COMM_STATE_PAD = 6;
    protected static final int COMM_STATE_MASK = BitHelper.getMask((int)3, (int)6);
    protected static final int CHANNEL_BITS = 9;
    public static final String[] STATE_NAMES = new String[]{"IDLE", "REQUESTING", "INDICATING", "INDIQUESTING", "RESPONDING", "CONFIRMING"};
    public static final String[] EVENT_NAMES = new String[]{"REQUEST_START", "REQUEST_END", "INDICATE_START", "INDICATION_END", "RESPOND_START", "RESPOND_END", "CONFIRM_START", "CONFIRM_END"};
    public static final ChannelStateMachine clientStateMachine = new ClientStateMachine();
    public static final ChannelStateMachine serverStateMachine = new ServerStateMachine();
    public static final long DEFAULT_RESPONSE_TIMEOUT_MILLIS = DEBUG_MODE ? Long.MAX_VALUE : 5000L;
    public long responseTimeoutMillis = DEFAULT_RESPONSE_TIMEOUT_MILLIS;
    private Connector connector;
    private short channelIndex;
    private Multiplexer multiplexer;
    private Protocol protocol;
    private BufferImpl receiverBuffer;
    private BlockingQueue<BufferImpl> receiverQueue = new LinkedBlockingQueue<BufferImpl>();
    private Runnable receiverTask;
    private BufferImpl transmitterBuffer;
    private BlockingQueue<BufferImpl> transmitterQueue = new LinkedBlockingQueue<BufferImpl>();
    private Object protocolData;
    private Request currentRequest;
    private transient Object returnValue;
    private transient boolean responseReady;
    private transient Object responseMutex = new Object();
    private transient String cancelCode;

    public ChannelImpl() {
        this.setCommState(0);
    }

    public int getCommState() {
        return (this.flags & COMM_STATE_MASK) >> 6;
    }

    public void setCommState(int state) {
        this.flags &= ~COMM_STATE_MASK;
        this.flags |= state << 6 & COMM_STATE_MASK;
    }

    public void processCommEvent(int event) {
        if (this.connector == null) {
            return;
        }
        int type = this.connector.getType();
        ChannelStateMachine stateMachine = type == 0 ? clientStateMachine : serverStateMachine;
        try {
            stateMachine.process(this, event, null);
        }
        catch (Exception ex) {
            this.error("Error while processing CommEvent " + stateMachine.getEventName(event), ex);
        }
    }

    public boolean isTransmittingAllowed() {
        switch (this.getCommState()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isReceivingAllowed() {
        switch (this.getCommState()) {
            case 0: 
            case 2: 
            case 3: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object transmit(Request request) {
        this.assertActive();
        if (this.currentRequest != null) {
            if (this.getConnector().isClient()) {
                throw new AlreadyRequestingException(this.currentRequest, request);
            }
            throw new UnsupportedOperationException();
        }
        this.currentRequest = request;
        this.responseReady = false;
        this.returnValue = null;
        request.setChannel(this);
        short signalId = request.getSignalId();
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Transmitting signal id");
        }
        this.transmitShort(signalId);
        if (request.isDebugEnabled()) {
            request.debug("");
            request.debug("---------------------------------------------------------------------");
            request.debug("Transmitting request " + request.getName());
        }
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this.processCommEvent(0);
            request.request();
            this.flush();
            this.processCommEvent(1);
        }
        if (request.hasResponse()) {
            if (this.getConnector().isServer()) {
                throw new ImplementationError("Passive connectors must not transmit requests with confirmation");
            }
            long start = System.currentTimeMillis();
            while (!this.responseReady) {
                if (System.currentTimeMillis() - start > this.responseTimeoutMillis) {
                    throw new ResponseTimedOutException();
                }
                Object object = this.responseMutex;
                synchronized (object) {
                    DeadlockDetector.wait((Object)this.responseMutex, (long)this.responseTimeoutMillis);
                }
            }
        }
        this.currentRequest = null;
        Object tmp = this.returnValue;
        this.returnValue = null;
        if (tmp instanceof ResponseExceptionWrapper) {
            throw ((ResponseExceptionWrapper)tmp).getException();
        }
        return tmp;
    }

    public void flush() {
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Flushing");
        }
        this.scheduleBuffer();
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void handleTransmission() {
        this.assertActive();
        BufferImpl buffer = null;
        if (this.cancelCode != null) {
            while ((buffer = (BufferImpl)this.transmitterQueue.poll()) != null) {
                this.releaseBuffer(buffer);
            }
            throw new ChannelCancelledException("Channel canceled: " + this.cancelCode);
        }
        buffer = (BufferImpl)this.transmitterQueue.poll();
        if (buffer != null) {
            if (TRACING && this.isDebugEnabled()) {
                this.debug("Transmitting data: " + buffer.toString(TRACE_MODE));
            }
            this.connector.transmit(this.channelIndex, buffer);
            this.releaseBuffer(buffer);
        }
    }

    public boolean receiveBoolean() {
        boolean value;
        this.ensureReceiverBufferData(1);
        boolean bl = value = this.receiverBuffer.get() != 0;
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Received boolean: " + value);
        }
        return value;
    }

    public byte[] receiveBytes() {
        this.ensureReceiverBufferData(4);
        int len = this.receiverBuffer.getInt();
        if (len == -1) {
            if (TRACING && this.isDebugEnabled()) {
                this.debug("Received Bytes: null");
            }
            return null;
        }
        byte[] result = new byte[len];
        int offset = 0;
        int chunk = Math.min(len, this.receiverBuffer.remaining());
        if (chunk > 0) {
            this.receiverBuffer.get(result, offset, chunk);
            offset += chunk;
            len -= chunk;
        }
        while (len > 0) {
            this.releaseBuffer(this.receiverBuffer);
            this.ensureReceiverBuffer();
            chunk = Math.min(len, this.receiverBuffer.remaining());
            this.receiverBuffer.get(result, offset, chunk);
            offset += chunk;
            len -= chunk;
        }
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Received Bytes: " + result);
        }
        return result;
    }

    public byte receiveByte() {
        this.ensureReceiverBufferData(1);
        byte value = this.receiverBuffer.get();
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Received byte: " + value);
        }
        return value;
    }

    public char receiveChar() {
        this.ensureReceiverBufferData(2);
        char value = this.receiverBuffer.getChar();
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Received char: " + value);
        }
        return value;
    }

    public double receiveDouble() {
        this.ensureReceiverBufferData(8);
        double value = this.receiverBuffer.getDouble();
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Received double: " + value);
        }
        return value;
    }

    public float receiveFloat() {
        this.ensureReceiverBufferData(4);
        float value = this.receiverBuffer.getFloat();
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Received float: " + value);
        }
        return value;
    }

    public int receiveInt() {
        this.ensureReceiverBufferData(4);
        int value = this.receiverBuffer.getInt();
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Received int: " + value);
        }
        return value;
    }

    public long receiveLong() {
        this.ensureReceiverBufferData(8);
        long value = this.receiverBuffer.getLong();
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Received long: " + value);
        }
        return value;
    }

    public Object receiveObject() {
        byte[] array = this.receiveBytes();
        ByteArrayInputStream buffer = new ByteArrayInputStream(array);
        try {
            ObjectInputStream stream = new ObjectInputStream(buffer);
            return stream.readObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public short receiveShort() {
        this.ensureReceiverBufferData(2);
        short value = this.receiverBuffer.getShort();
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Received short: " + value);
        }
        return value;
    }

    public String receiveString() {
        byte[] array = this.receiveBytes();
        if (array == null) {
            return null;
        }
        String result = null;
        try {
            result = new String(array, "UTF-16");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void setConnector(Connector connector) {
        this.doSet("connector", connector);
    }

    public void setChannelIndex(short channelIndex) {
        this.doSet("channelIndex", channelIndex);
    }

    public void setProtocol(Protocol protocol) {
        this.doSet("protocol", protocol);
    }

    public void transmitBoolean(boolean value) {
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Transmitting boolean: " + value);
        }
        this.ensureTransmitterBufferData(1);
        this.transmitterBuffer.put((byte)(value ? 1 : 0));
    }

    public void transmitBytes(byte[] value) {
        if (value == null) {
            if (TRACING && this.isDebugEnabled()) {
                this.debug("Transmitting Bytes: null");
            }
            this.ensureTransmitterBufferData(4);
            this.transmitterBuffer.putInt(-1);
        } else {
            if (TRACING && this.isDebugEnabled()) {
                this.debug("Transmitting Bytes: " + value);
            }
            int len = value.length;
            this.ensureTransmitterBufferData(4);
            this.transmitterBuffer.putInt(len);
            int offset = 0;
            int chunk = Math.min(len, this.transmitterBuffer.remaining());
            if (chunk > 0) {
                this.transmitterBuffer.put(value, offset, chunk);
                offset += chunk;
                len -= chunk;
            }
            while (len > 0) {
                this.scheduleBuffer();
                chunk = Math.min(len, this.transmitterBuffer.remaining());
                this.transmitterBuffer.put(value, offset, chunk);
                offset += chunk;
                len -= chunk;
            }
        }
    }

    public void transmitByte(byte value) {
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Transmitting byte: " + value);
        }
        this.ensureTransmitterBufferData(2);
        this.transmitterBuffer.put(value);
    }

    public void transmitChar(char value) {
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Transmitting char: " + value);
        }
        this.ensureTransmitterBufferData(2);
        this.transmitterBuffer.putChar(value);
    }

    public void transmitDouble(double value) {
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Transmitting double: " + value);
        }
        this.ensureTransmitterBufferData(8);
        this.transmitterBuffer.putDouble(value);
    }

    public void transmitFloat(float value) {
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Transmitting float: " + value);
        }
        this.ensureTransmitterBufferData(4);
        this.transmitterBuffer.putFloat(value);
    }

    public void transmitInt(int value) {
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Transmitting int: " + value);
        }
        this.ensureTransmitterBufferData(4);
        this.transmitterBuffer.putInt(value);
    }

    public void transmitLong(long value) {
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Transmitting long: " + value);
        }
        this.ensureTransmitterBufferData(8);
        this.transmitterBuffer.putLong(value);
    }

    public void transmitObject(Object value) {
        byte[] array = null;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            ObjectOutputStream stream = new ObjectOutputStream(buffer);
            stream.writeObject(value);
            array = buffer.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.transmitBytes(array);
    }

    public void transmitShort(short value) {
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Transmitting short: " + value);
        }
        this.ensureTransmitterBufferData(2);
        this.transmitterBuffer.putShort(value);
    }

    public void transmitString(String value) {
        byte[] array = null;
        if (value != null) {
            try {
                array = value.getBytes("UTF-16");
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
        }
        this.transmitBytes(array);
    }

    public short getChannelIndex() {
        return this.channelIndex;
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("multiplexer");
        if (this.connector != null) {
            this.newTransmitterBuffer();
        }
    }

    protected void activate() throws Exception {
        super.activate();
        this.protocol.registerChannel(this);
    }

    protected void deactivate() throws Exception {
        this.protocol.deregisterChannel(this);
        this.connector.removeChannel(this);
        this.cancelCode = null;
        this.connector = null;
        this.currentRequest = null;
        this.multiplexer = null;
        this.protocol = null;
        this.protocolData = null;
        this.receiverBuffer = null;
        this.receiverQueue = null;
        this.receiverTask = null;
        this.responseMutex = null;
        this.returnValue = null;
        this.transmitterBuffer = null;
        this.transmitterQueue = null;
        super.deactivate();
    }

    public void notifyData(BufferImpl data) {
        if (TRACING && this.isDebugEnabled()) {
            this.debug("Received data: " + data.toString(TRACE_MODE));
        }
        this.receiverQueue.add(data);
        if (this.receiverTask == null) {
            this.startSignalTask();
        }
    }

    protected void startSignalTask() {
        if (!this.receiverQueue.isEmpty()) {
            try {
                if (TRACING && this.isDebugEnabled()) {
                    this.debug("Starting signal task");
                }
                this.receiverTask = new SignalTask();
                EXECUTOR_SERVICE.execute(this.receiverTask);
            }
            catch (Exception ex) {
                this.error("Error while dispatching task " + this.receiverTask, ex);
            }
        }
    }

    protected void ensureTransmitterBufferData(int dataSize) {
        if (dataSize <= 0) {
            throw new IllegalArgumentException("dataSize <= 0");
        }
        if (TRACING_BUFFERS && this.isDebugEnabled()) {
            this.debug("Ensuring " + dataSize + " bytes in transmitterBuffer");
        }
        if (this.transmitterBuffer.remaining() < dataSize) {
            this.scheduleBuffer();
        }
        if (TRACING_BUFFERS && this.isDebugEnabled()) {
            this.debug("Ensured transmitterBuffer " + this.transmitterBuffer);
        }
    }

    protected void ensureReceiverBufferData(int dataSize) {
        if (dataSize <= 0) {
            throw new IllegalArgumentException("dataSize <= 0");
        }
        if (TRACING_BUFFERS && this.isDebugEnabled()) {
            this.debug("Ensuring " + dataSize + " bytes in receiverBuffer");
        }
        if (this.receiverBuffer == null) {
            this.ensureReceiverBuffer();
        } else if (!this.receiverBuffer.hasRemaining()) {
            this.releaseBuffer(this.receiverBuffer);
            this.ensureReceiverBuffer();
        }
        if (this.receiverBuffer == null) {
            return;
        }
        if (this.receiverBuffer.remaining() < dataSize) {
            throw new ImplementationError("receiverBuffer level too low: " + this.receiverBuffer.remaining() + " < " + dataSize);
        }
        if (TRACING_BUFFERS && this.isDebugEnabled()) {
            this.debug("Ensured receiverBuffer " + this.receiverBuffer);
        }
    }

    protected void ensureReceiverBuffer() {
        try {
            this.receiverBuffer = null;
            while (this.receiverBuffer == null && this.isActive()) {
                this.receiverBuffer = this.receiverQueue.poll(50L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException ex) {
            throw new ThreadInterruptedException((Throwable)ex);
        }
    }

    protected void scheduleBuffer() {
        if (this.transmitterBuffer.position() == 0) {
            return;
        }
        this.transmitterBuffer.flip();
        this.transmitterQueue.add(this.transmitterBuffer);
        this.multiplexer.schedule(this);
        this.newTransmitterBuffer();
    }

    protected void releaseBuffer(BufferImpl buffer) {
        BufferPool bufferPool;
        Connector connector = this.getConnector();
        if (connector != null && (bufferPool = connector.getBufferPool()) != null) {
            bufferPool.releaseBuffer(buffer);
        }
    }

    protected void newTransmitterBuffer() {
        this.transmitterBuffer = this.getConnector().getBufferPool().getBuffer();
        this.connector.adjustTransmitterBuffer(this.transmitterBuffer);
    }

    public Multiplexer getMultiplexer() {
        return this.multiplexer;
    }

    public void setMultiplexer(Multiplexer multiplexer) {
        this.doSet("multiplexer", multiplexer);
    }

    public Object getProtocolData() {
        return this.protocolData;
    }

    public void setProtocolData(Object data) {
        this.protocolData = data;
    }

    public Request getCurrentRequest() {
        return this.currentRequest;
    }

    public void cancel(String code) {
        this.cancelCode = code;
    }

    public boolean isCancelled() {
        return this.cancelCode != null;
    }

    public long getResponseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    public void setResponseTimeoutMillis(long responseTimeoutMillis) {
        this.doSet("responseTimeoutMillis", DEBUG_MODE ? Long.MAX_VALUE : responseTimeoutMillis);
    }

    protected void adjustPrototypeBeanName() {
        if (this.connector == null) {
            throw new ImplementationError("Called too early: connector == null");
        }
        String connectorName = this.connector.getBeanName();
        if (connectorName == null) {
            throw new ImplementationError("Called too early: connectorName == null");
        }
        this.setBeanName(String.valueOf(connectorName) + "-" + this.getBeanName() + "-" + this.channelIndex);
    }

    protected String formatLogMessage(String message) {
        if (this.getCommState() == 0) {
            return message;
        }
        return "|   " + message;
    }

    private final class SignalTask
    implements Runnable {
        private SignalTask() {
        }

        public void run() {
            this.processSignal();
            this.postProcessChannel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processSignal() {
            short signalId;
            if (TRACING && ChannelImpl.this.isDebugEnabled()) {
                ChannelImpl.this.debug("Waiting for signal id");
            }
            Assert.isTrue(((signalId = ChannelImpl.this.receiveShort()) != 0 ? 1 : 0) != 0, (String)"signalID == 0");
            if (signalId < 0) {
                RequestWithConfirmation confirmation = (RequestWithConfirmation)ChannelImpl.this.getCurrentRequest();
                while (confirmation == null) {
                    confirmation = (RequestWithConfirmation)ChannelImpl.this.getCurrentRequest();
                    DeadlockDetector.sleep((long)5L);
                }
                short requestId = confirmation.getSignalId();
                if (requestId != -signalId) {
                    throw new ImplementationError("Mismatch between Request(" + requestId + ") and Response(" + -signalId + ")");
                }
                if (confirmation.isDebugEnabled()) {
                    confirmation.debug("");
                    confirmation.debug("---------------------------------------------------------------------");
                    confirmation.debug("Receiving confirmation " + confirmation.getName());
                }
                try {
                    try {
                        ChannelImpl channelImpl = ChannelImpl.this;
                        synchronized (channelImpl) {
                            try {
                                ChannelImpl.this.processCommEvent(6);
                                ChannelImpl.this.returnValue = confirmation.confirm();
                            }
                            finally {
                                ChannelImpl.this.processCommEvent(7);
                            }
                        }
                    }
                    catch (RuntimeException ex) {
                        ChannelImpl.this.returnValue = new ResponseExceptionWrapper(ex);
                    }
                }
                catch (Throwable throwable) {
                    Object object = ChannelImpl.this.responseMutex;
                    synchronized (object) {
                        ChannelImpl.this.responseReady = true;
                        ChannelImpl.this.responseMutex.notifyAll();
                    }
                    throw throwable;
                }
                Object object = ChannelImpl.this.responseMutex;
                synchronized (object) {
                    ChannelImpl.this.responseReady = true;
                    ChannelImpl.this.responseMutex.notifyAll();
                }
            }
            Protocol protocol = ChannelImpl.this.getProtocol();
            Indication indication = protocol.createIndication(signalId);
            indication.setChannel(ChannelImpl.this);
            if (indication.isDebugEnabled()) {
                indication.debug("");
                indication.debug("---------------------------------------------------------------------");
                indication.debug("Receiving indication " + indication.getName());
            }
            ChannelImpl ex = ChannelImpl.this;
            synchronized (ex) {
                ChannelImpl.this.processCommEvent(2);
                indication.indicate();
                ChannelImpl.this.processCommEvent(3);
            }
            if (indication.hasResponse()) {
                IndicationWithResponse response = (IndicationWithResponse)indication;
                short responseId = -signalId;
                if (TRACING && ChannelImpl.this.isDebugEnabled()) {
                    ChannelImpl.this.debug("Transmitting signal id");
                }
                ChannelImpl.this.transmitShort(responseId);
                if (response.isDebugEnabled()) {
                    response.debug("");
                    response.debug("---------------------------------------------------------------------");
                    response.debug("Transmitting response " + response.getName());
                }
                ChannelImpl channelImpl = ChannelImpl.this;
                synchronized (channelImpl) {
                    ChannelImpl.this.processCommEvent(4);
                    response.respond();
                    ChannelImpl.this.flush();
                    ChannelImpl.this.processCommEvent(5);
                }
            }
        }

        private void postProcessChannel() {
            if (TRACING && ChannelImpl.this.isDebugEnabled()) {
                ChannelImpl.this.debug("Finished signal task");
            }
            ChannelImpl.this.receiverTask = null;
            ChannelImpl.this.startSignalTask();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChannelStateMachine
    extends StateMachine<ChannelImpl> {
        private static final IStateMachine.ITransition<ChannelImpl> DEFAULT_TRANSITION = new IStateMachine.ITransition<ChannelImpl>(){

            public void process(ChannelImpl subject, int event, Object data) throws Exception {
                throw new IllegalEventException("Illegal event " + EVENT_NAMES[event] + " in state " + STATE_NAMES[subject.getCommState()] + " for channel " + subject);
            }
        };

        public ChannelStateMachine() {
            super(STATE_NAMES, EVENT_NAMES, DEFAULT_TRANSITION);
        }

        protected int getState(ChannelImpl subject) {
            return subject.getCommState();
        }

        protected void setState(ChannelImpl subject, int state) {
            if (TRACING_STATES && subject.isDebugEnabled()) {
                subject.debug("Setting comm state: " + this.getStateName(state));
            }
            subject.setCommState(state);
        }
    }

    public static class ClientStateMachine
    extends ChannelStateMachine {
        private static final Logger logger = Logger.getLogger((String)ClientStateMachine.class.getName());

        public ClientStateMachine() {
            this.handle(0, 0, 1);
            this.handle(0, 2, 2);
            this.handle(0, 6, 5);
            this.handle(1, 1, 0);
            this.handle(1, 2, 3);
            this.handle(2, 3, 0);
            this.handle(2, 0, 3);
            this.handle(3, 1, 2);
            this.handle(3, 3, 1);
            this.handle(5, 7, 0);
        }

        protected Logger getLogger() {
            return logger;
        }
    }

    public static class ServerStateMachine
    extends ChannelStateMachine {
        private static final Logger logger = Logger.getLogger((String)ServerStateMachine.class.getName());

        public ServerStateMachine() {
            this.handle(0, 0, 1);
            this.handle(0, 2, 2);
            this.handle(0, 4, 4);
            this.handle(1, 1, 0);
            this.handle(1, 2, 3);
            this.handle(1, 0, 1);
            this.handle(2, 3, 0);
            this.handle(2, 0, 3);
            this.handle(3, 1, 2);
            this.handle(3, 3, 1);
            this.handle(3, 0, 3);
            this.handle(4, 5, 0);
        }

        protected Logger getLogger() {
            return logger;
        }
    }
}

