/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.internal.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.internal.Messages;
import org.eclipse.emf.ecoretools.internal.views.AnalysisView;
import org.eclipse.emf.ecoretools.internal.views.EReferencesContentProvider;
import org.eclipse.emf.ecoretools.internal.views.EReferencesLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.WorkbenchJob;

public class EReferencesView
extends AnalysisView {
    public static final String VIEW_ID = "org.eclipse.emf.ecoretools.internal.views.EReferencesView";
    private TreeViewer referencesTree;
    private Job refreshJob;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.referencesTree = new TreeViewer(parent, 772);
        this.referencesTree.setContentProvider((IContentProvider)new EReferencesContentProvider());
        this.referencesTree.setLabelProvider((IBaseLabelProvider)new EReferencesLabelProvider());
        this.referencesTree.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EReferencesView.this.refreshJob != null) {
                    EReferencesView.this.refreshJob.cancel();
                }
            }
        });
    }

    protected void refresh(EObject object) {
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
        }
        if (object instanceof EClass) {
            EClass selectedEClass = (EClass)object;
            if (selectedEClass != null) {
                this.refreshJob = this.createRefreshJob(selectedEClass);
                this.refreshJob.schedule(200L);
            } else {
                this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(Messages.EReferencesView_InvalidSelection);
            }
        }
    }

    private Job createRefreshJob(final EClass selection) {
        WorkbenchJob job = new WorkbenchJob(Messages.EReferencesView_RefreshReferences){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (EReferencesView.this.referencesTree.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    EReferencesView.this.referencesTree.getControl().setRedraw(false);
                    EReferencesView.this.referencesTree.setInput((Object)selection);
                    EReferencesView.this.referencesTree.refresh();
                    EReferencesView.this.referencesTree.expandAll();
                }
                finally {
                    EReferencesView.this.referencesTree.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        return job;
    }
}

