/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.examples.internal.wizard;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecoretools.examples.internal.EcoreToolsExamplesPlugin;
import org.eclipse.emf.ecoretools.examples.internal.wizard.EcoreDiagramExampleWizardPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class EcoreDiagramExampleWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private EcoreDiagramExampleWizardPage directorySelectionPage;

    public void init(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        this.workbench = aWorkbench;
        this.selection = currentSelection;
    }

    public void addPages() {
        this.directorySelectionPage = new EcoreDiagramExampleWizardPage((ISelection)this.selection);
        this.addPage((IWizardPage)this.directorySelectionPage);
    }

    public boolean performFinish() {
        IFile domainFile = this.createDomainFile();
        IFile diagramFile = this.createDiagramFile();
        if (domainFile == null || diagramFile == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)diagramFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private IFile createDomainFile() {
        IContainer container = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.directorySelectionPage.getContainerName()));
        URL pluginFileURL = EcoreToolsExamplesPlugin.getDefault().getBundle().getEntry("/models/Ecore.ecore");
        if (pluginFileURL != null) {
            try {
                InputStream inStream = pluginFileURL.openStream();
                container.getFile((IPath)new Path("Ecore.ecore")).create(inStream, true, null);
                inStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return container.getFile((IPath)new Path("Ecore.ecore"));
    }

    private IFile createDiagramFile() {
        IContainer container = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.directorySelectionPage.getContainerName()));
        URL pluginFileURL = EcoreToolsExamplesPlugin.getDefault().getBundle().getEntry("/models/Ecore.ecorediag");
        if (pluginFileURL != null) {
            try {
                InputStream inStream = pluginFileURL.openStream();
                container.getFile((IPath)new Path("Ecore.ecorediag")).create(inStream, true, null);
                inStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return container.getFile((IPath)new Path("Ecore.ecorediag"));
    }
}

