/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.edit.commands.EcoreCreateShortcutDecorationsCommand;
import org.eclipse.emf.ecoretools.diagram.edit.commands.RestoreRelatedLinksCommand;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EReferenceUtils;
import org.eclipse.emf.ecoretools.diagram.part.EcoreLinkDescriptor;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreRelatedMissingNodesCommand
extends RestoreRelatedLinksCommand {
    public RestoreRelatedMissingNodesCommand(DiagramEditPart diagramEditPart, List<?> selection) {
        super(diagramEditPart, selection);
    }

    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (Object object : this.adapters) {
            if (object instanceof IAdaptable) {
                IAdaptable ad = (IAdaptable)object;
                View view = (View)ad.getAdapter(View.class);
                if (view == null) continue;
                this.refreshMissingNodes(view);
                continue;
            }
            if (!(object instanceof View)) continue;
            this.refreshMissingNodes((View)object);
        }
        return CommandResult.newOKCommandResult();
    }

    protected void refreshMissingNodes(View notationView) {
        HashMap<EObject, View> domain2NotationMap = new HashMap<EObject, View>();
        Collection<? extends EcoreLinkDescriptor> linkDescriptors = this.getLinkDescriptorToProcess(notationView, domain2NotationMap);
        this.createRelatedMissingNodes(linkDescriptors, domain2NotationMap);
    }

    protected void createRelatedMissingNodes(Collection<? extends EcoreLinkDescriptor> linkDescriptors, Map<EObject, View> domain2NotationMap) {
        this.mapModel((View)this.diagram, domain2NotationMap);
        ArrayList<EObject> objectViews = new ArrayList<EObject>();
        for (EcoreLinkDescriptor ecoreLinkDescriptor : linkDescriptors) {
            Command cmd;
            CreateViewRequest cvr;
            View sourceView = domain2NotationMap.get(ecoreLinkDescriptor.getSource());
            View targetView = domain2NotationMap.get(ecoreLinkDescriptor.getDestination());
            ArrayList<CreateViewRequest.ViewDescriptor> normalViewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
            ArrayList<CreateViewRequest.ViewDescriptor> shortcutViewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
            if (sourceView == null) {
                if (ecoreLinkDescriptor.getSource() != null && !objectViews.contains(ecoreLinkDescriptor.getSource())) {
                    this.updateDescriptors(ecoreLinkDescriptor.getSource(), normalViewDescriptors, shortcutViewDescriptors);
                    objectViews.add(ecoreLinkDescriptor.getSource());
                }
            } else {
                this.setViewVisible((Collection<? extends View>)Collections.singletonList(sourceView));
            }
            if (targetView == null) {
                if (ecoreLinkDescriptor.getDestination() != null && !objectViews.contains(ecoreLinkDescriptor.getDestination())) {
                    this.updateDescriptors(ecoreLinkDescriptor.getDestination(), normalViewDescriptors, shortcutViewDescriptors);
                    objectViews.add(ecoreLinkDescriptor.getDestination());
                }
            } else {
                this.setViewVisible((Collection<? extends View>)Collections.singletonList(targetView));
            }
            CompoundCommand compoundCmd = new CompoundCommand(Messages.RestoreRelatedMissingNodesCommand_CreateMissingNodes);
            if (!normalViewDescriptors.isEmpty()) {
                cvr = new CreateViewRequest(normalViewDescriptors);
                cvr.setLocation(new Point(-1, -1));
                cmd = this.host.getCommand((Request)cvr);
                compoundCmd.add(cmd);
            }
            if (!shortcutViewDescriptors.isEmpty()) {
                cvr = new CreateViewRequest(shortcutViewDescriptors);
                cvr.setLocation(new Point(-1, -1));
                cmd = this.host.getCommand((Request)cvr);
                cmd.chain((Command)new ICommandProxy((ICommand)new EcoreCreateShortcutDecorationsCommand(this.getEditingDomain(), (View)this.diagram, shortcutViewDescriptors)));
                compoundCmd.add(cmd);
            }
            if (compoundCmd == null || !compoundCmd.canExecute()) continue;
            EReferenceUtils.executeCommand((Command)compoundCmd, (IGraphicalEditPart)this.host);
        }
        objectViews.clear();
    }

    private void updateDescriptors(EObject object, List<CreateViewRequest.ViewDescriptor> normalViewDescriptors, List<CreateViewRequest.ViewDescriptor> shortcutViewDescriptors) {
        if (object.eContainer() == this.diagram.getElement()) {
            normalViewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(object), Node.class, null, this.host.getDiagramPreferencesHint()));
        } else {
            shortcutViewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(object), Node.class, null, this.host.getDiagramPreferencesHint()));
        }
    }
}

