/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.client.ClassInfo;
import org.eclipse.emf.cdo.client.PackageInfo;
import org.eclipse.emf.cdo.client.PackageManager;
import org.eclipse.emf.cdo.client.protocol.ClientCDOProtocolImpl;
import org.eclipse.emf.cdo.mapping.PackageMapping;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.core.Channel;

public class PackageInfoImpl
implements PackageInfo {
    private PackageManager packageManager;
    private transient boolean announced = false;
    private transient EPackage ePackage;
    private transient PackageMapping mapping;
    private transient List<ClassInfo> classes = new ArrayList<ClassInfo>();

    public PackageInfoImpl(EPackage ePackage, PackageMapping mapping, PackageManager packageManager) {
        this.ePackage = ePackage;
        this.mapping = mapping;
        this.packageManager = packageManager;
    }

    public String toString() {
        return this.getFullName();
    }

    public String getName() {
        return this.ePackage.getName();
    }

    public String getFullName() {
        return this.ePackage.getNsPrefix();
    }

    public EPackage getEPackage() {
        return this.ePackage;
    }

    public PackageMapping getMapping() {
        return this.mapping;
    }

    public void addClass(ClassInfo classInfo) {
        this.classes.add(classInfo);
    }

    public ClassInfo[] getClasses() {
        return this.classes.toArray(new ClassInfo[this.classes.size()]);
    }

    public boolean isAnnounced() {
        return this.announced;
    }

    public void announce(Channel channel) {
        if (!ClientCDOProtocolImpl.requestAnnouncePackage(channel, this)) {
            ClientCDOProtocolImpl.requestDescribePackage(channel, this);
        }
        this.announced = true;
    }

    public PackageManager getPackageManager() {
        return this.packageManager;
    }
}

