/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.controller;

import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.aspect.ISelectionViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.ITextViewAspect;
import org.eclipse.net4j.examples.mvc.binding.MetaDataBinding;
import org.eclipse.net4j.examples.mvc.controller.RecordController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataRecordController<RECORD_TARGET, VIEW_TARGET>
extends RecordController<RECORD_TARGET, VIEW_TARGET> {
    public static final String FIELD_NAME_KEY = "fieldName";
    public static final String RECORD_ACTION_KEY = "recordAction";
    public static final String RECORD_ACTION_LOAD_VALUE = "load";
    public static final String RECORD_ACTION_SAVE_VALUE = "save";
    public static final String BRIDGE_TYPE_KEY = "bridgeType";
    public static final String BRIDGE_TYPE_TEXT_VALUE = "text";
    public static final String BRIDGE_TYPE_SELECTION_VALUE = "selection";

    public MetaDataRecordController(IAdapter.Manager<Object> adapterManager, String name) {
        super(adapterManager, name);
    }

    public MetaDataRecordController(IAdapter.Manager<Object> adapterManager, String name, RECORD_TARGET recordTarget) {
        super(adapterManager, name, recordTarget);
    }

    @Override
    public Object putTarget(String name, Object target) {
        MetaDataBinding<Object> metaDataBinding = new MetaDataBinding<Object>(this, name);
        Object oldTarget = super.putTarget(name, target);
        IAdapter adapter = metaDataBinding.getAdapter();
        if (adapter != null) {
            Object recordActionData;
            Object fieldNameData = metaDataBinding.getMetaData(FIELD_NAME_KEY);
            if (fieldNameData instanceof String) {
                Object bridgeTypeData = metaDataBinding.getMetaData(BRIDGE_TYPE_KEY);
                String bridgeType = bridgeTypeData instanceof String ? (String)bridgeTypeData : null;
                String fieldName = (String)fieldNameData;
                if (BRIDGE_TYPE_TEXT_VALUE.equals(bridgeType) || adapter.hasAspect(ITextViewAspect.class)) {
                    this.addTextBridge(name, fieldName);
                } else if (BRIDGE_TYPE_SELECTION_VALUE.equals(bridgeType) || metaDataBinding.getAdapter().hasAspect(ISelectionViewAspect.class)) {
                    this.addSelectionBridge(name, fieldName);
                }
            }
            if ((recordActionData = metaDataBinding.getMetaData(RECORD_ACTION_KEY)) instanceof String) {
                String recordAction = (String)recordActionData;
                if (adapter.hasAspect(ISelectionViewAspect.class)) {
                    if (RECORD_ACTION_LOAD_VALUE.equals(recordAction)) {
                        this.setLoadBinding(name);
                    } else if (RECORD_ACTION_SAVE_VALUE.equals(recordAction)) {
                        this.setSaveBinding(name);
                    }
                }
            }
        }
        return oldTarget;
    }
}

