/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.net4j.core.BufferPool;
import org.eclipse.net4j.core.impl.BufferImpl;
import org.eclipse.net4j.spring.impl.ServiceImpl;

public class BufferPoolImpl
extends ServiceImpl
implements BufferPool {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    protected int bufferSize = 4096;
    private transient Queue<SoftReference<BufferImpl>> queue = new ConcurrentLinkedQueue<SoftReference<BufferImpl>>();

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.doSet("bufferSize", bufferSize);
    }

    public BufferImpl getBuffer() {
        SoftReference<BufferImpl> ref;
        BufferImpl buffer;
        do {
            if ((ref = this.queue.poll()) != null) continue;
            return this.newBuffer();
        } while ((buffer = ref.get()) == null);
        buffer.clear();
        return buffer;
    }

    public void releaseBuffer(BufferImpl buffer) {
        this.queue.add(new SoftReference<BufferImpl>(buffer));
    }

    protected BufferImpl newBuffer() {
        return new BufferImpl(this.bufferSize);
    }

    protected void deactivate() throws Exception {
        this.queue = null;
        super.deactivate();
    }
}

